/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.placementmodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.worldgen.feature.api.placementmodifier.FrozenPlacementModifiers;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3756;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6661;
import net.minecraft.class_6798;
import org.jetbrains.annotations.NotNull;

public class NoisePlacementFilter
extends class_6661 {
    public static final Codec<NoisePlacementFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)4).fieldOf("noise").orElse((Object)4).forGetter(config -> config.noise), (App)Codec.doubleRange((double)1.0E-4, (double)128.0).fieldOf("noise_scale").orElse((Object)0.05).forGetter(config -> config.noiseScale), (App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("min_threshold").orElse((Object)0.2).forGetter(config -> config.minThreshold), (App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("maxThresh").orElse((Object)1.0).forGetter(config -> config.maxThreshold), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("fade_distance").orElse((Object)0.0).forGetter(config -> config.fadeDistance), (App)Codec.BOOL.fieldOf("use_y").orElse((Object)false).forGetter(config -> config.useY), (App)Codec.BOOL.fieldOf("scale_y").orElse((Object)false).forGetter(config -> config.scaleY), (App)Codec.BOOL.fieldOf("must_be_inside").orElse((Object)false).forGetter(config -> config.mustBeInside)).apply((Applicative)instance, NoisePlacementFilter::new));
    private final int noise;
    private final double noiseScale;
    private final double minThreshold;
    private final double minFadeThreshold;
    private final double maxThreshold;
    private final double maxFadeThreshold;
    private final double fadeDistance;
    private final boolean useY;
    private final boolean scaleY;
    private final boolean mustBeInside;

    public NoisePlacementFilter(int noise, double noiseScale, double minThreshold, double maxThreshold, double fadeDistance, boolean useY, boolean scaleY, boolean mustBeInside) {
        this.noise = noise;
        this.noiseScale = noiseScale;
        this.minThreshold = minThreshold;
        this.maxThreshold = maxThreshold;
        this.fadeDistance = fadeDistance;
        this.minFadeThreshold = minThreshold - fadeDistance;
        this.maxFadeThreshold = maxThreshold + fadeDistance;
        this.useY = useY;
        this.scaleY = scaleY;
        this.mustBeInside = mustBeInside;
        if (this.minThreshold >= this.maxThreshold) {
            throw new IllegalArgumentException("NoisePlacementFilter minThresh cannot be greater than or equal to maxThreshold!");
        }
        if (this.fadeDistance < 0.0) {
            throw new IllegalArgumentException("NoisePlacementFilter fadeDistance cannot be less than 0!");
        }
    }

    protected boolean method_38918(@NotNull class_5444 context, class_5819 random, class_2338 pos) {
        class_5281 level = context.field_25857;
        boolean isInside = false;
        class_3756 sampler = this.noise == 1 ? EasyNoiseSampler.perlinLocal : (this.noise == 2 ? EasyNoiseSampler.perlinChecked : (this.noise == 3 ? EasyNoiseSampler.perlinThreadSafe : EasyNoiseSampler.perlinXoro));
        double sample = EasyNoiseSampler.sample(level, sampler, (class_2382)pos, this.noiseScale, this.scaleY, this.useY);
        if (sample > this.minThreshold && sample < this.maxThreshold) {
            isInside = true;
        }
        if (this.fadeDistance > 0.0) {
            if (sample > this.minFadeThreshold && sample < this.minThreshold) {
                boolean bl = isInside = random.method_43058() > Math.abs((this.minThreshold - sample) / this.fadeDistance);
            }
            if (sample < this.maxFadeThreshold && sample > this.maxThreshold) {
                isInside = random.method_43058() > Math.abs((this.maxThreshold - sample) / this.fadeDistance);
            }
        }
        return this.mustBeInside == isInside;
    }

    public class_6798<?> method_39615() {
        return FrozenPlacementModifiers.NOISE_FILTER;
    }
}

