/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.features;

import com.mojang.serialization.Codec;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.feature.api.features.config.FadingDiskTagFeatureConfig;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

public class FadingDiskWithPileTagFeature
extends class_3031<FadingDiskTagFeatureConfig> {
    public FadingDiskWithPileTagFeature(Codec<FadingDiskTagFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<FadingDiskTagFeatureConfig> context) {
        AtomicBoolean bl = new AtomicBoolean(false);
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        FadingDiskTagFeatureConfig config = (FadingDiskTagFeatureConfig)context.method_33656();
        boolean useHeightMapAndNotCircular = config.useHeightmapInsteadOfCircularPlacement();
        class_2902.class_2903 heightmap = config.heightmap();
        class_2338 s = useHeightMapAndNotCircular ? blockPos.method_33096(level.method_8624(heightmap, blockPos.method_10263(), blockPos.method_10260())) : blockPos;
        class_5819 random = level.method_8409();
        int radius = config.radius().method_35008(random);
        class_2338.class_2339 mutableDisk = s.method_25503();
        int bx = s.method_10263();
        int by = s.method_10264();
        int bz = s.method_10260();
        Consumer<class_1936> consumer = levelAccessor -> {
            for (int x = bx - radius; x <= bx + radius; ++x) {
                for (int z = bz - radius; z <= bz + radius; ++z) {
                    if (useHeightMapAndNotCircular) {
                        boolean fade;
                        double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z);
                        if (!(distance < (double)(radius * radius))) continue;
                        mutableDisk.method_10103(x, level.method_8624(heightmap, x, z) - 1, z);
                        class_2680 state = level.method_8320((class_2338)mutableDisk);
                        boolean inner = mutableDisk.method_19771((class_2382)s, (double)((float)radius * config.innerPercent()));
                        boolean bl2 = fade = !inner && !mutableDisk.method_19771((class_2382)s, (double)((float)radius * config.fadeStartDistancePercent()));
                        if (!(random.method_43057() < config.placementChance())) continue;
                        if (fade) {
                            if (!(random.method_43057() > 0.5f) || !state.method_26164(config.outerReplaceableBlocks())) continue;
                            level.method_8652((class_2338)mutableDisk, config.outerState().method_23455(random, (class_2338)mutableDisk), 3);
                            bl.set(true);
                            continue;
                        }
                        boolean choseInner = inner && random.method_43057() < config.innerChance();
                        if (!state.method_26164(choseInner ? config.innerReplaceableBlocks() : config.outerReplaceableBlocks())) continue;
                        level.method_8652((class_2338)mutableDisk, choseInner ? config.innerState().method_23455(random, (class_2338)mutableDisk) : config.outerState().method_23455(random, (class_2338)mutableDisk), 3);
                        bl.set(true);
                        continue;
                    }
                    for (int y = by - radius; y <= by + radius; ++y) {
                        boolean fade;
                        double distance = (bx - x) * (bx - x) + (by - y) * (by - y) + (bz - z) * (bz - z);
                        if (!(distance < (double)(radius * radius))) continue;
                        mutableDisk.method_10103(x, y, z);
                        class_2680 state = level.method_8320((class_2338)mutableDisk);
                        if (!FadingDiskWithPileTagFeature.isBlockExposedToAir(level, (class_2338)mutableDisk)) continue;
                        boolean inner = mutableDisk.method_19771((class_2382)s, (double)((float)radius * config.innerPercent()));
                        boolean bl3 = fade = !inner && !mutableDisk.method_19771((class_2382)s, (double)((float)radius * config.fadeStartDistancePercent()));
                        if (!(random.method_43057() < config.placementChance())) continue;
                        if (fade) {
                            if (!(random.method_43057() > 0.5f) || !state.method_26164(config.outerReplaceableBlocks())) continue;
                            level.method_8652((class_2338)mutableDisk, config.outerState().method_23455(random, (class_2338)mutableDisk), 3);
                            bl.set(true);
                            continue;
                        }
                        boolean choseInner = inner && random.method_43057() < config.innerChance();
                        if (!state.method_26164(choseInner ? config.innerReplaceableBlocks() : config.outerReplaceableBlocks())) continue;
                        level.method_8652((class_2338)mutableDisk, choseInner ? config.innerState().method_23455(random, (class_2338)mutableDisk) : config.outerState().method_23455(random, (class_2338)mutableDisk), 3);
                        bl.set(true);
                    }
                }
            }
        };
        if (radius < 15) {
            consumer.accept((class_1936)level);
        } else {
            class_3218 serverLevel = level.method_8410();
            serverLevel.method_8503().method_19537(() -> consumer.accept((class_1936)serverLevel));
        }
        bl.set(this.placePile(context) || bl.get());
        return bl.get();
    }

    public static boolean isBlockExposedToAir(class_5281 level, @NotNull class_2338 blockPos) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10098(direction);
            if (level.method_8320((class_2338)mutableBlockPos).method_26215()) {
                return true;
            }
            mutableBlockPos.method_10104(direction, -1);
        }
        return false;
    }

    public boolean placePile(@NotNull class_5821<FadingDiskTagFeatureConfig> context) {
        class_2338 blockPos = context.method_33655();
        class_5281 worldGenLevel = context.method_33652();
        class_5819 randomSource = context.method_33654();
        FadingDiskTagFeatureConfig config = (FadingDiskTagFeatureConfig)context.method_33656();
        if (blockPos.method_10264() < worldGenLevel.method_31607() + 5) {
            return false;
        }
        int i = 2 + randomSource.method_43048(2);
        int j = 2 + randomSource.method_43048(2);
        for (class_2338 blockPos2 : class_2338.method_10097((class_2338)blockPos.method_10069(-i, 0, -j), (class_2338)blockPos.method_10069(i, 1, j))) {
            int l;
            int k = blockPos.method_10263() - blockPos2.method_10263();
            if ((float)(k * k + (l = blockPos.method_10260() - blockPos2.method_10260()) * l) <= randomSource.method_43057() * 10.0f - randomSource.method_43057() * 6.0f) {
                this.tryPlaceBlock((class_1936)worldGenLevel, blockPos2, randomSource, config);
                continue;
            }
            if (!((double)randomSource.method_43057() < 0.031)) continue;
            this.tryPlaceBlock((class_1936)worldGenLevel, blockPos2, randomSource, config);
        }
        return true;
    }

    private boolean mayPlaceOn(@NotNull class_1936 level, @NotNull class_2338 pos, class_5819 random) {
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = level.method_8320(blockPos);
        return blockState.method_27852(class_2246.field_10194) ? random.method_43056() : blockState.method_26206((class_1922)level, blockPos, class_2350.field_11036);
    }

    private void tryPlaceBlock(@NotNull class_1936 level, class_2338 pos, class_5819 random, FadingDiskTagFeatureConfig config) {
        if (level.method_22347(pos) && this.mayPlaceOn(level, pos, random)) {
            level.method_8652(pos, config.innerState().method_23455(random, pos), 4);
        }
    }
}

