/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.features;

import com.mojang.serialization.Codec;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.feature.api.features.config.FadingDiskFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

public class FadingDiskFeature
extends class_3031<FadingDiskFeatureConfig> {
    public FadingDiskFeature(Codec<FadingDiskFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<FadingDiskFeatureConfig> context) {
        AtomicBoolean success = new AtomicBoolean();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        FadingDiskFeatureConfig config = (FadingDiskFeatureConfig)context.method_33656();
        boolean useHeightMapAndNotCircular = config.useHeightmapInsteadOfCircularPlacement();
        class_2902.class_2903 heightmap = config.heightmap();
        class_2338 s = useHeightMapAndNotCircular ? blockPos.method_33096(level.method_8624(heightmap, blockPos.method_10263(), blockPos.method_10260())) : blockPos;
        class_5819 random = level.method_8409();
        int radius = config.radius().method_35008(random);
        class_2338.class_2339 mutableDisk = s.method_25503();
        int bx = s.method_10263();
        int by = s.method_10264();
        int bz = s.method_10260();
        Consumer<class_1936> consumer = levelAccessor -> {
            for (int x = bx - radius; x <= bx + radius; ++x) {
                for (int z = bz - radius; z <= bz + radius; ++z) {
                    if (useHeightMapAndNotCircular) {
                        double distance = Math.pow((double)bx - (double)x, 2.0) + Math.pow((double)bz - (double)z, 2.0);
                        success.set(FadingDiskFeature.placeAtPos(level, config, s, random, radius, mutableDisk, x, level.method_8624(heightmap, x, z) - 1, z, distance, true));
                        continue;
                    }
                    int maxY = by + radius;
                    for (int y = by - radius; y <= maxY; ++y) {
                        double distance = Math.pow((double)bx - (double)x, 2.0) + Math.pow((double)by - (double)y, 2.0) + Math.pow((double)bz - (double)z, 2.0);
                        success.set(FadingDiskFeature.placeAtPos(level, config, s, random, radius, mutableDisk, x, y, z, distance, false));
                    }
                }
            }
        };
        if (radius < 15) {
            consumer.accept((class_1936)level);
        } else {
            class_3218 serverLevel = level.method_8410();
            serverLevel.method_8503().method_19537(() -> consumer.accept((class_1936)serverLevel));
        }
        return success.get();
    }

    private static boolean placeAtPos(class_5281 level, FadingDiskFeatureConfig config, class_2338 s, class_5819 random, int radius, class_2338.class_2339 mutableDisk, int x, int y, int z, double distance, boolean useHeightMapAndNotCircular) {
        if (distance < Math.pow(radius, 2.0)) {
            mutableDisk.method_10103(x, y, z);
            class_2680 state = level.method_8320((class_2338)mutableDisk);
            if (!useHeightMapAndNotCircular && FadingDiskFeature.isBlockExposed(level, (class_2338)mutableDisk)) {
                boolean fade;
                boolean inner = mutableDisk.method_19771((class_2382)s, (double)((float)radius * config.innerChance()));
                boolean bl = fade = !inner && !mutableDisk.method_19771((class_2382)s, (double)((float)radius * config.fadeStartDistancePercent()));
                if (random.method_43057() < config.placementChance()) {
                    if (fade) {
                        if (random.method_43057() > 0.5f && state.method_40143(config.outerReplaceableBlocks())) {
                            level.method_8652((class_2338)mutableDisk, config.outerState().method_23455(random, (class_2338)mutableDisk), 3);
                            return true;
                        }
                    } else {
                        boolean choseInner = inner && random.method_43057() < config.innerChance();
                        if (state.method_40143(choseInner ? config.innerReplaceableBlocks() : config.outerReplaceableBlocks())) {
                            class_4651 newState = choseInner ? config.innerState() : config.outerState();
                            level.method_8652((class_2338)mutableDisk, newState.method_23455(random, (class_2338)mutableDisk), 3);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean isBlockExposed(class_5281 level, @NotNull class_2338 blockPos) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10098(direction);
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
            if (blockState.method_26215() || blockState.method_26164(class_3481.field_21952)) {
                return true;
            }
            mutableBlockPos.method_10104(direction, -1);
        }
        return false;
    }
}

