/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.features;

import com.mojang.serialization.Codec;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.feature.api.features.config.CurvingTunnelFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;

public class CurvingTunnelFeature
extends class_3031<CurvingTunnelFeatureConfig> {
    public CurvingTunnelFeature(Codec<CurvingTunnelFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<CurvingTunnelFeatureConfig> context) {
        AtomicBoolean generated = new AtomicBoolean(false);
        CurvingTunnelFeatureConfig config = (CurvingTunnelFeatureConfig)context.method_33656();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        int radius = config.radius();
        int radiusSquared = radius * radius;
        class_5819 random = level.method_8409();
        double curvatureDifference = config.maxCurvature() - config.minCurvature();
        if (curvatureDifference < 0.0) {
            throw new UnsupportedOperationException("minCurvature can not be higher than maxCurvature!");
        }
        int bx = blockPos.method_10263();
        int by = blockPos.method_10264();
        int bz = blockPos.method_10260();
        class_2338.class_2339 mutable = blockPos.method_25503();
        class_2338 endPos = level.method_8598(class_2902.class_2903.field_13195, blockPos);
        int endY = endPos.method_10264();
        int yDifference = endY - by;
        double xCurvature = (random.method_43058() * curvatureDifference + config.minCurvature()) * (double)(random.method_43056() ? 1 : -1);
        double zCurvature = (random.method_43058() * curvatureDifference + config.minCurvature()) * (double)(random.method_43056() ? 1 : -1);
        Consumer<class_1936> consumer = levelAccessor -> {
            for (int yOffset = 0; yOffset < yDifference; ++yOffset) {
                int y = by + yOffset;
                double curvatureProgress = Math.sin((double)yOffset / (double)yDifference * Math.PI);
                int xOffset = (int)(curvatureProgress * xCurvature);
                int zOffset = (int)(curvatureProgress * zCurvature);
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        double distance = -x * -x + -z * -z;
                        if (!(distance <= (double)radiusSquared)) continue;
                        mutable.method_10103(bx + x, y, bz + z);
                        mutable.method_10100(xOffset, 0, zOffset);
                        if (!level.method_8320((class_2338)mutable).method_26164(config.replaceableBlocks())) continue;
                        level.method_8652((class_2338)mutable, config.state().method_23455(random, (class_2338)mutable), 3);
                        generated.set(true);
                    }
                }
            }
        };
        if (yDifference > 0) {
            level.method_8503().method_19537(() -> consumer.accept((class_1936)level.method_8410()));
        }
        return generated.get();
    }
}

