/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.biome.api.parameters;

import java.util.List;
import net.minecraft.class_6544;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class FrozenBiomeParameters {
    private FrozenBiomeParameters() {
        throw new UnsupportedOperationException("FrozenBiomeParameters contains only static declarations.");
    }

    public static void addWeirdness(BiomeRunnable runnable, @NotNull List<class_6544.class_6546> weirdnesses) {
        for (class_6544.class_6546 weirdness : weirdnesses) {
            runnable.run(weirdness);
        }
    }

    @NotNull
    public static class_6544.class_6546 inBetween(class_6544.class_6546 par1, class_6544.class_6546 par2, float width) {
        float highest;
        if (width >= 1.0f || width <= 0.0f) {
            throw new UnsupportedOperationException("FrozenLib: Cannot run inBetween if width >= 1 or width <= 0!");
        }
        width *= 0.5f;
        float lowest = par1.comp_103();
        if (lowest > (highest = (float)par2.comp_104())) {
            throw new UnsupportedOperationException("FrozenLib: Cannot run inBetween when lower parameter is higher than the first!");
        }
        float difference = highest - lowest;
        float middle = lowest + difference * 0.5f;
        float offset = difference * width;
        return class_6544.class_6546.method_38121((float)(middle - offset), (float)(middle + offset));
    }

    @NotNull
    public static class_6544.class_6546 inBetweenLowCutoff(class_6544.class_6546 par1, class_6544.class_6546 par2, float width) {
        float highest;
        if (width >= 1.0f || width <= 0.0f) {
            throw new UnsupportedOperationException("FrozenLib: Cannot run inBetweenLowCutoff if width >= 1 or width <= 0!");
        }
        width *= 0.5f;
        float lowest = par1.comp_103();
        if (lowest > (highest = (float)par2.comp_104())) {
            throw new UnsupportedOperationException("FrozenLib: Cannot run inBetweenLowCutoff when lower parameter is higher than the first!");
        }
        float difference = highest - lowest;
        float middle = lowest + difference * 0.5f;
        float offset = difference * width;
        return class_6544.class_6546.method_38121((float)lowest, (float)(middle - offset));
    }

    @NotNull
    public static class_6544.class_6546 inBetweenHighCutoff(class_6544.class_6546 par1, class_6544.class_6546 par2, float width) {
        float highest;
        if (width >= 1.0f || width <= 0.0f) {
            throw new UnsupportedOperationException("FrozenLib: Cannot run inBetweenHighCutoff if width >= 1 or width <= 0!");
        }
        width *= 0.5f;
        float lowest = par1.comp_103();
        if (lowest > (highest = (float)par2.comp_104())) {
            throw new UnsupportedOperationException("FrozenLib: Cannot run inBetweenHighCutoff when lower parameter is higher than the first!");
        }
        float difference = highest - lowest;
        float middle = lowest + difference * 0.5f;
        float offset = difference * width;
        return class_6544.class_6546.method_38121((float)(middle + offset), (float)highest);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static class_6544.class_6546 squish(@NotNull class_6544.class_6546 parameter, float squish) {
        return class_6544.class_6546.method_38121((float)((float)parameter.comp_103() + squish), (float)((float)parameter.comp_104() - squish));
    }

    public static boolean isWeird(@NotNull class_6544.class_4762 point) {
        return point.comp_110().comp_104() < 0L;
    }

    @FunctionalInterface
    public static interface BiomeRunnable {
        public void run(class_6544.class_6546 var1);
    }
}

