/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.wind.api;

import java.util.Optional;
import net.frozenblock.lib.registry.api.FrozenRegistry;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.impl.networking.WindDisturbancePacket;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class WindDisturbance<T> {
    public static final DisturbanceResult DUMMY_RESULT = new DisturbanceResult(0.0, 0.0, class_243.field_1353);
    private final Optional<T> source;
    public final class_243 origin;
    private final class_238 affectedArea;
    private final WindDisturbanceLogic<T> disturbanceLogic;

    public WindDisturbance(Optional<T> source, class_243 origin, class_238 affectedArea, WindDisturbanceLogic<T> disturbanceLogic) {
        this.source = source;
        this.origin = origin;
        this.affectedArea = affectedArea;
        this.disturbanceLogic = disturbanceLogic;
    }

    public DisturbanceResult calculateDisturbanceResult(class_1937 level, class_243 windTarget) {
        DisturbanceResult disturbanceResult;
        if (this.affectedArea.method_1006(windTarget) && (disturbanceResult = this.disturbanceLogic.getLogic().calculateDisturbanceResult(this.source, level, this.origin, this.affectedArea, windTarget)) != null) {
            return disturbanceResult;
        }
        return DUMMY_RESULT;
    }

    public Optional<WindDisturbancePacket> toPacket() {
        class_2960 resourceLocation = Optional.ofNullable(FrozenRegistry.WIND_DISTURBANCE_LOGIC.method_10221(this.disturbanceLogic)).orElseGet(() -> FrozenRegistry.WIND_DISTURBANCE_LOGIC_UNSYNCED.method_10221(this.disturbanceLogic));
        if (resourceLocation != null) {
            return Optional.of(new WindDisturbancePacket(this.affectedArea, this.origin, this.getSourceTypeFromSource(), resourceLocation, this.encodePosOrID()));
        }
        return Optional.empty();
    }

    private WindDisturbanceLogic.SourceType getSourceTypeFromSource() {
        if (this.source.isPresent()) {
            if (this.source.get() instanceof class_1297) {
                return WindDisturbanceLogic.SourceType.ENTITY;
            }
            if (this.source.get() instanceof class_2586) {
                return WindDisturbanceLogic.SourceType.BLOCK_ENTITY;
            }
        }
        return WindDisturbanceLogic.SourceType.NONE;
    }

    private long encodePosOrID() {
        if (this.source.isPresent()) {
            T t = this.source.get();
            if (t instanceof class_1297) {
                class_1297 entity = (class_1297)t;
                return entity.method_5628();
            }
            t = this.source.get();
            if (t instanceof class_2586) {
                class_2586 blockEntity = (class_2586)t;
                return blockEntity.method_11016().method_10063();
            }
        }
        return 0L;
    }

    public record DisturbanceResult(double strength, double weight, class_243 wind) {
    }
}

