/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.stencil.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.entity.api.rendering.FrozenRenderType;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import org.apache.commons.compress.utils.Lists;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class StencilRenderer {
    private static final class_1921[] DYNAMIC_LIGHT = new class_1921[]{FrozenRenderType.dynamicLightStencil(), FrozenRenderType.dynamicLightColor()};
    public static final Triangle[] FACES_SPHERE = StencilRenderer.createNSphere(2);
    public static final Triangle[] FACES_CONE = StencilRenderer.createNCone(12);

    public static void render(Triangle[] triangles, Matrix4f matrix4f, class_4597 multiBufferSource, int i) {
        int j = class_5253.class_5254.method_27765((int)i);
        int k = class_5253.class_5254.method_27766((int)i);
        int l = class_5253.class_5254.method_27767((int)i);
        int m = class_5253.class_5254.method_27762((int)i);
        for (class_1921 renderType : DYNAMIC_LIGHT) {
            class_4588 vertexConsumer = multiBufferSource.getBuffer(renderType);
            for (Triangle triangle : triangles) {
                vertexConsumer.method_22918(matrix4f, triangle.p0.x, triangle.p0.y, triangle.p0.z).method_1336(j, k, l, m).method_1344();
                vertexConsumer.method_22918(matrix4f, triangle.p2.x, triangle.p2.y, triangle.p2.z).method_1336(j, k, l, m).method_1344();
                vertexConsumer.method_22918(matrix4f, triangle.p1.x, triangle.p1.y, triangle.p1.z).method_1336(j, k, l, m).method_1344();
            }
        }
    }

    private static List<Triangle> makeOctahedron() {
        float f = (float)(1.0 / Math.sqrt(2.0));
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, -1.0f).mul(f), new Vector3f(1.0f, 0.0f, -1.0f).mul(f), new Vector3f(1.0f, 0.0f, 1.0f).mul(f), new Vector3f(-1.0f, 0.0f, 1.0f).mul(f)};
        ArrayList list = Lists.newArrayList();
        list.add(new Triangle(vector3fs[0], vector3fs[3], vector3fs[4]));
        list.add(new Triangle(vector3fs[0], vector3fs[4], vector3fs[5]));
        list.add(new Triangle(vector3fs[0], vector3fs[5], vector3fs[2]));
        list.add(new Triangle(vector3fs[0], vector3fs[2], vector3fs[3]));
        list.add(new Triangle(vector3fs[1], vector3fs[4], vector3fs[3]));
        list.add(new Triangle(vector3fs[1], vector3fs[5], vector3fs[4]));
        list.add(new Triangle(vector3fs[1], vector3fs[2], vector3fs[5]));
        list.add(new Triangle(vector3fs[1], vector3fs[3], vector3fs[2]));
        return list;
    }

    public static Triangle[] createNSphere(int i) {
        List<Triangle> list = StencilRenderer.makeOctahedron();
        for (int j = 0; j < i; ++j) {
            int k = list.size();
            for (int l = 0; l < k; ++l) {
                list.addAll(list.remove(0).subdivideSpherical());
            }
        }
        return list.toArray(new Triangle[0]);
    }

    public static Triangle[] createNCone(int i) {
        float f = (float)Math.PI * 2 / (float)i;
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < i; ++j) {
            list.add(new Vector3f(class_3532.method_15362((float)((float)j * f)), 0.0f, class_3532.method_15374((float)((float)j * f))));
        }
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, -1.0f, 0.0f);
        ArrayList list2 = Lists.newArrayList();
        for (int k = 0; k < i; ++k) {
            list2.add(new Triangle((Vector3f)list.get(k), (Vector3f)list.get((k + 1) % i), vector3f));
            list2.add(new Triangle((Vector3f)list.get((k + 1) % i), (Vector3f)list.get(k), vector3f2));
        }
        return list2.toArray(new Triangle[0]);
    }

    @Environment(value=EnvType.CLIENT)
    public record Triangle(Vector3f p0, Vector3f p1, Vector3f p2) {
        Collection<Triangle> subdivideSpherical() {
            Vector3f vector3f = this.p0.add((Vector3fc)this.p1, new Vector3f()).div(2.0f).normalize();
            Vector3f vector3f2 = this.p1.add((Vector3fc)this.p2, new Vector3f()).div(2.0f).normalize();
            Vector3f vector3f3 = this.p2.add((Vector3fc)this.p0, new Vector3f()).div(2.0f).normalize();
            return List.of(new Triangle(this.p0, vector3f, vector3f3), new Triangle(vector3f, this.p1, vector3f2), new Triangle(vector3f2, this.p2, vector3f3), new Triangle(vector3f, vector3f2, vector3f3));
        }
    }
}

