/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.impl.block_sound_group;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.frozenblock.lib.FrozenLogUtils;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.sound.api.block_sound_group.BlockSoundGroupOverwrite;
import net.frozenblock.lib.sound.api.block_sound_group.SoundCodecs;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class BlockSoundGroupManager
implements SimpleResourceReloadListener<SoundGroupLoader> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FrozenLib Block Sound Group Manager");
    private static final String DIRECTORY = "blocksoundoverwrites";
    public static final BlockSoundGroupManager INSTANCE = new BlockSoundGroupManager();
    private Map<class_2960, BlockSoundGroupOverwrite> overwrites;
    private final Map<class_2960, BlockSoundGroupOverwrite> queuedOverwrites = new Object2ObjectOpenHashMap();

    @Nullable
    public List<BlockSoundGroupOverwrite> getOverwrites() {
        if (this.overwrites != null) {
            return this.overwrites.values().stream().toList();
        }
        return null;
    }

    @Nullable
    public BlockSoundGroupOverwrite getOverwrite(class_2960 id) {
        return this.overwrites.get(id);
    }

    public void addBlock(class_2960 key, class_2498 sounds, BooleanSupplier condition) {
        if (!class_7923.field_41175.method_10250(key)) {
            FrozenLogUtils.log("Error whilst adding a block to BlockSoundGroupOverwrites: The specified block id has not been added to the Registry", true);
        } else {
            this.queuedOverwrites.put(BlockSoundGroupManager.getPath(key), new BlockSoundGroupOverwrite(key, sounds, condition));
        }
    }

    public void addBlock(String id, class_2498 sounds, BooleanSupplier condition) {
        class_2960 key = new class_2960(id);
        this.addBlock(key, sounds, condition);
    }

    public void addBlock(String namespace, String id, class_2498 sounds, BooleanSupplier condition) {
        class_2960 key = new class_2960(namespace, id);
        this.addBlock(key, sounds, condition);
    }

    public void addBlock(class_2248 block, class_2498 sounds, BooleanSupplier condition) {
        class_2960 key = class_7923.field_41175.method_10221((Object)block);
        this.addBlock(key, sounds, condition);
    }

    public void addBlocks(class_2248[] blocks, class_2498 sounds, BooleanSupplier condition) {
        for (class_2248 block : blocks) {
            class_2960 key = class_7923.field_41175.method_10221((Object)block);
            this.addBlock(key, sounds, condition);
        }
    }

    public void addBlockTag(class_6862<class_2248> tag, class_2498 sounds, BooleanSupplier condition) {
        Optional tagIterable = class_7923.field_41175.method_40266(tag);
        if (tagIterable.isEmpty()) {
            FrozenLogUtils.log("Error whilst adding a tag to BlockSoundGroupOverwrites: Tag is invalid", true);
        } else {
            for (class_6880 block : (class_6885.class_6888)tagIterable.get()) {
                class_2960 key = ((class_5321)block.method_40230().orElseThrow()).method_29177();
                this.addBlock(key, sounds, condition);
            }
        }
    }

    public static class_2960 getPath(class_2960 blockId) {
        return new class_2960(blockId.method_12836(), "blocksoundoverwrites/" + blockId.method_12832() + ".json");
    }

    public CompletableFuture<SoundGroupLoader> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> new SoundGroupLoader(manager, profiler), executor);
    }

    public CompletableFuture<Void> apply(SoundGroupLoader prepared, class_3300 manager, class_3695 profiler, Executor executor) {
        this.overwrites = prepared.getOverwrites();
        this.overwrites.putAll(this.queuedOverwrites);
        return CompletableFuture.runAsync(() -> {});
    }

    @NotNull
    public class_2960 getFabricId() {
        return FrozenSharedConstants.id("block_sound_group_reloader");
    }

    public static class SoundGroupLoader {
        private final class_3300 manager;
        private final class_3695 profiler;
        private final Map<class_2960, BlockSoundGroupOverwrite> overwrites = new Object2ObjectOpenHashMap();

        public SoundGroupLoader(class_3300 manager, class_3695 profiler) {
            this.manager = manager;
            this.profiler = profiler;
            this.loadSoundOverwrites();
        }

        private void loadSoundOverwrites() {
            this.profiler.method_15396("Load Sound Overwrites");
            Map resources = this.manager.method_14488(BlockSoundGroupManager.DIRECTORY, id -> id.method_12832().endsWith(".json"));
            Set entrySet = resources.entrySet();
            for (Map.Entry entry : entrySet) {
                this.addOverwrite((class_2960)entry.getKey(), (class_3298)entry.getValue());
            }
            this.profiler.method_15407();
        }

        private void addOverwrite(class_2960 id, class_3298 resource) {
            BufferedReader reader;
            try {
                reader = resource.method_43039();
            }
            catch (IOException e) {
                LOGGER.error(String.format("Unable to open BufferedReader for id %s", id), (Throwable)e);
                return;
            }
            JsonObject json = class_3518.method_15255((Reader)reader);
            DataResult result = SoundCodecs.SOUND_GROUP_OVERWRITE.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            if (result.error().isPresent()) {
                LOGGER.error(String.format("Unable to parse sound overwrite file %s. \nReason: %s", id, ((DataResult.PartialResult)result.error().get()).message()));
                return;
            }
            class_2960 overwriteId = new class_2960(id.method_12836(), id.method_12832().substring("blocksoundoverwrites/".length()));
            this.overwrites.put(overwriteId, (BlockSoundGroupOverwrite)((Pair)result.result().orElseThrow()).getFirst());
        }

        public Map<class_2960, BlockSoundGroupOverwrite> getOverwrites() {
            return this.overwrites;
        }
    }
}

