/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api.damagesource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.frozenblock.lib.FrozenSharedConstants;
import net.minecraft.class_1282;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public final class PlayerDamageSourceSounds {
    private static final Map<class_1282, class_2960> DAMAGE_SOURCE_RESOURCE_LOCATION_MAP = new Object2ObjectOpenHashMap();
    private static final Map<class_2960, class_3414> RESOURCE_LOCATION_SOUND_EVENT_MAP = new Object2ObjectOpenHashMap();
    private static final class_2960 DEFAULT_ID = FrozenSharedConstants.id("default_damage_source");

    private PlayerDamageSourceSounds() {
        throw new UnsupportedOperationException("PlayerDamageSourceSounds contains only static declarations.");
    }

    public static void addDamageSound(class_1282 source, class_3414 sound, class_2960 registry) {
        DAMAGE_SOURCE_RESOURCE_LOCATION_MAP.put(source, registry);
        RESOURCE_LOCATION_SOUND_EVENT_MAP.put(registry, sound);
    }

    public static class_3414 getDamageSound(class_1282 source) {
        return DAMAGE_SOURCE_RESOURCE_LOCATION_MAP.containsKey(source) ? PlayerDamageSourceSounds.getDamageSound(DAMAGE_SOURCE_RESOURCE_LOCATION_MAP.get(source)) : class_3417.field_15115;
    }

    public static class_3414 getDamageSound(class_2960 location) {
        return RESOURCE_LOCATION_SOUND_EVENT_MAP.getOrDefault(location, class_3417.field_15115);
    }

    public static class_2960 getDamageID(class_1282 source) {
        return DAMAGE_SOURCE_RESOURCE_LOCATION_MAP.getOrDefault(source, DEFAULT_ID);
    }

    public static boolean containsSource(class_1282 source) {
        return DAMAGE_SOURCE_RESOURCE_LOCATION_MAP.containsKey(source);
    }

    public static boolean containsSource(class_2960 location) {
        return RESOURCE_LOCATION_SOUND_EVENT_MAP.containsKey(location);
    }
}

