/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.sound.api.FrozenSoundPackets;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class MovingLoopingFadingDistanceSoundEntityManager {
    private final ArrayList<FadingDistanceSoundLoopNBT> sounds = new ArrayList();
    public final class_1297 entity;

    public MovingLoopingFadingDistanceSoundEntityManager(class_1297 entity) {
        this.entity = entity;
    }

    public void load(class_2487 nbt) {
        if (nbt.method_10573("frozenDistanceSounds", 9)) {
            this.sounds.clear();
            DataResult var10000 = FadingDistanceSoundLoopNBT.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10554("frozenDistanceSounds", 10)));
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            Optional list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            if (list.isPresent()) {
                List allSounds = (List)list.get();
                this.sounds.addAll(allSounds);
            }
        }
    }

    public void save(class_2487 nbt) {
        DataResult var10000 = FadingDistanceSoundLoopNBT.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.sounds);
        NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(cursorsNbt -> nbt.method_10566("frozenDistanceSounds", cursorsNbt));
    }

    public void addSound(class_2960 soundID, class_2960 soundID2, class_3419 category, float volume, float pitch, class_2960 restrictionId, boolean stopOnDeath, float fadeDist, float maxDist) {
        this.sounds.add(new FadingDistanceSoundLoopNBT(soundID, soundID2, category, volume, pitch, restrictionId, stopOnDeath, fadeDist, maxDist));
        SoundPredicate.getPredicate(restrictionId).onStart(this.entity);
    }

    public ArrayList<FadingDistanceSoundLoopNBT> getSounds() {
        return this.sounds;
    }

    public void tick() {
        if (!this.sounds.isEmpty()) {
            ArrayList<FadingDistanceSoundLoopNBT> soundsToRemove = new ArrayList<FadingDistanceSoundLoopNBT>();
            for (FadingDistanceSoundLoopNBT nbt : this.sounds) {
                SoundPredicate.LoopPredicate<class_1297> predicate = SoundPredicate.getPredicate(nbt.restrictionID);
                if (predicate.test(this.entity)) continue;
                soundsToRemove.add(nbt);
                predicate.onStop(this.entity);
            }
            this.sounds.removeAll(soundsToRemove);
        }
    }

    public void syncWithPlayer(class_3222 serverPlayer) {
        for (FadingDistanceSoundLoopNBT nbt : this.getSounds()) {
            FrozenSoundPackets.createMovingRestrictionLoopingFadingDistanceSound(serverPlayer, this.entity, (class_3414)class_7923.field_41172.method_10223(nbt.getSoundEventID()), (class_3414)class_7923.field_41172.method_10223(nbt.getSound2EventID()), (class_3419)class_3419.valueOf(class_3419.class, (String)nbt.getOrdinal()), nbt.volume, nbt.pitch, nbt.restrictionID, nbt.stopOnDeath, nbt.fadeDist, nbt.maxDist);
        }
    }

    public static class FadingDistanceSoundLoopNBT {
        public final class_2960 soundEventID;
        public final class_2960 sound2EventID;
        public final String categoryOrdinal;
        public final float volume;
        public final float pitch;
        public final float fadeDist;
        public final float maxDist;
        public final class_2960 restrictionID;
        public final boolean stopOnDeath;
        public static final Codec<FadingDistanceSoundLoopNBT> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("soundEventID").forGetter(FadingDistanceSoundLoopNBT::getSoundEventID), (App)class_2960.field_25139.fieldOf("sound2EventID").forGetter(FadingDistanceSoundLoopNBT::getSound2EventID), (App)Codec.STRING.fieldOf("categoryOrdinal").forGetter(FadingDistanceSoundLoopNBT::getOrdinal), (App)Codec.FLOAT.fieldOf("volume").forGetter(FadingDistanceSoundLoopNBT::getVolume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(FadingDistanceSoundLoopNBT::getPitch), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(FadingDistanceSoundLoopNBT::getRestrictionID), (App)Codec.BOOL.fieldOf("stopOnDeath").forGetter(FadingDistanceSoundLoopNBT::getStopOnDeath), (App)Codec.FLOAT.fieldOf("fadeDist").forGetter(FadingDistanceSoundLoopNBT::getFadeDist), (App)Codec.FLOAT.fieldOf("maxDist").forGetter(FadingDistanceSoundLoopNBT::getMaxDist)).apply((Applicative)instance, FadingDistanceSoundLoopNBT::new));

        public FadingDistanceSoundLoopNBT(class_2960 soundEventID, class_2960 sound2EventID, String ordinal, float vol, float pitch, class_2960 restrictionID, boolean stopOnDeath, float fadeDist, float maxDist) {
            this.soundEventID = soundEventID;
            this.sound2EventID = sound2EventID;
            this.categoryOrdinal = ordinal;
            this.volume = vol;
            this.pitch = pitch;
            this.restrictionID = restrictionID;
            this.stopOnDeath = stopOnDeath;
            this.fadeDist = fadeDist;
            this.maxDist = maxDist;
        }

        public FadingDistanceSoundLoopNBT(class_2960 soundEventID, class_2960 sound2EventID, class_3419 category, float vol, float pitch, class_2960 restrictionID, boolean stopOnDeath, float fadeDist, float maxDist) {
            this.soundEventID = soundEventID;
            this.sound2EventID = sound2EventID;
            this.categoryOrdinal = category.toString();
            this.volume = vol;
            this.pitch = pitch;
            this.restrictionID = restrictionID;
            this.stopOnDeath = stopOnDeath;
            this.fadeDist = fadeDist;
            this.maxDist = maxDist;
        }

        public class_2960 getSoundEventID() {
            return this.soundEventID;
        }

        public class_2960 getSound2EventID() {
            return this.sound2EventID;
        }

        public String getOrdinal() {
            return this.categoryOrdinal;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getFadeDist() {
            return this.fadeDist;
        }

        public float getMaxDist() {
            return this.maxDist;
        }

        public class_2960 getRestrictionID() {
            return this.restrictionID;
        }

        public boolean getStopOnDeath() {
            return this.stopOnDeath;
        }
    }
}

