/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api;

import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.lib.sound.api.networking.FlyBySoundPacket;
import net.frozenblock.lib.sound.api.networking.LocalPlayerSoundPacket;
import net.frozenblock.lib.sound.api.networking.LocalSoundPacket;
import net.frozenblock.lib.sound.api.networking.MovingRestrictionSoundPacket;
import net.frozenblock.lib.sound.api.networking.StartingMovingRestrictionSoundLoopPacket;
import net.frozenblock.lib.sound.impl.EntityLoopingFadingDistanceSoundInterface;
import net.frozenblock.lib.sound.impl.EntityLoopingSoundInterface;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public final class FrozenSoundPackets {
    private FrozenSoundPackets() {
        throw new UnsupportedOperationException("FrozenSoundPackets contains only static declarations.");
    }

    public static void createLocalSound(@NotNull class_1937 level, class_2338 pos, class_3414 sound, class_3419 source, float volume, float pitch, boolean distanceDelay) {
        if (!level.field_9236) {
            LocalSoundPacket packet = new LocalSoundPacket(pos.method_10263(), pos.method_10264(), pos.method_10260(), sound, source, volume, pitch, distanceDelay);
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)level), (class_2338)pos)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
        }
    }

    public static void createLocalSound(@NotNull class_1937 level, double x, double y, double z, class_3414 sound, class_3419 source, float volume, float pitch, boolean distanceDelay) {
        if (!level.field_9236) {
            LocalSoundPacket packet = new LocalSoundPacket(x, y, z, sound, source, volume, pitch, distanceDelay);
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)level), (class_2338)class_2338.method_49637((double)x, (double)y, (double)z))) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
        }
    }

    public static void createFlybySound(@NotNull class_1937 world, class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch) {
        if (!world.field_9236) {
            FlyBySoundPacket packet = new FlyBySoundPacket(entity.method_5628(), sound, category, volume, pitch);
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)packet);
            }
        }
    }

    public static void createMovingRestrictionSound(@NotNull class_1937 world, class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath) {
        if (!world.field_9236) {
            MovingRestrictionSoundPacket packet = new MovingRestrictionSoundPacket(entity.method_5628(), sound, category, volume, pitch, predicate, stopOnDeath, false);
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)packet);
            }
        }
    }

    public static void createMovingRestrictionLoopingSound(@NotNull class_1937 world, class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath) {
        if (!world.field_9236) {
            MovingRestrictionSoundPacket packet = new MovingRestrictionSoundPacket(entity.method_5628(), sound, category, volume, pitch, predicate, stopOnDeath, true);
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)packet);
            }
            ((EntityLoopingSoundInterface)entity).addSound(class_7923.field_41172.method_10221((Object)sound), category, volume, pitch, predicate, stopOnDeath);
        }
    }

    public static void createMovingRestrictionLoopingSound(class_3222 player, @NotNull class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch, class_2960 id, boolean stopOnDeath) {
        MovingRestrictionSoundPacket packet = new MovingRestrictionSoundPacket(entity.method_5628(), sound, category, volume, pitch, id, stopOnDeath, true);
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
    }

    public static void createMovingRestrictionLoopingFadingDistanceSound(@NotNull class_1937 world, class_1297 entity, class_3414 sound, class_3414 sound2, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath, float fadeDist, float maxDist) {
        if (!world.field_9236) {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.method_10804(entity.method_5628());
            byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound);
            byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound2);
            byteBuf.method_10817((Enum)category);
            byteBuf.writeFloat(volume);
            byteBuf.writeFloat(pitch);
            byteBuf.writeFloat(fadeDist);
            byteBuf.writeFloat(maxDist);
            byteBuf.method_10812(predicate);
            byteBuf.writeBoolean(stopOnDeath);
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)FrozenNetworking.MOVING_RESTRICTION_LOOPING_FADING_DISTANCE_SOUND_PACKET, (class_2540)byteBuf);
            }
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)FrozenNetworking.MOVING_RESTRICTION_LOOPING_FADING_DISTANCE_SOUND_PACKET, (class_2540)byteBuf);
            }
            ((EntityLoopingFadingDistanceSoundInterface)entity).addFadingDistanceSound(class_7923.field_41172.method_10221((Object)sound), class_7923.field_41172.method_10221((Object)sound2), category, volume, pitch, predicate, stopOnDeath, fadeDist, maxDist);
        }
    }

    public static void createMovingRestrictionLoopingFadingDistanceSound(class_3222 player, @NotNull class_1297 entity, class_3414 sound, class_3414 sound2, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath, float fadeDist, float maxDist) {
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        byteBuf.method_10804(entity.method_5628());
        byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound);
        byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound2);
        byteBuf.method_10817((Enum)category);
        byteBuf.writeFloat(volume);
        byteBuf.writeFloat(pitch);
        byteBuf.writeFloat(fadeDist);
        byteBuf.writeFloat(maxDist);
        byteBuf.method_10812(predicate);
        byteBuf.writeBoolean(stopOnDeath);
        ServerPlayNetworking.send((class_3222)player, (class_2960)FrozenNetworking.MOVING_RESTRICTION_LOOPING_FADING_DISTANCE_SOUND_PACKET, (class_2540)byteBuf);
    }

    public static void createMovingRestrictionFadingDistanceSound(class_3222 player, @NotNull class_1297 entity, class_3414 sound, class_3414 sound2, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath, float fadeDist, float maxDist) {
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        byteBuf.method_10804(entity.method_5628());
        byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound);
        byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound2);
        byteBuf.method_10817((Enum)category);
        byteBuf.writeFloat(volume);
        byteBuf.writeFloat(pitch);
        byteBuf.writeFloat(fadeDist);
        byteBuf.writeFloat(maxDist);
        byteBuf.method_10812(predicate);
        byteBuf.writeBoolean(stopOnDeath);
        ServerPlayNetworking.send((class_3222)player, (class_2960)FrozenNetworking.MOVING_FADING_DISTANCE_SOUND_PACKET, (class_2540)byteBuf);
    }

    public static void createFadingDistanceSound(@NotNull class_1937 world, Vector3d pos, class_3414 sound, class_3414 sound2, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath, float fadeDist, float maxDist) {
        if (!world.field_9236) {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.writeDouble(pos.x);
            byteBuf.writeDouble(pos.y);
            byteBuf.writeDouble(pos.z);
            byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound);
            byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound2);
            byteBuf.method_10817((Enum)category);
            byteBuf.writeFloat(volume);
            byteBuf.writeFloat(pitch);
            byteBuf.writeFloat(fadeDist);
            byteBuf.writeFloat(maxDist);
            byteBuf.method_10812(predicate);
            byteBuf.writeBoolean(stopOnDeath);
            for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)class_2338.method_49637((double)pos.x, (double)pos.y, (double)pos.z))) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)FrozenNetworking.FADING_DISTANCE_SOUND_PACKET, (class_2540)byteBuf);
            }
        }
    }

    public static void createStartingMovingRestrictionLoopingSound(@NotNull class_1937 world, class_1297 entity, class_3414 startingSound, class_3414 sound, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath) {
        if (!world.field_9236) {
            StartingMovingRestrictionSoundLoopPacket packet = new StartingMovingRestrictionSoundLoopPacket(entity.method_5628(), startingSound, sound, category, volume, pitch, predicate, stopOnDeath);
            for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)packet);
            }
            ((EntityLoopingSoundInterface)entity).addSound(class_7923.field_41172.method_10221((Object)sound), category, volume, pitch, predicate, stopOnDeath);
        }
    }

    public static void createStartingMovingRestrictionLoopingSound(class_3222 player, @NotNull class_1297 entity, class_3414 startingSound, class_3414 sound, class_3419 category, float volume, float pitch, class_2960 predicate, boolean stopOnDeath) {
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        byteBuf.method_10804(entity.method_5628());
        byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)startingSound);
        byteBuf.method_42065((class_2359)class_7923.field_41172, (Object)sound);
        byteBuf.method_10817((Enum)category);
        byteBuf.writeFloat(volume);
        byteBuf.writeFloat(pitch);
        byteBuf.method_10812(predicate);
        byteBuf.writeBoolean(stopOnDeath);
        ServerPlayNetworking.send((class_3222)player, (class_2960)FrozenNetworking.STARTING_RESTRICTION_LOOPING_SOUND_PACKET, (class_2540)byteBuf);
    }

    public static void createLocalPlayerSound(class_3222 player, class_3414 sound, float volume, float pitch) {
        LocalPlayerSoundPacket packet = new LocalPlayerSoundPacket(sound, volume, pitch);
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
    }
}

