/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.blue.endless.jankson;

import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonElement;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonGrammar;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.Escaper;
import org.jetbrains.annotations.NotNull;

public class JsonPrimitive
extends JsonElement {
    public static JsonPrimitive TRUE = new JsonPrimitive(Boolean.TRUE);
    public static JsonPrimitive FALSE = new JsonPrimitive(Boolean.FALSE);
    @NotNull
    private Object value;

    private JsonPrimitive() {
    }

    public JsonPrimitive(@NotNull Object value) {
        if (value instanceof Character) {
            this.value = "" + value;
        } else if (value instanceof Long) {
            this.value = value;
        } else if (value instanceof Double) {
            this.value = value;
        } else if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            this.value = bigInteger.toString(16);
        } else if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            this.value = bigDecimal.toString();
        } else if (value instanceof Float) {
            Float fl = (Float)value;
            this.value = (double)fl.floatValue();
        } else if (value instanceof Number) {
            this.value = ((Number)value).longValue();
        } else if (value instanceof CharSequence) {
            this.value = value.toString();
        } else if (value instanceof Boolean) {
            this.value = value;
        } else {
            throw new IllegalArgumentException("Object of type '" + value.getClass().getCanonicalName() + "' not allowed as a JsonPrimitive");
        }
    }

    @NotNull
    public String asString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public boolean asBoolean(boolean defaultValue) {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return defaultValue;
    }

    public byte asByte(byte defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return defaultValue;
    }

    public char asChar(char defaultValue) {
        if (this.value instanceof Number) {
            return (char)((Number)this.value).intValue();
        }
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        if (this.value instanceof String) {
            if (((String)this.value).length() == 1) {
                return ((String)this.value).charAt(0);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public short asShort(short defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return defaultValue;
    }

    public int asInt(int defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return defaultValue;
    }

    public long asLong(long defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return defaultValue;
    }

    public float asFloat(float defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return defaultValue;
    }

    public double asDouble(double defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return defaultValue;
    }

    public BigInteger asBigInteger(BigInteger defaultValue) {
        if (this.value instanceof Number) {
            return BigInteger.valueOf(((Number)this.value).longValue());
        }
        if (this.value instanceof String) {
            return new BigInteger((String)this.value, 16);
        }
        return defaultValue;
    }

    public BigDecimal asBigDecimal(BigDecimal defaultValue) {
        Object object = this.value;
        if (object instanceof Number) {
            Number number = (Number)object;
            return BigDecimal.valueOf(number.doubleValue());
        }
        object = this.value;
        if (object instanceof String) {
            String str = (String)object;
            return new BigDecimal(str);
        }
        return defaultValue;
    }

    @NotNull
    public String toString() {
        return this.toJson();
    }

    @NotNull
    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof JsonPrimitive) {
            return Objects.equals(this.value, ((JsonPrimitive)other).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        return this.toJson(JsonGrammar.builder().withComments(comments).printWhitespace(newlines).build(), depth);
    }

    @Override
    public void toJson(Writer writer, JsonGrammar grammar, int depth) throws IOException {
        if (this.value == null) {
            writer.write("null");
            return;
        }
        if (this.value instanceof Double && grammar.bareSpecialNumerics) {
            double d = (Double)this.value;
            if (Double.isNaN(d)) {
                writer.write("NaN");
                return;
            }
            if (Double.isInfinite(d)) {
                if (d < 0.0) {
                    writer.write("-Infinity");
                } else {
                    writer.write("Infinity");
                }
                return;
            }
            writer.write(this.value.toString());
            return;
        }
        if (this.value instanceof Number) {
            writer.write(this.value.toString());
            return;
        }
        if (this.value instanceof Boolean) {
            writer.write(this.value.toString());
            return;
        }
        writer.write(34);
        writer.write(Escaper.escapeString(this.value.toString()));
        writer.write(34);
    }

    @Override
    public void dataFix(@NotNull DataFixer dataFixer, int newVersion) {
    }

    @Override
    public JsonPrimitive clone() {
        return new JsonPrimitive(this.value);
    }

    public static JsonPrimitive of(@NotNull String s) {
        return new JsonPrimitive(s);
    }

    public static JsonPrimitive of(@NotNull BigInteger n) {
        return new JsonPrimitive(n.toString(16));
    }

    public static JsonPrimitive of(@NotNull BigDecimal n) {
        return new JsonPrimitive(n);
    }

    public static JsonPrimitive of(double d) {
        return new JsonPrimitive(d);
    }

    public static JsonPrimitive of(long l) {
        return new JsonPrimitive(l);
    }

    public static JsonPrimitive of(boolean b) {
        return new JsonPrimitive(b);
    }
}

