/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.api.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.screenshake.api.ScreenShakeManager;
import net.frozenblock.lib.screenshake.impl.EntityScreenShakeInterface;
import net.frozenblock.lib.screenshake.impl.network.RemoveEntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.ScreenShakePacket;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ScreenShakeCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"screenshake").requires(source -> source.method_9259(2));
        literalArgumentBuilder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2277.method_9736((CommandContext)context, (String)"pos"), 1.0f, 10, 5, 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"intensity", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2277.method_9736((CommandContext)context, (String)"pos"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), 10, 5, 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2277.method_9736((CommandContext)context, (String)"pos"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), 5, 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"durationFalloffStart", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2277.method_9736((CommandContext)context, (String)"pos"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"durationFalloffStart"), 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"maxDistance", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2277.method_9736((CommandContext)context, (String)"pos"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"durationFalloffStart"), FloatArgumentType.getFloat((CommandContext)context, (String)"maxDistance")))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2277.method_9736((CommandContext)context, (String)"pos"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"durationFalloffStart"), FloatArgumentType.getFloat((CommandContext)context, (String)"maxDistance"), class_2186.method_9312((CommandContext)context, (String)"players")))))))));
        literalArgumentBuilder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9306()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entity"), 1.0f, 10, 5, 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"intensity", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), 10, 5, 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), 5, 16.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"durationFalloffStart", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"durationFalloffStart"), 16.0f))).then(class_2170.method_9244((String)"maxDistance", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ScreenShakeCommand.shake((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"intensity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"durationFalloffStart"), FloatArgumentType.getFloat((CommandContext)context, (String)"maxDistance"))))))));
        literalArgumentBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)"for").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> ScreenShakeCommand.removeShakesFor((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"players")))))).then(class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> ScreenShakeCommand.removeShakesFrom((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entity"))))));
        dispatcher.register(literalArgumentBuilder);
    }

    private static int shake(class_2168 source, class_243 vec3, float intensity, int duration, int durationFalloffStart, float maxDistance) {
        vec3 = new class_243((double)Math.round(vec3.method_10216()), (double)Math.round(vec3.method_10214()), (double)Math.round(vec3.method_10215()));
        ScreenShakeManager.addScreenShake((class_1937)source.method_9225(), intensity, duration, durationFalloffStart, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), maxDistance);
        class_243 finalVec = vec3;
        source.method_9226(() -> class_2561.method_43469((String)"commands.screenshake.success", (Object[])new Object[]{finalVec.method_10216(), finalVec.method_10214(), finalVec.method_10215(), Float.valueOf(intensity), duration, durationFalloffStart, Float.valueOf(maxDistance)}), true);
        return 1;
    }

    private static int shake(class_2168 source, class_243 vec3, float intensity, int duration, int durationFalloffStart, float maxDistance, Collection<? extends class_3222> entities) {
        vec3 = new class_243((double)Math.round(vec3.method_10216()), (double)Math.round(vec3.method_10214()), (double)Math.round(vec3.method_10215()));
        ScreenShakePacket packet = new ScreenShakePacket(intensity, duration, durationFalloffStart, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), maxDistance, 0);
        StringBuilder playerString = new StringBuilder();
        for (class_3222 class_32222 : entities) {
            ServerPlayNetworking.send((class_3222)class_32222, (FabricPacket)packet);
            playerString.append(class_32222.method_5476().getString()).append(", ");
        }
        class_243 finalVec = vec3;
        source.method_9226(() -> class_2561.method_43469((String)"commands.screenshake.player.success", (Object[])new Object[]{playerString.toString(), finalVec.method_10216(), finalVec.method_10214(), finalVec.method_10215(), Float.valueOf(intensity), duration, durationFalloffStart, Float.valueOf(maxDistance)}), true);
        return 1;
    }

    private static int shake(class_2168 source, Collection<? extends class_1297> entities, float intensity, int duration, int durationFalloffStart, float maxDistance) {
        StringBuilder entityString = new StringBuilder();
        for (class_1297 class_12972 : entities) {
            ScreenShakeManager.addEntityScreenShake(class_12972, intensity, duration, durationFalloffStart, maxDistance);
            entityString.append(class_12972.method_5476().getString()).append(", ");
        }
        source.method_9226(() -> class_2561.method_43469((String)"commands.screenshake.entity.success", (Object[])new Object[]{entityString.toString(), Float.valueOf(intensity), duration, durationFalloffStart, Float.valueOf(maxDistance)}), true);
        return 1;
    }

    private static int removeShakesFor(class_2168 source, Collection<? extends class_3222> entities) {
        StringBuilder playerString = new StringBuilder();
        boolean onePlayer = entities.size() == 1;
        RemoveScreenShakePacket packet = new RemoveScreenShakePacket();
        for (class_3222 class_32222 : entities) {
            ServerPlayNetworking.send((class_3222)class_32222, (FabricPacket)packet);
            playerString.append(class_32222.method_5476().getString()).append(onePlayer ? "" : ", ");
        }
        source.method_9226(() -> class_2561.method_43469((String)(onePlayer ? "commands.screenshake.remove.player.success" : "commands.screenshake.remove.player.success.multiple"), (Object[])new Object[]{playerString.toString()}), true);
        return 1;
    }

    private static int removeShakesFrom(class_2168 source, Collection<? extends class_1297> entities) {
        StringBuilder entityString = new StringBuilder();
        int entityAmount = 0;
        ArrayList<class_1297> affectedEntities = new ArrayList<class_1297>();
        for (class_1297 class_12972 : entities) {
            if (((EntityScreenShakeInterface)class_12972).getScreenShakeManager().getShakes().isEmpty()) continue;
            RemoveEntityScreenShakePacket packet = new RemoveEntityScreenShakePacket(class_12972.method_5628());
            affectedEntities.add(class_12972);
            ((EntityScreenShakeInterface)class_12972).getScreenShakeManager().getShakes().clear();
            for (class_3222 serverPlayer : PlayerLookup.tracking((class_3218)source.method_9225(), (class_2338)class_12972.method_24515())) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)packet);
            }
            ++entityAmount;
        }
        boolean oneEntity = affectedEntities.size() == 1;
        for (class_1297 entity : affectedEntities) {
            entityString.append(entity.method_5476().getString()).append(oneEntity ? "" : ", ");
        }
        if (entityAmount > 0) {
            source.method_9226(() -> class_2561.method_43469((String)(oneEntity ? "commands.screenshake.remove.entity.success" : "commands.screenshake.remove.entity.success.multiple"), (Object[])new Object[]{entityString.toString()}), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"commands.screenshake.remove.entity.failure"));
        return 0;
    }
}

