/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.api.client;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ScreenShaker {
    public static final ArrayList<ClientScreenShake> SCREEN_SHAKES = new ArrayList();
    private static float prevYRot;
    private static float yRot;
    private static float prevXRot;
    private static float xRot;
    private static float prevZRot;
    private static float zRot;

    public static void tick(@NotNull class_638 level) {
        class_310 client = class_310.method_1551();
        prevYRot = yRot;
        prevXRot = xRot;
        prevZRot = zRot;
        if (!client.method_31321() && client.method_1493()) {
            yRot = 0.0f;
            xRot = 0.0f;
            zRot = 0.0f;
            return;
        }
        class_1041 window = client.method_22683();
        int windowWidth = window.method_4489();
        int windowHeight = window.method_4506();
        class_5819 randomSource = level.method_8409();
        SCREEN_SHAKES.removeIf(clientScreenShake -> clientScreenShake.shouldRemove(level));
        float highestIntensity = 0.0f;
        float totalIntensity = 0.0f;
        int amount = 0;
        for (ClientScreenShake screenShake : SCREEN_SHAKES) {
            screenShake.tick();
            float shakeIntensity = screenShake.getIntensity(client.field_1773.method_19418().method_19326());
            if (shakeIntensity > 0.0f) {
                totalIntensity += shakeIntensity;
                highestIntensity = Math.max(shakeIntensity, highestIntensity);
                ++amount;
            }
            ++screenShake.ticks;
        }
        float intensity = amount > 0 && totalIntensity != 0.0f && highestIntensity != 0.0f ? highestIntensity + totalIntensity / (float)amount * 0.5f : 0.0f;
        yRot = class_3532.method_15344((class_5819)randomSource, (float)(-intensity), (float)intensity) * ((float)windowWidth / (float)windowHeight);
        xRot = class_3532.method_15344((class_5819)randomSource, (float)(-intensity), (float)intensity);
        zRot = class_3532.method_15344((class_5819)randomSource, (float)(-intensity), (float)intensity);
    }

    public static void shake(@NotNull class_4587 poseStack, float partialTicks) {
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(prevXRot + partialTicks * xRot - prevXRot));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(prevYRot + partialTicks * yRot - prevYRot));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(prevZRot + partialTicks * zRot - prevZRot));
    }

    @Deprecated
    public static float cameraZ(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)prevZRot, (float)zRot);
    }

    @Deprecated
    public static void cameraShake(@NotNull class_4184 camera, float partialTicks) {
        camera.method_19325(camera.method_19330() + class_3532.method_16439((float)partialTicks, (float)prevYRot, (float)yRot), camera.method_19329() + class_3532.method_16439((float)partialTicks, (float)prevXRot, (float)xRot));
    }

    public static void addShake(class_638 level, float intensity, int duration, int falloffStart, class_243 pos, float maxDistance, int ticks) {
        SCREEN_SHAKES.add(new ClientScreenShake(level, intensity, duration, falloffStart, pos, maxDistance, ticks));
    }

    public static void addShake(class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance, int ticks) {
        SCREEN_SHAKES.add(new ClientEntityScreenShake(entity, intensity, duration, falloffStart, maxDistance, ticks));
    }

    public static void clear() {
        SCREEN_SHAKES.clear();
    }

    public static class ClientScreenShake {
        public class_638 level;
        private final float intensity;
        public final int duration;
        private final int durationFalloffStart;
        protected class_243 pos;
        public final float maxDistance;
        public int ticks;

        public ClientScreenShake(class_638 level, float intensity, int duration, int durationFalloffStart, class_243 pos, float maxDistance, int ticks) {
            this.level = level;
            this.intensity = intensity;
            this.duration = duration;
            this.durationFalloffStart = durationFalloffStart;
            this.pos = pos;
            this.maxDistance = maxDistance;
            this.ticks = ticks;
        }

        public float getIntensity(@NotNull class_243 playerPos) {
            float distanceBasedIntensity = Math.max((float)(1.0 - playerPos.method_1022(this.pos) / (double)this.maxDistance), 0.0f);
            if (distanceBasedIntensity > 0.0f) {
                float timeFromFalloffStart = Math.max(this.ticks - this.durationFalloffStart, 0);
                float falloffTime = this.duration - this.durationFalloffStart;
                float lerpedTimeFromFalloffStart = class_3532.method_16439((float)((float)this.ticks / (float)this.duration), (float)0.0f, (float)timeFromFalloffStart);
                return distanceBasedIntensity * ((falloffTime - lerpedTimeFromFalloffStart) / falloffTime) * this.intensity;
            }
            return 0.0f;
        }

        public void tick() {
        }

        public boolean shouldRemove(class_638 level) {
            return this.ticks > this.duration || level != this.level;
        }
    }

    public static class ClientEntityScreenShake
    extends ClientScreenShake {
        private final class_1297 entity;

        public ClientEntityScreenShake(@NotNull class_1297 entity, float intensity, int duration, int durationFalloffStart, float maxDistance, int ticks) {
            super((class_638)entity.method_37908(), intensity, duration, durationFalloffStart, entity.method_19538(), maxDistance, ticks);
            this.entity = entity;
        }

        @Override
        public float getIntensity(@NotNull class_243 playerPos) {
            if (this.entity != null && !this.entity.method_31481()) {
                this.pos = this.entity.method_19538();
                return super.getIntensity(playerPos);
            }
            return 0.0f;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        @Override
        public void tick() {
            super.tick();
            this.level = (class_638)this.entity.method_37908();
        }

        @Override
        public boolean shouldRemove(class_638 level) {
            return super.shouldRemove(level) || this.entity == null || this.entity.method_31481();
        }
    }
}

