/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.item.mixin;

import java.util.List;
import java.util.UUID;
import net.frozenblock.lib.item.api.HeavyItemDamageRegistry;
import net.frozenblock.lib.tag.api.FrozenItemTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public class ItemEntityMixin {
    @Shadow
    @Nullable
    private UUID field_7200;
    @Unique
    private boolean frozenLib$isHeavy;

    @Inject(method={"setItem"}, at={@At(value="TAIL")})
    public void setItem(class_1799 stack, CallbackInfo info) {
        this.frozenLib$isHeavy = stack.method_31573(FrozenItemTags.HEAVY_ITEMS);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I", shift=At.Shift.BEFORE)})
    public void hitIfHeavy(CallbackInfo info) {
        class_1542 item = (class_1542)class_1542.class.cast(this);
        if (this.frozenLib$isHeavy) {
            List<class_1297> entities = this.collidingEntities();
            for (class_1297 entity : entities) {
                class_1657 player;
                if (item.method_31481() || entity == null) continue;
                boolean shouldDamage = true;
                if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337()) {
                    shouldDamage = false;
                }
                if (entity.method_5655()) {
                    shouldDamage = false;
                }
                if (!shouldDamage) continue;
                this.hitEntity(entity);
            }
        }
    }

    @Unique
    private void hitEntity(class_1297 entity) {
        class_1657 owner;
        class_1542 item = (class_1542)class_1542.class.cast(this);
        class_1657 class_16572 = owner = this.field_7200 != null ? item.method_37908().method_18470(this.field_7200) : null;
        if (entity != owner) {
            class_1282 damageSource = owner.method_48923().method_48812((class_1309)entity);
            if (owner != null) {
                ((class_1309)owner).method_6114(entity);
            }
            if (entity.method_5643(damageSource, HeavyItemDamageRegistry.getDamage(this.method_6983()))) {
                item.method_5783(class_3417.field_14833, 0.3f, 1.2f / (item.method_37908().field_9229.method_43057() * 0.2f + 0.9f));
            }
        }
    }

    @Unique
    public List<class_1297> collidingEntities() {
        class_1542 entity = (class_1542)class_1542.class.cast(this);
        return entity.method_37908().method_8333((class_1297)entity, entity.method_5829().method_18804(entity.method_18798()), this::canHitEntity);
    }

    @Unique
    public boolean canHitEntity(@NotNull class_1297 entity) {
        class_1542 item = (class_1542)class_1542.class.cast(this);
        class_243 itemMovement = item.method_18798();
        if (!entity.method_7325() && entity.method_5805() && entity.method_5863() && entity instanceof class_1309 && itemMovement.method_1033() > 0.3) {
            class_243 compared = entity.method_18798().method_1020(itemMovement);
            return compared.method_37267() > 0.4 || compared.field_1351 > 0.3;
        }
        return false;
    }

    @Shadow
    public class_1799 method_6983() {
        throw new AssertionError((Object)"Mixin injection failed - FrozenLib ItemEntityMixin");
    }
}

