/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.item.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.item.impl.network.CooldownTickCountPacket;
import net.frozenblock.lib.item.impl.network.ForcedCooldownPacket;
import net.frozenblock.lib.tag.api.FrozenItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SaveableItemCooldowns {
    @NotNull
    public static List<SaveableCooldownInstance> makeSaveableCooldownInstanceList(@NotNull class_3222 player) {
        ArrayList<SaveableCooldownInstance> saveableCooldownInstances = new ArrayList<SaveableCooldownInstance>();
        int tickCount = player.method_7357().field_8025;
        player.method_7357().field_8024.forEach((item, cooldownInstance) -> {
            if (item.method_40131().method_40220(FrozenItemTags.ALWAYS_SAVE_COOLDOWNS) || FrozenLibConfig.get().saveItemCooldowns) {
                saveableCooldownInstances.add(SaveableCooldownInstance.makeFromCooldownInstance(item, cooldownInstance, tickCount));
            }
        });
        return saveableCooldownInstances;
    }

    public static void saveCooldowns(@NotNull class_2487 tag, @NotNull class_3222 player) {
        Logger logger = FrozenSharedConstants.LOGGER;
        SaveableCooldownInstance.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, SaveableItemCooldowns.makeSaveableCooldownInstanceList(player)).resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(savedItemCooldownsNbt -> tag.method_10566("FrozenLibSavedItemCooldowns", savedItemCooldownsNbt));
    }

    @NotNull
    public static List<SaveableCooldownInstance> readCooldowns(@NotNull class_2487 tag) {
        ArrayList<SaveableCooldownInstance> saveableCooldownInstances = new ArrayList<SaveableCooldownInstance>();
        if (tag.method_10573("FrozenLibSavedItemCooldowns", 9)) {
            Logger logger = FrozenSharedConstants.LOGGER;
            SaveableCooldownInstance.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10554("FrozenLibSavedItemCooldowns", 10))).resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(saveableCooldownInstances::addAll);
        }
        return saveableCooldownInstances;
    }

    public static void setCooldowns(@NotNull List<SaveableCooldownInstance> saveableCooldownInstances, @NotNull class_3222 player) {
        if (!player.method_37908().field_9236) {
            class_1796 itemCooldowns = player.method_7357();
            int tickCount = itemCooldowns.field_8025;
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)new CooldownTickCountPacket(tickCount));
            for (SaveableCooldownInstance saveableCooldownInstance : saveableCooldownInstances) {
                int cooldownLeft = saveableCooldownInstance.cooldownLeft();
                int startTime = tickCount - (saveableCooldownInstance.totalCooldownTime() - cooldownLeft);
                int endTime = tickCount + cooldownLeft;
                Optional optionalItem = class_7923.field_41178.method_17966(saveableCooldownInstance.itemResourceLocation());
                if (!optionalItem.isPresent()) continue;
                class_1792 item = (class_1792)optionalItem.get();
                itemCooldowns.field_8024.put(item, new class_1796.class_1797(startTime, endTime));
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)new ForcedCooldownPacket(item, startTime, endTime));
            }
        }
    }

    public record SaveableCooldownInstance(class_2960 itemResourceLocation, int cooldownLeft, int totalCooldownTime) {
        public static final Codec<SaveableCooldownInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("ItemResourceLocation").forGetter(SaveableCooldownInstance::itemResourceLocation), (App)Codec.INT.fieldOf("CooldownLeft").orElse((Object)0).forGetter(SaveableCooldownInstance::cooldownLeft), (App)Codec.INT.fieldOf("TotalCooldownTime").orElse((Object)0).forGetter(SaveableCooldownInstance::totalCooldownTime)).apply((Applicative)instance, SaveableCooldownInstance::new));

        @NotNull
        public static SaveableCooldownInstance makeFromCooldownInstance(@NotNull class_1792 item, @NotNull class_1796.class_1797 cooldownInstance, int tickCount) {
            class_2960 resourceLocation = class_7923.field_41178.method_10221((Object)item);
            int cooldownLeft = cooldownInstance.field_8027 - tickCount;
            int totalCooldownTime = cooldownInstance.field_8027 - cooldownInstance.field_8028;
            return new SaveableCooldownInstance(resourceLocation, cooldownLeft, totalCooldownTime);
        }
    }
}

