/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.entity.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class EntityUtils {
    private static final Map<class_3218, List<class_1297>> ENTITIES_PER_LEVEL = new Object2ObjectOpenHashMap();

    public static void populateEntitiesPerLevel(@NotNull class_3218 level) {
        EntityUtils.clearEntitiesPerLevel(level);
        Iterable entityIterable = level.field_26935.method_31841().method_31803();
        ArrayList entityList = new ArrayList();
        entityIterable.forEach(entityList::add);
        ENTITIES_PER_LEVEL.put(level, List.copyOf(entityList));
    }

    public static void clearEntitiesPerLevel(class_3218 level) {
        ENTITIES_PER_LEVEL.remove(level);
    }

    public static List<class_1297> getEntitiesPerLevel(class_3218 level) {
        return ENTITIES_PER_LEVEL.computeIfAbsent(level, serverLevel -> new ArrayList());
    }

    public static Optional<class_2350> getMovementDirectionHorizontal(@NotNull class_1297 entity) {
        class_2350 direction = null;
        class_243 deltaMovement = entity.method_18798();
        if (deltaMovement.method_37267() > 0.0) {
            double nonNegZ;
            double nonNegX = Math.abs(deltaMovement.field_1352);
            if (nonNegX > (nonNegZ = Math.abs(deltaMovement.field_1350))) {
                direction = deltaMovement.field_1352 > 0.0 ? class_2350.field_11034 : class_2350.field_11039;
            } else if (nonNegZ > 0.0) {
                direction = deltaMovement.field_1350 > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
            }
        }
        return Optional.ofNullable(direction);
    }
}

