/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.json;

import com.mojang.datafixers.DataFixer;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.ConfigSerialization;
import net.frozenblock.lib.config.api.instance.json.JsonType;
import net.frozenblock.lib.shadow.blue.endless.jankson.Jankson;
import org.jetbrains.annotations.Nullable;

public class JsonConfig<T>
extends Config<T> {
    private final Jankson jankson;
    private final JsonType type;

    @Deprecated(forRemoval=true)
    public JsonConfig(String modId, Class<T> config) {
        this(modId, config, (DataFixer)null, null);
    }

    public JsonConfig(String modId, Class<T> config, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        this(modId, config, true, dataFixer, version);
    }

    @Deprecated(forRemoval=true)
    public JsonConfig(String modId, Class<T> config, JsonType type) {
        this(modId, config, type, null, null);
    }

    public JsonConfig(String modId, Class<T> config, JsonType type, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        this(modId, config, type, true, dataFixer, version);
    }

    @Deprecated(forRemoval=true)
    public JsonConfig(String modId, Class<T> config, Path path, JsonType type) {
        this(modId, config, path, type, null, null);
    }

    public JsonConfig(String modId, Class<T> config, Path path, JsonType type, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        this(modId, config, path, type, true, dataFixer, version);
    }

    @Deprecated(forRemoval=true)
    public JsonConfig(String modId, Class<T> config, boolean supportsModification) {
        this(modId, config, supportsModification, null, null);
    }

    public JsonConfig(String modId, Class<T> config, boolean supportsModification, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        this(modId, config, JsonType.JSON, supportsModification, dataFixer, version);
    }

    @Deprecated(forRemoval=true)
    public JsonConfig(String modId, Class<T> config, JsonType type, boolean supportsModification) {
        this(modId, config, type, supportsModification, null, null);
    }

    public JsonConfig(String modId, Class<T> config, JsonType type, boolean supportsModification, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        this(modId, config, JsonConfig.makePath(modId, type.method_15434()), type, supportsModification, dataFixer, version);
    }

    @Deprecated(forRemoval=true)
    public JsonConfig(String modId, Class<T> config, Path path, JsonType type, boolean supportsModification) {
        this(modId, config, path, type, supportsModification, null, null);
    }

    public JsonConfig(String modId, Class<T> config, Path path, JsonType type, boolean supportsModification, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        super(modId, config, path, supportsModification, dataFixer, version);
        Jankson.Builder janksonBuilder = Jankson.builder().withFixer(dataFixer).withVersion(version);
        this.jankson = ConfigSerialization.createJankson(janksonBuilder, modId);
        this.type = type;
        if (this.load()) {
            this.save();
        }
    }

    @Override
    public void onSave() throws Exception {
        Files.createDirectories(this.path().getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(this.path(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(this.jankson.toJson(this.instance()).toJson(this.type.getGrammar()));
        }
    }

    @Override
    public boolean onLoad() throws Exception {
        if (Files.exists(this.path(), new LinkOption[0])) {
            this.setConfig(this.jankson.fromJson(this.jankson.load(this.path().toFile()), this.configClass()));
        }
        return true;
    }
}

