/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.json;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.frozenblock.lib.FrozenLogUtils;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.config.api.entry.TypedEntry;
import net.frozenblock.lib.config.api.entry.TypedEntryType;
import net.frozenblock.lib.config.api.instance.json.JanksonOps;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonElement;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.DeserializationException;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.DeserializerFunction;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.Marshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JanksonTypedEntrySerializer
implements BiFunction<TypedEntry, Marshaller, JsonElement>,
DeserializerFunction<JsonElement, TypedEntry> {
    private final String modId;

    public JanksonTypedEntrySerializer(String modId) {
        this.modId = modId;
    }

    @Override
    public JsonElement apply(TypedEntry src, Marshaller marshaller) {
        Optional optional;
        DataResult encoded;
        Codec codec;
        TypedEntryType type;
        if (src != null && (type = src.type()) != null && Objects.equals(type.modId(), this.modId) && (codec = type.codec()) != null && (encoded = codec.encodeStart((DynamicOps)JanksonOps.INSTANCE, src.value())) != null && encoded.error().isEmpty() && (optional = encoded.result()).isPresent()) {
            return (JsonElement)optional.get();
        }
        throw new JsonParseException("Failed to serialize typed entry " + src);
    }

    @Override
    public TypedEntry apply(JsonElement json, Marshaller m) throws DeserializationException {
        TypedEntry modEntry = this.getFromRegistry(json, ConfigRegistry.getTypedEntryTypesForMod(this.modId));
        if (modEntry != null) {
            return modEntry;
        }
        throw new DeserializationException("Failed to deserialize typed entry " + json);
    }

    @Nullable
    private <T> TypedEntry<T> getFromRegistry(JsonElement json, @NotNull Collection<TypedEntryType<?>> registry) throws ClassCastException {
        for (TypedEntryType<?> entryType : registry) {
            TypedEntryType<?> newType = entryType;
            TypedEntry<?> entry = this.getFromType(json, newType);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private <T> TypedEntry<T> getFromType(JsonElement json, @NotNull TypedEntryType<T> entryType) throws ClassCastException {
        Optional optional;
        Codec<T> codec;
        DataResult result;
        if (entryType.modId().equals(this.modId) && (result = (codec = entryType.codec()).decode((DynamicOps)JanksonOps.INSTANCE, (Object)json)).error().isEmpty() && (optional = result.result()).isPresent()) {
            Pair pair = (Pair)optional.get();
            Object first = pair.getFirst();
            TypedEntry<Object> entry = new TypedEntry<Object>(entryType, first);
            FrozenLogUtils.log("Built typed entry " + entry, FrozenSharedConstants.UNSTABLE_LOGGING);
            return entry;
        }
        return null;
    }
}

