/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance;

import com.mojang.datafixers.DataFixer;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenBools;
import net.frozenblock.lib.FrozenLogUtils;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.config.api.instance.ConfigModification;
import net.frozenblock.lib.config.api.registry.ConfigLoadEvent;
import net.frozenblock.lib.config.api.registry.ConfigSaveEvent;
import net.frozenblock.lib.config.api.sync.annotation.UnsyncableConfig;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Config<T> {
    private final String modId;
    private final Path path;
    private final boolean supportsModification;
    @Nullable
    private final DataFixer dataFixer;
    @Nullable
    private final Integer version;
    private final Class<T> config;
    private T configInstance;
    private final T defaultInstance;
    private boolean synced = false;

    protected Config(String modId, Class<T> config, Path path, boolean supportsModification, @Nullable DataFixer dataFixer, @Nullable Integer version) {
        this.modId = modId;
        this.path = path;
        this.supportsModification = supportsModification;
        this.config = config;
        try {
            this.configInstance = config.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.defaultInstance = this.configInstance;
        }
        catch (Exception e) {
            throw new IllegalStateException("No default constructor for default config instance.", e);
        }
        this.dataFixer = dataFixer;
        this.version = version;
    }

    @NotNull
    @Contract(pure=true)
    public static Path makePath(String modId, String extension) {
        return Path.of("./config/" + modId + "." + extension, new String[0]);
    }

    public String modId() {
        return this.modId;
    }

    public Path path() {
        return this.path;
    }

    public boolean supportsModification() {
        return this.supportsModification;
    }

    @Nullable
    public DataFixer dataFixer() {
        return this.dataFixer;
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public T config() {
        if (this.supportsModification()) {
            return ConfigModification.modifyConfig(this, this.instance(), false);
        }
        return this.instance();
    }

    public T configWithSync() {
        if (!this.supportsSync()) {
            String formatted = String.format("Config %s from %s", this.configClass().getSimpleName(), this.modId());
            FrozenLogUtils.logWarning(formatted + " does not support modification, returning unmodified instance.");
            return this.instance();
        }
        return ConfigModification.modifyConfig(this, this.instance(), true);
    }

    public boolean supportsSync() {
        return this.supportsModification() && !this.configClass().isAnnotationPresent(UnsyncableConfig.class);
    }

    public T instance() {
        return this.configInstance;
    }

    public void setConfig(T configInstance) {
        this.configInstance = configInstance;
    }

    public T defaultInstance() {
        return this.defaultInstance;
    }

    public Class<T> configClass() {
        return this.config;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public boolean isSynced() {
        return this.synced;
    }

    protected String formattedName() {
        return String.format("config %s from %s", this.configClass().getSimpleName(), this.modId());
    }

    protected abstract void onSave() throws Exception;

    protected abstract boolean onLoad() throws Exception;

    public final void save() {
        String formatted = this.formattedName();
        FrozenSharedConstants.LOGGER.info("Saving {}", (Object)formatted);
        try {
            this.onSave();
            if (FrozenBools.isInitialized) {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    ConfigSyncPacket.trySendC2S(this);
                }
                this.invokeSaveEvents();
            }
        }
        catch (Exception e) {
            FrozenLogUtils.logError((Object)("Error while saving " + formatted), e);
        }
    }

    public final boolean load() {
        String formatted = this.formattedName();
        FrozenSharedConstants.LOGGER.info("Loading " + formatted);
        try {
            boolean loadVal = this.onLoad();
            if (FrozenBools.isInitialized) {
                this.invokeLoadEvents();
            }
            return loadVal;
        }
        catch (Exception e) {
            FrozenLogUtils.logError((Object)("Error while loading " + formatted), e);
            return false;
        }
    }

    private void invokeSaveEvents() {
        String formatted = this.formattedName();
        try {
            ((ConfigSaveEvent)ConfigSaveEvent.EVENT.invoker()).onSave(this);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ((ConfigSaveEvent.Client)ConfigSaveEvent.Client.EVENT.invoker()).onSave(this);
            }
        }
        catch (Exception e) {
            FrozenLogUtils.logError((Object)("Error in config save events for " + formatted), e);
        }
    }

    private void invokeLoadEvents() {
        String formatted = this.formattedName();
        try {
            ((ConfigLoadEvent)ConfigLoadEvent.EVENT.invoker()).onLoad(this);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ((ConfigLoadEvent.Client)ConfigLoadEvent.Client.EVENT.invoker()).onLoad(this);
            }
        }
        catch (Exception e) {
            FrozenLogUtils.logError((Object)("Error in config load events for " + formatted), e);
        }
    }
}

