/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.view;

import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import net.minecraft.class_3532;

public class RotatedView
implements DrawableCanvas {
    private final int width;
    private final int height;
    private final double cos;
    private final double sin;
    private final DrawableCanvas source;
    private final int offsetX;
    private final int offsetY;
    private final int halfWidth;
    private final int halfHeight;

    public RotatedView(DrawableCanvas source, double angle, int offsetX, int offsetY) {
        this.source = source;
        this.cos = Math.cos(angle);
        this.sin = Math.sin(angle);
        int maxWidth = 0;
        int maxHeight = 0;
        int minWidth = 0;
        int minHeight = 0;
        for (int x = -source.getWidth() / 2; x < source.getWidth() / 2; ++x) {
            for (int y = -source.getHeight() / 2; y < source.getHeight() / 2; ++y) {
                double currentWidth = this.cos * (double)x + this.sin * (double)y;
                double currentHeight = -this.sin * (double)x + this.cos * (double)y;
                if (currentHeight > (double)maxHeight) {
                    maxHeight = class_3532.method_15384((double)currentHeight);
                }
                if (currentWidth > (double)maxWidth) {
                    maxWidth = class_3532.method_15384((double)currentWidth);
                }
                if (currentHeight < (double)minHeight) {
                    minHeight = class_3532.method_15357((double)currentHeight);
                }
                if (!(currentWidth < (double)minWidth)) continue;
                minWidth = class_3532.method_15357((double)currentWidth);
            }
        }
        this.height = this.width = Math.max(maxWidth - minWidth, maxHeight - minHeight);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
    }

    @Override
    public byte getRaw(int x, int y) {
        return this.source.getRaw((int)Math.floor(this.cos * (double)(x -= this.halfWidth) + this.sin * (double)(y -= this.halfHeight) + (double)this.offsetX), (int)Math.floor(-this.sin * (double)x + this.cos * (double)y + (double)this.offsetY));
    }

    @Override
    public void setRaw(int x, int y, byte color) {
        this.source.setRaw((int)Math.floor(this.cos * (double)(x -= this.halfWidth) + this.sin * (double)(y -= this.halfHeight) + (double)this.offsetX), (int)Math.floor(-this.sin * (double)x + this.cos * (double)y - (double)this.offsetY), color);
    }

    @Override
    public int getHeight() {
        return this.width;
    }

    @Override
    public int getWidth() {
        return this.height;
    }
}

