/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class VanillaFontReader {
    public static CanvasFont build(ZipFile[] zipFile, class_2960 identifier) {
        ArrayList<String> lines = new ArrayList<String>();
        for (ZipFile zip : zipFile) {
            try {
                ZipEntry entry = zip.getEntry("pack.mcmeta");
                InputStream stream = zip.getInputStream(entry);
                JsonElement json = JsonParser.parseString((String)new String(stream.readAllBytes()));
                stream.close();
                lines.add(class_2561.class_2562.method_10872((JsonElement)json.getAsJsonObject().get("pack").getAsJsonObject().get("description")).getString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VanillaFontReader.build(zipFile, CanvasFont.Metadata.create("Resource Pack Font", List.of("Unknown"), "Generated from resource packs.\n" + String.join((CharSequence)"\n", lines)), identifier);
    }

    public static BitmapFont build(ZipFile[] files, CanvasFont.Metadata metadata, class_2960 identifier) {
        BitmapFont font;
        block17: {
            font = new BitmapFont(BitmapFont.Glyph.INVALID, metadata);
            try {
                StackedZipFile file = new StackedZipFile(files);
                ZipEntry entry = file.getEntry("assets/" + identifier.method_12836() + "/font/" + identifier.method_12832() + ".json");
                if (entry == null) break block17;
                JsonArray json = JsonParser.parseString((String)new String(file.getInputStream(entry).readAllBytes())).getAsJsonObject().getAsJsonArray("providers");
                for (JsonElement tmp : json) {
                    JsonObject obj = tmp.getAsJsonObject();
                    try {
                        String type = obj.getAsJsonPrimitive("type").getAsString();
                        if (type.equals("bitmap")) {
                            class_2960 path = new class_2960(obj.getAsJsonPrimitive("file").getAsString());
                            int ascent = obj.getAsJsonPrimitive("ascent").getAsInt();
                            int height = 8;
                            try {
                                height = obj.getAsJsonPrimitive("height").getAsInt();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            InputStream input = file.getInputStream(file.getEntry("assets/" + path.method_12836() + "/textures/" + path.method_12832()));
                            if (input == null) continue;
                            BufferedImage texture = ImageIO.read(input);
                            JsonArray charJson = obj.getAsJsonArray("chars");
                            int charWidth = texture.getWidth() / charJson.get(0).getAsString().length();
                            int charHeight = texture.getHeight() / charJson.size();
                            for (int y = 0; y < charJson.size(); ++y) {
                                String chars = charJson.get(y).getAsString();
                                int[] array = chars.codePoints().toArray();
                                for (int x = 0; x < array.length; ++x) {
                                    try {
                                        boolean[] glyphTexture = new boolean[charHeight * charWidth];
                                        int realWidth = 0;
                                        for (int xd = 0; xd < charWidth; ++xd) {
                                            for (int yd = 0; yd < charHeight; ++yd) {
                                                if ((texture.getRGB(x * charWidth + xd, y * charHeight + yd) >> 24 & 0xFF) <= 64) continue;
                                                glyphTexture[xd + yd * charWidth] = true;
                                                realWidth = Math.max(realWidth, xd);
                                            }
                                        }
                                        if (font.characters.containsKey(array[x])) continue;
                                        int trueWidth = realWidth + 1;
                                        boolean[] textureCompact = new boolean[charHeight * trueWidth];
                                        for (int xd = 0; xd < trueWidth; ++xd) {
                                            for (int yd = 0; yd < charHeight; ++yd) {
                                                textureCompact[xd + yd * trueWidth] = glyphTexture[xd + yd * charWidth];
                                            }
                                        }
                                        font.characters.put(array[x], (Object)new BitmapFont.Glyph(trueWidth, charHeight, ascent, realWidth, height, textureCompact));
                                        continue;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            continue;
                        }
                        if (!type.equals("space")) continue;
                        JsonObject advances = obj.get("advances").getAsJsonObject();
                        for (String key : advances.keySet()) {
                            font.characters.put(key.codePointAt(0), (Object)new BitmapFont.Glyph(0, 0, 0, advances.getAsJsonPrimitive(key).getAsInt(), 0, new boolean[0]));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return font;
    }

    public record StackedZipFile(ZipFile[] files) {
        public ZipEntry getEntry(String path) {
            for (ZipFile file : this.files) {
                ZipEntry entry = file.getEntry(path);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }

        public InputStream getInputStream(ZipEntry entry) {
            for (ZipFile file : this.files) {
                try {
                    InputStream stream = file.getInputStream(entry);
                    if (stream == null) continue;
                    return stream;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

