/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public record StackedFont(CanvasFont[] fonts, CanvasFont.Metadata metadata) implements CanvasFont
{
    public StackedFont(CanvasFont[] fonts) {
        this(fonts, CanvasFont.Metadata.create(fonts[0].getMetadata().name(), ((Supplier<List>)() -> {
            ArrayList<Object> list = new ArrayList<Object>();
            for (CanvasFont font : fonts) {
                if (font == fonts[0]) {
                    list.addAll(font.getMetadata().authors());
                    continue;
                }
                for (String author : font.getMetadata().authors()) {
                    list.add(author + " (" + font.getMetadata().name() + ")");
                }
            }
            return list;
        }).get(), fonts[0].getMetadata().description().orElse(null)));
    }

    @Override
    public int getGlyphWidth(int character, double size, int offset) {
        for (CanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return font.getGlyphWidth(character, size, offset);
        }
        return BitmapFont.EMPTY.getGlyphWidth(character, size, offset);
    }

    @Override
    public int drawGlyph(DrawableCanvas canvas, int character, int x, int y, double size, int offset, CanvasColor color) {
        for (CanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return font.drawGlyph(canvas, character, x, y, size, offset, color);
        }
        return BitmapFont.EMPTY.getGlyphWidth(character, size, offset);
    }

    @Override
    public boolean containsGlyph(int character) {
        for (CanvasFont font : this.fonts) {
            if (!font.containsGlyph(character)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CanvasFont.Metadata getMetadata() {
        return this.metadata;
    }
}

