/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl;

import eu.pb4.mapcanvas.api.core.CanvasIcon;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.IconContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_20;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMapCanvas
implements DrawableCanvas,
IconContainer {
    protected final byte[] data = new byte[16384];
    protected final Set<SimpleCanvasIcon> icons = new HashSet<SimpleCanvasIcon>();
    private int iconId = 0;

    @Override
    public byte getRaw(int x, int y) {
        return this.data[x + y * 128];
    }

    @Override
    public void setRaw(int x, int y, byte color) {
        if (x >= 128 || y >= 128 || x < 0 || y < 0) {
            return;
        }
        int i = x + y * 128;
        if (this.data[i] != color) {
            this.markPixelDirty(x, y);
            this.data[i] = color;
        }
    }

    @Override
    public int getHeight() {
        return 128;
    }

    @Override
    public int getWidth() {
        return 128;
    }

    protected void markPixelDirty(int x, int y) {
    }

    protected void markIconsDirty() {
    }

    @Override
    public Collection<CanvasIcon> getIcons() {
        return Collections.unmodifiableCollection(this.icons);
    }

    @Override
    public CanvasIcon createIcon() {
        SimpleCanvasIcon icon = new SimpleCanvasIcon(this.iconId++);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public CanvasIcon createIcon(class_20.class_21 type, boolean visible, int x, int y, byte rotation, @Nullable class_2561 text) {
        SimpleCanvasIcon icon = new SimpleCanvasIcon(this.iconId++, visible, type, x, y, rotation, text);
        this.icons.add(icon);
        if (visible) {
            this.markIconsDirty();
        }
        return icon;
    }

    @Override
    public void removeIcon(CanvasIcon icon) {
        if (icon.isVisible() && this.icons.remove(icon)) {
            this.markIconsDirty();
        }
    }

    public final class SimpleCanvasIcon
    implements CanvasIcon {
        public final int id;
        private class_2561 text;
        private class_20.class_21 type = class_20.class_21.field_91;
        private int x = 0;
        private int y = 0;
        private byte rotation = 0;
        private boolean isVisible = false;

        protected SimpleCanvasIcon(int id) {
            this.id = id;
        }

        protected SimpleCanvasIcon(int id, boolean visible, class_20.class_21 type, int x, int y, @Nullable byte rotation, class_2561 text) {
            this.id = id;
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.text = text;
            this.isVisible = visible;
        }

        @Override
        public class_20.class_21 getType() {
            return this.type;
        }

        @Override
        public void setType(class_20.class_21 type) {
            if (this.type != type) {
                this.type = type;
                BaseMapCanvas.this.markIconsDirty();
            }
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public byte getRotation() {
            return this.rotation;
        }

        @Override
        public void move(int x, int y, byte rotation) {
            if (this.x != x || this.y != y || this.rotation != rotation) {
                this.x = x;
                this.y = y;
                this.rotation = rotation;
                BaseMapCanvas.this.markIconsDirty();
            }
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        @Override
        public void setVisibility(boolean visibility) {
            if (this.isVisible != visibility) {
                this.isVisible = visibility;
                BaseMapCanvas.this.markIconsDirty();
            }
        }

        @Override
        public class_2561 getText() {
            return this.text;
        }

        @Override
        public void setText(@Nullable class_2561 text) {
            if (!Objects.equals(this.text, text)) {
                this.text = text;
                BaseMapCanvas.this.markIconsDirty();
            }
        }

        public DrawableCanvas getOwningCanvas() {
            return BaseMapCanvas.this;
        }
    }
}

