/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.impl.font.AwtFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import eu.pb4.mapcanvas.impl.font.RawBitmapFontSerializer;
import eu.pb4.mapcanvas.impl.font.StackedFont;
import eu.pb4.mapcanvas.impl.font.VanillaFontReader;
import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;

public final class FontUtils {
    private FontUtils() {
    }

    public static CanvasFont merge(CanvasFont ... fonts) {
        return new StackedFont(fonts);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, ZipFile ... zipFile) {
        return VanillaFontReader.build(zipFile, identifier);
    }

    public static CanvasFont fromVanillaFormat(class_2960 identifier, CanvasFont.Metadata metadata, ZipFile ... zipFile) {
        return VanillaFontReader.build(zipFile, metadata, identifier);
    }

    public static CanvasFont fromMapCanvasFontFormat(InputStream stream) {
        BitmapFont font = RawBitmapFontSerializer.read(stream);
        return font != null ? font : BitmapFont.EMPTY;
    }

    public static CanvasFont fromAwtFont(Font font) {
        return new AwtFont(font, CanvasFont.Metadata.create(font.getName(), List.of(), "A font"));
    }

    public static CanvasFont fromAwtFont(Font font, CanvasFont.Metadata metadata) {
        return new AwtFont(font, metadata);
    }

    public static boolean toMapCanvasFontFormat(CanvasFont font, OutputStream stream) {
        if (font instanceof BitmapFont) {
            BitmapFont bitmapFont = (BitmapFont)font;
            return RawBitmapFontSerializer.write(bitmapFont, stream);
        }
        return false;
    }
}

