/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.mapcanvas.api.utils.ViewUtils;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5224;
import org.jetbrains.annotations.Nullable;

public final class FontRegistry {
    private final class_2960 defaultFontId;
    private final Map<class_2960, CanvasFont> fonts = new HashMap<class_2960, CanvasFont>();
    private CanvasFont defaultFont = BitmapFont.EMPTY;

    public FontRegistry() {
        this.defaultFontId = new class_2960("minecraft:default");
    }

    public FontRegistry(class_2960 defaultFont) {
        this.defaultFontId = defaultFont;
    }

    public CanvasFont register(class_2960 identifier, CanvasFont font) {
        if (this.fonts.containsKey(identifier)) {
            throw new RuntimeException("Font " + identifier + " is already registered!");
        }
        this.fonts.put(identifier, font);
        if (this.defaultFontId.equals((Object)identifier)) {
            this.defaultFont = font;
        }
        return font;
    }

    public CanvasFont getDefaultedFont(@Nullable class_2960 font) {
        return this.fonts.getOrDefault(font, this.defaultFont);
    }

    @Nullable
    public CanvasFont getFont(@Nullable class_2960 font) {
        return this.fonts.get(font);
    }

    public void drawText(final DrawableCanvas canvas, class_2561 text, final int x, final int y, final double size, final CanvasColor defaultColor) {
        text.method_30937().accept(new class_5224(){
            private int posX = 0;

            public boolean accept(int index, class_2583 style, int codePoint) {
                DrawableCanvas localCanvas;
                CanvasFont font = FontRegistry.this.getDefaultedFont(style.method_27708());
                CanvasColor color = style.method_10973() != null ? CanvasUtils.findClosestColor(style.method_10973().method_27716()) : defaultColor;
                int startX = this.posX;
                int yPos = y;
                if (style.method_10966()) {
                    yPos = (int)(size / 8.0 * 2.0);
                    localCanvas = ViewUtils.skewY(ViewUtils.shift(canvas, 0, y - yPos), -4.0 / size);
                } else {
                    localCanvas = canvas;
                }
                if (style.method_10984()) {
                    font.drawGlyph(localCanvas, codePoint, x + this.posX + 2, yPos, size, 0, color);
                }
                this.posX += font.drawGlyph(localCanvas, codePoint, x + this.posX, yPos, size, style.method_10984() ? 3 : 2, color);
                if (style.method_10965()) {
                    CanvasUtils.fill(localCanvas, x + startX, (int)((double)yPos + Math.ceil(size) + 2.0) - 2, x + this.posX, (int)((double)yPos + Math.ceil(size) + 2.0), color);
                }
                if (style.method_10986()) {
                    CanvasUtils.fill(localCanvas, x + startX, (int)((double)yPos + Math.ceil(size) / 2.0) - 1, x + this.posX, (int)((double)yPos + Math.ceil(size) / 2.0) + 1, color);
                }
                return true;
            }
        });
    }
}

