/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.font;

import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.api.font.FontRegistry;
import eu.pb4.mapcanvas.api.font.FontUtils;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import eu.pb4.mapcanvas.impl.font.RawBitmapFontSerializer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public final class DefaultFonts {
    public static final FontRegistry REGISTRY = new FontRegistry();
    public static final CanvasFont VANILLA;
    public static final CanvasFont ALT;
    public static final CanvasFont ILLAGER_ALT;
    public static final CanvasFont UNSANDED;
    public static final CanvasFont UNSANDED_BASE;

    private DefaultFonts() {
    }

    private static CanvasFont read(Path path) {
        BitmapFont font;
        try {
            font = RawBitmapFontSerializer.read(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (Exception e) {
            font = BitmapFont.EMPTY;
            e.printStackTrace();
        }
        return font != null ? font : BitmapFont.EMPTY;
    }

    static {
        Path path = ((ModContainer)FabricLoader.getInstance().getModContainer("map-canvas-api").get()).getPath("fonts");
        VANILLA = REGISTRY.register(new class_2960("minecraft:default"), DefaultFonts.read(path.resolve("vanilla.mcaf")));
        ALT = REGISTRY.register(new class_2960("minecraft:alt"), DefaultFonts.read(path.resolve("alt.mcaf")));
        ILLAGER_ALT = REGISTRY.register(new class_2960("minecraft:illageralt"), DefaultFonts.read(path.resolve("illageralt.mcaf")));
        UNSANDED_BASE = REGISTRY.register(new class_2960("unsanded:base"), DefaultFonts.read(path.resolve("unsanded.mcaf")));
        UNSANDED = REGISTRY.register(new class_2960("unsanded:full"), FontUtils.merge(UNSANDED_BASE, VANILLA));
    }
}

