/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.core;

import eu.pb4.mapcanvas.api.core.CanvasIcon;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.IconContainer;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class CanvasImage
implements DrawableCanvas,
IconContainer {
    private final int width;
    private final int height;
    private final byte[] data;
    private final Set<ImageCanvasIcon> icons = new HashSet<ImageCanvasIcon>();
    private int iconId = 0;

    public CanvasImage(int width, int height) {
        this(width, height, new byte[width * height]);
    }

    protected CanvasImage(int width, int height, byte[] data) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public static CanvasImage from(BufferedImage image) {
        return CanvasImage.from(image, ColorResolver.DEFAULT);
    }

    public static CanvasImage from(BufferedImage image, ColorResolver resolver) {
        int width = image.getWidth();
        int height = image.getHeight();
        CanvasImage canvas = new CanvasImage(image.getWidth(), image.getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                canvas.setRaw(x, y, resolver.getRawColor(image, x, y));
            }
        }
        return canvas;
    }

    public static CanvasImage from(class_22 state) {
        CanvasImage canvas = new CanvasImage(128, 128);
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                canvas.setRaw(x, y, state.field_122[x + y * 128]);
            }
        }
        for (class_20 icon : state.method_32373()) {
            canvas.createIcon(icon.method_93(), icon.method_90() - 128, icon.method_91() - 128, icon.method_89(), icon.method_88());
        }
        return canvas;
    }

    @Nullable
    public static CanvasImage from(class_2487 nbt) {
        try {
            if (nbt.method_10558("DataType").equals("MapCanvasImage") && nbt.method_10550("Version") != 0) {
                int width = nbt.method_10550("Width");
                int height = nbt.method_10550("Height");
                byte[] data = nbt.method_10547("Data");
                CanvasImage image = new CanvasImage(width, height, Arrays.copyOf(data, data.length));
                for (class_2520 tmpIcon : nbt.method_10554("Icons", 10)) {
                    class_2487 icon = (class_2487)tmpIcon;
                    image.createIcon(class_20.class_21.method_99((byte)icon.method_10571("Type")), icon.method_10577("Vis"), icon.method_10550("X"), icon.method_10550("Y"), icon.method_10571("Rot"), (class_2561)(icon.method_10573("Text", 8) ? class_2561.class_2562.method_10873((String)icon.method_10558("Text")) : null));
                }
                return image;
            }
            if (nbt.method_10573("DataVersion", 3) && nbt.method_10573("data", 10)) {
                return CanvasImage.from(class_22.method_32371((class_2487)nbt));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public byte getRaw(int x, int y) {
        if (x >= this.width || y >= this.height || x < 0 || y < 0) {
            return 0;
        }
        return this.data[x + y * this.width];
    }

    @Override
    public void setRaw(int x, int y, byte color) {
        if (x >= this.width || y >= this.height || x < 0 || y < 0) {
            return;
        }
        this.data[x + y * this.width] = color;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public Collection<CanvasIcon> getIcons() {
        return Collections.unmodifiableCollection(this.icons);
    }

    @Override
    public CanvasIcon createIcon() {
        ImageCanvasIcon icon = new ImageCanvasIcon(this.iconId++);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public CanvasIcon createIcon(class_20.class_21 type, boolean visible, int x, int y, byte rotation, @Nullable class_2561 text) {
        ImageCanvasIcon icon = new ImageCanvasIcon(this.iconId++, visible, type, x, y, rotation, text);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public void removeIcon(CanvasIcon icon) {
        this.icons.remove(icon);
    }

    @FunctionalInterface
    public static interface ColorResolver {
        public static final ColorResolver DEFAULT = (image, x, y) -> CanvasUtils.findClosestRawColorARGB(image.getRGB(x, y));
        public static final ColorResolver DEFAULT_BLACK_CLEAR = (image, x, y) -> {
            int color = image.getRGB(x, y);
            return (color & 0xFFFFFF) == 0 ? (byte)0 : CanvasUtils.findClosestRawColorARGB(color);
        };

        public byte getRawColor(BufferedImage var1, int var2, int var3);
    }

    private final class ImageCanvasIcon
    implements CanvasIcon {
        public final int id;
        private class_2561 text;
        private class_20.class_21 type = class_20.class_21.field_91;
        private int x = 0;
        private int y = 0;
        private byte rotation = 0;
        private boolean isVisible = false;

        protected ImageCanvasIcon(int id) {
            this.id = id;
        }

        protected ImageCanvasIcon(int id, boolean visible, class_20.class_21 type, int x, int y, @Nullable byte rotation, class_2561 text) {
            this.id = id;
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.text = text;
            this.isVisible = visible;
        }

        @Override
        public class_20.class_21 getType() {
            return this.type;
        }

        @Override
        public void setType(class_20.class_21 type) {
            if (this.type != type) {
                this.type = type;
            }
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public byte getRotation() {
            return this.rotation;
        }

        @Override
        public void move(int x, int y, byte rotation) {
            if (this.x != x || this.y != y || this.rotation != rotation) {
                this.x = x;
                this.y = y;
                this.rotation = rotation;
            }
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        @Override
        public void setVisibility(boolean visibility) {
            if (this.isVisible != visibility) {
                this.isVisible = visibility;
            }
        }

        @Override
        public class_2561 getText() {
            return this.text;
        }

        @Override
        public void setText(@Nullable class_2561 text) {
            if (!Objects.equals(this.text, text)) {
                this.text = text;
            }
        }

        public DrawableCanvas getOwningCanvas() {
            return CanvasImage.this;
        }
    }
}

