/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyMappingCollection<T, R>
implements Collection<R> {
    private final Collection<T> delegate;
    private final Function<T, R> mapper;

    public ReadOnlyMappingCollection(Collection<T> delegate, Function<T, R> mapper) {
        this.delegate = delegate;
        this.mapper = mapper;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        return new MappingIterator(this.delegate.iterator());
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.delegate.stream().map(this.mapper).toArray();
    }

    @Override
    @NotNull
    public <A> A[] toArray(@NotNull A[] a) {
        return this.delegate.stream().map(this.mapper).toList().toArray(a);
    }

    @Override
    public boolean add(R r) {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        Set set = this.delegate.stream().map(this.mapper).collect(Collectors.toSet());
        return set.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends R> c) {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    private class MappingIterator
    implements Iterator<R> {
        private final Iterator<T> input;

        private MappingIterator(Iterator<T> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public R next() {
            return ReadOnlyMappingCollection.this.mapper.apply(this.input.next());
        }
    }
}

