/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.net;

import alexiil.mc.lib.net.ActiveConnection;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdData;
import alexiil.mc.lib.net.NetObjectCache;
import alexiil.mc.lib.net.ParentNetId;
import alexiil.mc.lib.net.ParentNetIdSingle;
import alexiil.mc.lib.net.impl.ActiveMinecraftConnection;
import alexiil.mc.lib.net.impl.CoreMinecraftNetUtil;
import alexiil.mc.lib.net.impl.McNetworkStack;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkEntityContext;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.graph.user.SyncProfile;
import com.kneelawk.graphlib.api.util.CacheCategory;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.GraphLibImpl;
import com.kneelawk.graphlib.impl.graph.ClientGraphWorldImpl;
import com.kneelawk.graphlib.impl.graph.GraphUniverseImpl;
import com.kneelawk.graphlib.impl.graph.ServerGraphWorldImpl;
import com.kneelawk.graphlib.impl.util.ClassUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GLNet {
    public static final ParentNetId GRAPH_LIB_ID = McNetworkStack.ROOT.child("graphlib");
    public static final NetObjectCache<GraphUniverse> UNIVERSE_CACHE = NetObjectCache.createMappedIdentifier((ParentNetId)GRAPH_LIB_ID.child("universe_cache"), GraphUniverse::getId, id -> {
        GraphUniverseImpl universe = (GraphUniverseImpl)GraphLibImpl.UNIVERSE.method_10223(id);
        if (universe == null) {
            GLLog.warn("Unable to decode unknown universe {}", id);
        }
        return universe;
    });
    public static final NetObjectCache<class_2960> ID_CACHE = NetObjectCache.createMappedIdentifier((ParentNetId)GRAPH_LIB_ID.child("id_cache"), Function.identity(), Function.identity());
    public static final ParentNetIdSingle<NodeEntity> NODE_ENTITY_PARENT = new ParentNetIdSingle<NodeEntity>(GRAPH_LIB_ID, NodeEntity.class, "node_entity", -1){

        protected NodeEntity readContext(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
            class_1937 world = ctx.getConnection().getPlayer().method_37908();
            int universeIdInt = buffer.readVarUnsignedInt();
            GraphUniverse universe = (GraphUniverse)UNIVERSE_CACHE.getObj(ctx.getConnection(), universeIdInt);
            if (universe == null) {
                GLLog.warn("Unable to decode universe from unknown universe id int {}", (Object)universeIdInt);
                throw new InvalidInputDataException("Unable to decode universe from unknown universe id int " + universeIdInt);
            }
            NodePos pos = NodePos.fromPacket(buffer, ctx, universe);
            GraphView view = universe.getSidedGraphView(world);
            if (view == null) {
                throw new IllegalStateException("Player's world was neither client nor server, but was " + ClassUtils.classOf(world) + ". Unable to decode node entity packet.");
            }
            NodeEntity entity = view.getNodeEntity(pos);
            if (entity == null) {
                GLLog.warn("Failed to find node entity @ {} in world {} and universe {}", pos, world, universe.getId());
            }
            return entity;
        }

        protected void writeContext(NetByteBuf buffer, IMsgWriteCtx ctx, NodeEntity value) {
            NodeEntityContext entityCtx = value.getContext();
            buffer.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)entityCtx.getGraphWorld().getUniverse()));
            entityCtx.getPos().toPacket(buffer, ctx);
        }
    };
    public static final ParentNetIdSingle<LinkEntity> LINK_ENTITY_PARENT = new ParentNetIdSingle<LinkEntity>(GRAPH_LIB_ID, LinkEntity.class, "link_entity", -1){

        protected LinkEntity readContext(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
            class_1937 world = ctx.getConnection().getPlayer().method_37908();
            int universeIdInt = buffer.readVarUnsignedInt();
            GraphUniverse universe = (GraphUniverse)UNIVERSE_CACHE.getObj(ctx.getConnection(), universeIdInt);
            if (universe == null) {
                GLLog.warn("Unable to decode universe from unknown universe id int {}", (Object)universeIdInt);
                throw new InvalidInputDataException("Unable to decode universe from unknown universe id int " + universeIdInt);
            }
            LinkPos pos = LinkPos.fromPacket(buffer, ctx, universe);
            GraphView view = universe.getSidedGraphView(world);
            if (view == null) {
                throw new IllegalStateException("Player's world was neither client nor server, but was " + ClassUtils.classOf(world) + ". Unable to decode link entity packet.");
            }
            LinkEntity entity = view.getLinkEntity(pos);
            if (entity == null) {
                GLLog.warn("Failed to find link entity @ {} in world {} and universe {}", pos, world, universe.getId());
            }
            return entity;
        }

        protected void writeContext(NetByteBuf buffer, IMsgWriteCtx ctx, LinkEntity value) {
            LinkEntityContext entityCtx = value.getContext();
            buffer.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)entityCtx.getGraphWorld().getUniverse()));
            entityCtx.getPos().toPacket(buffer, ctx);
        }
    };
    public static final ParentNetIdSingle<GraphEntity> GRAPH_ENTITY_PARENT = new ParentNetIdSingle<GraphEntity>(GRAPH_LIB_ID, GraphEntity.class, "graph_entity", -1){

        protected GraphEntity<?> readContext(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
            class_1937 world = ctx.getConnection().getPlayer().method_37908();
            int universeIdInt = buffer.readVarUnsignedInt();
            GraphUniverse universe = (GraphUniverse)UNIVERSE_CACHE.getObj(ctx.getConnection(), universeIdInt);
            if (universe == null) {
                GLLog.warn("Unable to decode universe from unknown universe id int {}", (Object)universeIdInt);
                throw new InvalidInputDataException("Unable to decode universe from unknown universe id int " + universeIdInt);
            }
            GraphView view = universe.getSidedGraphView(world);
            if (view == null) {
                throw new IllegalStateException("Player's world was neither client nor server, but was " + ClassUtils.classOf(world) + ". Unable to decode graph entity packet.");
            }
            long graphId = buffer.readVarUnsignedLong();
            BlockGraph graph = view.getGraph(graphId);
            if (graph == null) {
                GLLog.warn("Unable to find graph for id {} in world {} in universe {}", graphId, world, universe.getId());
                return null;
            }
            int typeIdInt = buffer.readVarUnsignedInt();
            class_2960 typeId = (class_2960)ID_CACHE.getObj(ctx.getConnection(), typeIdInt);
            if (typeId == null) {
                GLLog.warn("Unable to decode graph entity type id from int {}", (Object)typeIdInt);
                throw new InvalidInputDataException("Unable to decode graph entity type id from int " + typeIdInt);
            }
            GraphEntityType<?> type = universe.getGraphEntityType(typeId);
            if (type == null) {
                GLLog.warn("Encountered unknown graph entity type {}", (Object)typeId);
                throw new InvalidInputDataException("Encountered unknown graph entity type " + typeId);
            }
            return graph.getGraphEntity(type);
        }

        protected void writeContext(NetByteBuf buffer, IMsgWriteCtx ctx, GraphEntity value) {
            GraphEntityContext entityCtx = value.getContext();
            buffer.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)entityCtx.getGraphWorld().getUniverse()));
            buffer.writeVarUnsignedLong(entityCtx.getGraph().getId());
            buffer.writeVarUnsignedInt(ID_CACHE.getId(ctx.getConnection(), (Object)value.getType().getId()));
        }
    };
    public static final NetIdData CHUNK_DATA = new NetIdData(GRAPH_LIB_ID, "chunk_data", -1).toClientOnly().setReceiver(GLNet::receiveChunkDataPacket);
    public static final NetIdData NODE_ADD = new NetIdData(GRAPH_LIB_ID, "node_add", -1).toClientOnly().setReceiver(GLNet::receiveNodeAdd);
    public static final NetIdData GRAPH_MERGE = new NetIdData(GRAPH_LIB_ID, "graph_merge", -1).toClientOnly().setReceiver(GLNet::receiveMerge);
    public static final NetIdData NODE_LINK = new NetIdData(GRAPH_LIB_ID, "node_link", -1).toClientOnly().setReceiver(GLNet::receiveLink);
    public static final NetIdData NODE_UNLINK = new NetIdData(GRAPH_LIB_ID, "node_unlink", -1).toClientOnly().setReceiver(GLNet::receiveUnlink);
    public static final NetIdData GRAPH_SPLIT = new NetIdData(GRAPH_LIB_ID, "graph_split", -1).toClientOnly().setReceiver(GLNet::receiveSplitInto);
    public static final NetIdData NODE_REMOVE = new NetIdData(GRAPH_LIB_ID, "node_remove", -1).toClientOnly().setReceiver(GLNet::receiveNodeRemove);

    public static void init() {
    }

    @NotNull
    public static <T> T readType(@NotNull NetByteBuf buf, ActiveConnection conn, @NotNull @NotNull Function<@NotNull class_2960, @Nullable T> typeGetter, @NotNull String typeName, class_2338 blockPos) throws InvalidInputDataException {
        int typeIdInt = buf.readVarUnsignedInt();
        class_2960 typeId = (class_2960)ID_CACHE.getObj(conn, typeIdInt);
        if (typeId == null) {
            GLLog.warn("Unable to decode unknown {} id int: {} @ {}", typeName, typeIdInt, blockPos);
            throw new InvalidInputDataException("Unable to decode unknown " + typeName + " id int: " + typeIdInt + " @ " + blockPos);
        }
        T type = typeGetter.apply(typeId);
        if (type == null) {
            GLLog.warn("Unable to decode unknown {} id: {} @ {}", typeName, typeId, blockPos);
            throw new InvalidInputDataException("Unable to decode unknown " + typeName + " id: " + typeId + " @ " + blockPos);
        }
        return type;
    }

    public static void writeType(@NotNull NetByteBuf buf, @NotNull ActiveConnection conn, class_2960 typeId) {
        buf.writeVarUnsignedInt(ID_CACHE.getId(conn, (Object)typeId));
    }

    public static void sendChunkDataPacket(ServerGraphWorldImpl world, class_3222 player, class_1923 pos) {
        ActiveMinecraftConnection connection = CoreMinecraftNetUtil.getConnection((class_1657)player);
        CHUNK_DATA.send((ActiveConnection)connection, (buffer, ctx) -> {
            buffer.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)world.getUniverse()));
            buffer.writeVarInt(pos.field_9181);
            buffer.writeVarInt(pos.field_9180);
            world.writeChunkPillar(pos, buffer, ctx);
        });
    }

    private static void receiveChunkDataPacket(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "chunk data");
        if (world == null) {
            return;
        }
        int chunkX = buf.method_10816();
        int chunkZ = buf.method_10816();
        world.readChunkPillar(chunkX, chunkZ, buf, ctx);
    }

    public static void sendNodeAdd(BlockGraph graph, NodeHolder<BlockNode> node) {
        GraphView graphView = graph.getGraphView();
        if (!(graphView instanceof ServerGraphWorldImpl)) {
            throw new IllegalArgumentException("sendNodeAdd should only be called on the logical server");
        }
        ServerGraphWorldImpl world = (ServerGraphWorldImpl)graphView;
        GraphUniverse universe = world.getUniverse();
        SyncProfile sp = universe.getSyncProfile();
        if (!sp.isEnabled()) {
            return;
        }
        if (sp.getNodeFilter() != null && !sp.getNodeFilter().matches(node)) {
            return;
        }
        Collection watching = PlayerLookup.tracking((class_3218)world.getWorld(), (class_2338)node.getBlockPos());
        for (class_3222 player : watching) {
            if (!sp.getPlayerFilter().shouldSync(player)) continue;
            ActiveMinecraftConnection conn = CoreMinecraftNetUtil.getConnection((class_1657)player);
            NODE_ADD.send((ActiveConnection)conn, (buf, ctx) -> {
                buf.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)universe));
                world.writeNodeAdd(graph, node, buf, ctx);
            });
        }
    }

    private static void receiveNodeAdd(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "node add");
        if (world == null) {
            return;
        }
        world.readNodeAdd(buf, ctx);
    }

    @Nullable
    private static ClientGraphWorldImpl readClientGraphWorld(NetByteBuf buf, IMsgReadCtx ctx, String packetName) {
        int universeIdInt = buf.readVarUnsignedInt();
        GraphUniverseImpl universe = (GraphUniverseImpl)UNIVERSE_CACHE.getObj(ctx.getConnection(), universeIdInt);
        if (universe == null) {
            GLLog.warn("Received {} packet for unknown universe id int: {}", (Object)packetName, (Object)universeIdInt);
            ctx.drop("Received " + packetName + " for unknown universe");
            return null;
        }
        ClientGraphWorldImpl world = universe.getClientGraphView();
        if (world == null) {
            GLLog.warn("Received {} packet but the client GraphWorld was null", (Object)packetName);
            ctx.drop("Received " + packetName + " but client GraphWorld was null");
            return null;
        }
        return world;
    }

    public static void sendMerge(BlockGraph from, BlockGraph into) {
        GraphView graphView = into.getGraphView();
        if (!(graphView instanceof ServerGraphWorldImpl)) {
            throw new IllegalArgumentException("sendMerge should only be called on the logical server");
        }
        ServerGraphWorldImpl world = (ServerGraphWorldImpl)graphView;
        GraphUniverse universe = world.getUniverse();
        SyncProfile sp = universe.getSyncProfile();
        if (!sp.isEnabled()) {
            return;
        }
        LinkedHashSet sendTo = new LinkedHashSet();
        Iterator iter = into.getChunks().iterator();
        while (iter.hasNext()) {
            sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_1923)((class_4076)iter.next()).method_18692()));
        }
        iter = from.getChunks().iterator();
        while (iter.hasNext()) {
            sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_1923)((class_4076)iter.next()).method_18692()));
        }
        for (class_3222 player : sendTo) {
            if (!sp.getPlayerFilter().shouldSync(player)) continue;
            ActiveMinecraftConnection conn = CoreMinecraftNetUtil.getConnection((class_1657)player);
            GRAPH_MERGE.send((ActiveConnection)conn, (buf, ctx) -> {
                buf.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)universe));
                world.writeMerge(from, into, buf, ctx);
            });
        }
    }

    private static void receiveMerge(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "graph merge");
        if (world == null) {
            return;
        }
        world.readMerge(buf, ctx);
    }

    public static void sendLink(BlockGraph graph, LinkHolder<LinkKey> link) {
        GraphView graphView = graph.getGraphView();
        if (!(graphView instanceof ServerGraphWorldImpl)) {
            throw new IllegalArgumentException("sendLink should only be called on the logical server");
        }
        ServerGraphWorldImpl world = (ServerGraphWorldImpl)graphView;
        GraphUniverse universe = world.getUniverse();
        SyncProfile sp = universe.getSyncProfile();
        if (!sp.isEnabled()) {
            return;
        }
        CacheCategory<BlockNode> nodeFilter = sp.getNodeFilter();
        if (!(nodeFilter == null || nodeFilter.matches(link.getFirst()) && nodeFilter.matches(link.getSecond()))) {
            return;
        }
        LinkedHashSet sendTo = new LinkedHashSet();
        sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_2338)link.getFirstBlockPos()));
        sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_2338)link.getSecondBlockPos()));
        for (class_3222 player : sendTo) {
            if (!sp.getPlayerFilter().shouldSync(player)) continue;
            ActiveMinecraftConnection conn = CoreMinecraftNetUtil.getConnection((class_1657)player);
            NODE_LINK.send((ActiveConnection)conn, (buf, ctx) -> {
                buf.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)universe));
                world.writeLink(graph, link, buf, ctx);
            });
        }
    }

    private static void receiveLink(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "node link");
        if (world == null) {
            return;
        }
        world.readLink(buf, ctx);
    }

    public static void sendUnlink(BlockGraph graph, NodeHolder<BlockNode> a, NodeHolder<BlockNode> b, LinkKey key) {
        GraphView graphView = graph.getGraphView();
        if (!(graphView instanceof ServerGraphWorldImpl)) {
            throw new IllegalArgumentException("sendUnlink should only be called on the logical server");
        }
        ServerGraphWorldImpl world = (ServerGraphWorldImpl)graphView;
        GraphUniverse universe = world.getUniverse();
        SyncProfile sp = universe.getSyncProfile();
        if (!sp.isEnabled()) {
            return;
        }
        CacheCategory<BlockNode> nodeFilter = sp.getNodeFilter();
        if (!(nodeFilter == null || nodeFilter.matches(a) && nodeFilter.matches(b))) {
            return;
        }
        LinkedHashSet sendTo = new LinkedHashSet();
        sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_2338)a.getBlockPos()));
        sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_2338)b.getBlockPos()));
        for (class_3222 player : sendTo) {
            if (!sp.getPlayerFilter().shouldSync(player)) continue;
            ActiveMinecraftConnection conn = CoreMinecraftNetUtil.getConnection((class_1657)player);
            NODE_UNLINK.send((ActiveConnection)conn, (buf, ctx) -> {
                buf.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)universe));
                world.writeUnlink(graph, a, b, key, buf, ctx);
            });
        }
    }

    private static void receiveUnlink(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "node unlink");
        if (world == null) {
            return;
        }
        world.readUnlink(buf, ctx);
    }

    public static void sendSplitInto(BlockGraph from, BlockGraph into) {
        GraphView graphView = into.getGraphView();
        if (!(graphView instanceof ServerGraphWorldImpl)) {
            throw new IllegalArgumentException("sendSplitInto should only be called on the logical server");
        }
        ServerGraphWorldImpl world = (ServerGraphWorldImpl)graphView;
        GraphUniverse universe = world.getUniverse();
        SyncProfile sp = universe.getSyncProfile();
        if (!sp.isEnabled()) {
            return;
        }
        LinkedHashSet sendTo = new LinkedHashSet();
        Iterator iter = into.getChunks().iterator();
        while (iter.hasNext()) {
            sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_1923)((class_4076)iter.next()).method_18692()));
        }
        iter = from.getChunks().iterator();
        while (iter.hasNext()) {
            sendTo.addAll(PlayerLookup.tracking((class_3218)world.getWorld(), (class_1923)((class_4076)iter.next()).method_18692()));
        }
        for (class_3222 player : sendTo) {
            if (!sp.getPlayerFilter().shouldSync(player)) continue;
            ActiveMinecraftConnection conn = CoreMinecraftNetUtil.getConnection((class_1657)player);
            GRAPH_SPLIT.send((ActiveConnection)conn, (buf, ctx) -> {
                buf.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)universe));
                world.writeSplitInto(from, into, buf, ctx);
            });
        }
    }

    private static void receiveSplitInto(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "graph split");
        if (world == null) {
            return;
        }
        world.readSplitInto(buf, ctx);
    }

    public static void sendNodeRemove(BlockGraph graph, NodeHolder<BlockNode> holder) {
        GraphView graphView = graph.getGraphView();
        if (!(graphView instanceof ServerGraphWorldImpl)) {
            throw new IllegalArgumentException("sendNodeRemove should only be called on the logical server");
        }
        ServerGraphWorldImpl world = (ServerGraphWorldImpl)graphView;
        GraphUniverse universe = world.getUniverse();
        SyncProfile sp = universe.getSyncProfile();
        if (!sp.isEnabled()) {
            return;
        }
        if (sp.getNodeFilter() != null && !sp.getNodeFilter().matches(holder)) {
            return;
        }
        Collection watching = PlayerLookup.tracking((class_3218)world.getWorld(), (class_2338)holder.getBlockPos());
        for (class_3222 player : watching) {
            if (!sp.getPlayerFilter().shouldSync(player)) continue;
            ActiveMinecraftConnection conn = CoreMinecraftNetUtil.getConnection((class_1657)player);
            NODE_REMOVE.send((ActiveConnection)conn, (buf, ctx) -> {
                buf.writeVarUnsignedInt(UNIVERSE_CACHE.getId(ctx.getConnection(), (Object)universe));
                world.writeNodeRemove(graph, holder, buf, ctx);
            });
        }
    }

    private static void receiveNodeRemove(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        ClientGraphWorldImpl world = GLNet.readClientGraphWorld(buf, ctx, "node remove");
        if (world == null) {
            return;
        }
        world.readNodeRemove(buf, ctx);
    }
}

