/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.net;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.kneelawk.graphlib.api.event.GraphLibEvents;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.GraphWorld;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.impl.Constants;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.util.ClassUtils;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.server.MinecraftServer;

public final class GLDebugNet {
    public static final class_2960 ID_MAP_BULK_ID = Constants.id("id_map_bulk");
    public static final class_2960 ID_MAP_PUT_ID = Constants.id("id_map_put");
    public static final class_2960 GRAPH_UPDATE_ID = Constants.id("graph_update");
    public static final class_2960 GRAPH_UPDATE_BULK_ID = Constants.id("graph_update_bulk");
    public static final class_2960 GRAPH_DESTROY_ID = Constants.id("graph_destroy");
    public static final class_2960 DEBUGGING_STOP_ID = Constants.id("debugging_stop");
    private static final Multimap<UUID, class_2960> debuggingPlayers = LinkedHashMultimap.create();
    private static final Object2IntMap<class_2960> idMap = new Object2IntLinkedOpenHashMap();

    private GLDebugNet() {
    }

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> debuggingPlayers.clear());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> debuggingPlayers.clear());
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> debuggingPlayers.removeAll((Object)handler.field_14140.method_5667()));
        GraphLibEvents.GRAPH_CREATED.register(GLDebugNet::sendBlockGraph);
        GraphLibEvents.GRAPH_UPDATED.register(GLDebugNet::sendBlockGraph);
        GraphLibEvents.GRAPH_DESTROYED.register((world, graphWorld, id) -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10804(GLDebugNet.getIdentifierInt(world, graphWorld.getUniverse().getId()));
            buf.writeLong(id);
            GLDebugNet.sendToDebuggingPlayers(world, graphWorld.getUniverse().getId(), GRAPH_DESTROY_ID, buf);
        });
    }

    public static void startDebuggingPlayer(class_3222 player, GraphUniverse universe) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            GLLog.warn("Tried to start debugging a player with a world that was neither client nor server, but was {}", (Object)ClassUtils.classOf(player.method_37908()));
            return;
        }
        class_3218 world = (class_3218)class_19372;
        GLDebugNet.sendIdMap(player);
        debuggingPlayers.put((Object)player.method_5667(), (Object)universe.getId());
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(GLDebugNet.getIdentifierInt(world, universe.getId()));
        MinecraftServer server = world.method_8503();
        GraphWorld graphWorld = universe.getServerGraphWorld(world);
        int viewDistance = server.method_3760().method_14568();
        class_4076 playerPos = player.method_14232();
        int minX = playerPos.method_18674() - viewDistance - 1;
        int minZ = playerPos.method_18687() - viewDistance - 1;
        int maxX = playerPos.method_18674() + viewDistance + 1;
        int maxZ = playerPos.method_18687() + viewDistance + 1;
        LongLinkedOpenHashSet graphIds = new LongLinkedOpenHashSet();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                if (!class_3898.method_39975((int)x, (int)z, (int)playerPos.method_18674(), (int)playerPos.method_18687(), (int)viewDistance)) continue;
                class_1923 pos = new class_1923(x, z);
                graphWorld.getAllGraphIdsInChunk(pos).forEach(arg_0 -> ((LongSet)graphIds).add(arg_0));
            }
        }
        List<BlockGraph> graphs = graphIds.longStream().mapToObj(graphWorld::getGraph).filter(Objects::nonNull).toList();
        buf.method_10804(graphs.size());
        for (BlockGraph graph : graphs) {
            GLDebugNet.encodeBlockGraph(world, graphWorld, graph, buf);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)GRAPH_UPDATE_BULK_ID, (class_2540)buf);
    }

    public static void stopDebuggingPlayer(class_3222 player, class_2960 universe) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            GLLog.warn("Tried to stop debugging a player with a world that was neither client nor server, but was {}", (Object)ClassUtils.classOf(player.method_37908()));
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(GLDebugNet.getIdentifierInt(world, universe));
        ServerPlayNetworking.send((class_3222)player, (class_2960)DEBUGGING_STOP_ID, (class_2540)buf);
        debuggingPlayers.remove((Object)player.method_5667(), (Object)universe);
    }

    private static void sendIdMap(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(idMap.size());
        for (Object2IntMap.Entry entry : idMap.object2IntEntrySet()) {
            buf.method_10812((class_2960)entry.getKey());
            buf.method_10804(entry.getIntValue());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID_MAP_BULK_ID, (class_2540)buf);
    }

    private static int getIdentifierInt(class_3218 world, class_2960 id) {
        if (idMap.containsKey((Object)id)) {
            return idMap.getInt((Object)id);
        }
        int index = idMap.size();
        idMap.put((Object)id, index);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(id);
        buf.method_10804(index);
        GLDebugNet.sendToDebuggingPlayers(world, ID_MAP_PUT_ID, buf);
        return index;
    }

    private static void sendBlockGraph(class_3218 world, GraphWorld graphWorld, BlockGraph graph) {
        if (debuggingPlayers.isEmpty()) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(GLDebugNet.getIdentifierInt(world, graphWorld.getUniverse().getId()));
        GLDebugNet.encodeBlockGraph(world, graphWorld, graph, buf);
        LinkedHashSet sendTo = new LinkedHashSet();
        graph.getChunks().forEachOrdered(section -> {
            for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_1923)section.method_18692())) {
                if (!debuggingPlayers.containsEntry((Object)player.method_5667(), (Object)graphWorld.getUniverse().getId())) continue;
                sendTo.add(player);
            }
        });
        for (class_3222 player : sendTo) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)GRAPH_UPDATE_ID, (class_2540)buf);
        }
    }

    private static void encodeBlockGraph(class_3218 world, GraphWorld graphWorld, BlockGraph graph, class_2540 buf) {
        buf.writeLong(graph.getId());
        AtomicInteger index = new AtomicInteger();
        HashMap indexMap = new HashMap();
        LinkedHashSet distinct = new LinkedHashSet();
        buf.method_10804(graph.size());
        graph.getNodes().forEachOrdered(node -> {
            buf.method_10804(GLDebugNet.getIdentifierInt(world, node.getNode().getType().getId()));
            buf.method_10807(node.getBlockPos());
            node.getNode().toDebugPacket((NodeHolder<BlockNode>)node, buf);
            indexMap.put(node.getPos(), index.getAndIncrement());
            node.getConnections().stream().map(LinkHolder::getPos).forEach(distinct::add);
        });
        class_2540 linkBuf = PacketByteBufs.create();
        int written = 0;
        for (LinkPos link : distinct) {
            if (!indexMap.containsKey(link.first())) {
                GLLog.warn("Attempted to save link with non-existent node. Graph Id: {}, offending node: {}, missing node: {}", graph.getId(), link.second(), link.first());
                continue;
            }
            if (!indexMap.containsKey(link.second())) {
                GLLog.warn("Attempted to save link with non-existent node. Graph Id: {}, offending node: {}, missing node: {}", graph.getId(), link.first(), link.second());
                continue;
            }
            linkBuf.method_10804(((Integer)indexMap.get(link.first())).intValue());
            linkBuf.method_10804(((Integer)indexMap.get(link.second())).intValue());
            ++written;
        }
        buf.method_10804(written);
        buf.writeBytes((ByteBuf)linkBuf);
    }

    private static void sendToDebuggingPlayers(class_3218 world, class_2960 packetId, class_2540 buf) {
        class_3324 manager = world.method_8503().method_3760();
        for (UUID playerId : debuggingPlayers.keySet()) {
            class_3222 player = manager.method_14602(playerId);
            if (player == null) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf);
        }
    }

    private static void sendToDebuggingPlayers(class_3218 world, class_2960 universe, class_2960 packetId, class_2540 buf) {
        class_3324 manager = world.method_8503().method_3760();
        for (UUID playerId : debuggingPlayers.keySet()) {
            class_3222 player;
            if (!debuggingPlayers.containsEntry((Object)playerId, (Object)universe) || (player = manager.method_14602(playerId)) == null) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf);
        }
    }
}

