/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import com.kneelawk.graphlib.api.event.GraphLibEvents;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.GraphWorld;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.graph.user.SidedBlockNode;
import com.kneelawk.graphlib.api.util.CacheCategory;
import com.kneelawk.graphlib.api.util.ChunkSectionUnloadTimer;
import com.kneelawk.graphlib.api.util.HalfLink;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.api.util.SidedPos;
import com.kneelawk.graphlib.api.world.SaveMode;
import com.kneelawk.graphlib.api.world.UnloadingRegionBasedStorage;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.graph.RebuildChunksListener;
import com.kneelawk.graphlib.impl.graph.ServerGraphWorldImpl;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraph;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraphChunk;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphCollection;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphUniverse;
import com.kneelawk.graphlib.impl.graph.simple.SimpleNodeHolder;
import com.kneelawk.graphlib.impl.net.GLNet;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleServerGraphWorld
implements AutoCloseable,
GraphWorld,
ServerGraphWorldImpl,
SimpleGraphCollection {
    private static final int MAX_AGE = 1200;
    private static final int INCREMENTAL_SAVE_FACTOR = 10;
    private static final int MAX_GRAPHS_REBUILT_PER_TICK = 100;
    final SimpleGraphUniverse universe;
    final class_3218 world;
    private final UnloadingRegionBasedStorage<SimpleBlockGraphChunk> chunks;
    private final ChunkSectionUnloadTimer timer;
    private final Path graphsDir;
    private final Path stateFile;
    private final SaveMode saveMode;
    private final Long2ObjectMap<SimpleBlockGraph> loadedGraphs = new Long2ObjectLinkedOpenHashMap();
    private final LongSet unsavedGraphs = new LongOpenHashSet();
    private final ObjectSet<class_2338> nodeUpdates = new ObjectLinkedOpenHashSet();
    private final ObjectSet<UpdatePos> connectionUpdates = new ObjectLinkedOpenHashSet();
    private final Map<NodePos, CallbackUpdate> callbackUpdates = new Object2ObjectLinkedOpenHashMap();
    private boolean stateDirty = false;
    private long prevGraphId = -1L;
    private ChunkRebuildState rebuildState = null;
    private boolean closed = false;
    private static final Pattern GRAPH_ID_PATTERN = Pattern.compile("^(?<id>[\\da-fA-F]+)\\.dat$");

    public SimpleServerGraphWorld(SimpleGraphUniverse universe, @NotNull class_3218 world, @NotNull Path path, boolean syncChunkWrites) {
        this.universe = universe;
        this.chunks = new UnloadingRegionBasedStorage<SimpleBlockGraphChunk>(world, path.resolve("region"), syncChunkWrites, (compound, pos, markDirty) -> new SimpleBlockGraphChunk(compound, pos, markDirty, universe), SimpleBlockGraphChunk::new, universe.saveMode);
        this.world = world;
        this.saveMode = universe.saveMode;
        this.graphsDir = path.resolve("graphs");
        this.stateFile = path.resolve("state.dat");
        this.timer = new ChunkSectionUnloadTimer(world.method_32891(), world.method_31597(), 1200L);
        try {
            Files.createDirectories(this.graphsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create graphs dir: '" + this.graphsDir + "'. This is a fatal exception.", e);
        }
        this.loadState();
    }

    @Override
    public void onWorldChunkLoad(@NotNull class_1923 pos) {
        if (this.closed) {
            return;
        }
        this.chunks.onWorldChunkLoad(pos);
        this.timer.onWorldChunkLoad(pos);
        this.loadGraphs(pos);
    }

    @Override
    public void onWorldChunkUnload(@NotNull class_1923 pos) {
        this.chunks.onWorldChunkUnload(pos);
        this.timer.onWorldChunkUnload(pos);
    }

    @Override
    public void tick() {
        this.continueRebuildingChunks();
        this.chunks.tick();
        this.timer.tick();
        this.tickGraphs();
        this.handleNodeUpdates();
        this.handleConnectionUpdates();
        this.handleCallbackUpdates();
        this.unloadGraphs();
        this.saveUnsvedGraphs();
    }

    @Override
    public void saveChunk(@NotNull class_1923 pos) {
        this.saveState();
        this.saveGraphs(pos);
        this.chunks.saveChunk(pos);
    }

    @Override
    public void saveAll(boolean flush) {
        this.saveAllGraphs();
        this.saveState();
        this.chunks.saveAll();
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.saveAllGraphs();
        this.saveState();
        this.chunks.close();
    }

    @Override
    public void writeChunkPillar(class_1923 chunkPos, NetByteBuf buf, IMsgWriteCtx ctx) {
        Long2ObjectLinkedOpenHashMap toEncode = new Long2ObjectLinkedOpenHashMap();
        for (int chunkY = this.world.method_32891(); chunkY < this.world.method_31597(); ++chunkY) {
            SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18681((class_1923)chunkPos, (int)chunkY));
            if (chunk == null) continue;
            LongIterator longIterator = chunk.getGraphs().iterator();
            while (longIterator.hasNext()) {
                long graphId = (Long)longIterator.next();
                SimpleBlockGraph graph = this.getGraph(graphId);
                if (graph == null) continue;
                toEncode.put(graphId, (Object)graph);
            }
        }
        buf.writeVarUnsignedInt(toEncode.size());
        for (SimpleBlockGraph graph : toEncode.values()) {
            buf.writeMarker("gs");
            buf.writeVarUnsignedLong(graph.getId());
            graph.writeGraphEntitiesToPacket(buf, ctx);
            buf.writeMarker("n");
            Object2IntLinkedOpenHashMap indexMap = new Object2IntLinkedOpenHashMap();
            indexMap.defaultReturnValue(-1);
            ObjectLinkedOpenHashSet internalLinks = new ObjectLinkedOpenHashSet();
            ObjectLinkedOpenHashSet externalLinks = new ObjectLinkedOpenHashSet();
            CacheCategory<BlockNode> nodeFilter = this.universe.getSyncProfile().getNodeFilter();
            Iterator<Object> iter = nodeFilter != null ? graph.getCachedNodes(nodeFilter).iterator() : graph.getNodes().iterator();
            int nodeCountIndex = buf.writerIndex();
            buf.writeInt(0);
            int nodeCount = 0;
            while (iter.hasNext()) {
                NodeHolder holder = (NodeHolder)iter.next();
                class_2338 blockPos = holder.getBlockPos();
                if (blockPos.method_10263() < chunkPos.method_8326() || chunkPos.method_8327() < blockPos.method_10263() || blockPos.method_10260() < chunkPos.method_8328() || chunkPos.method_8329() < blockPos.method_10260()) continue;
                holder.getPos().toPacket(buf, ctx);
                SimpleServerGraphWorld.writeNodeEntity(holder, buf, ctx, graph);
                indexMap.put((Object)holder.getPos(), nodeCount);
                for (LinkHolder linkHolder : holder.getConnections()) {
                    NodeHolder<BlockNode> other = linkHolder.other(holder);
                    if (nodeFilter != null && !nodeFilter.matches(other)) continue;
                    class_2338 otherPos = other.getBlockPos();
                    if (otherPos.method_10263() < chunkPos.method_8326() || chunkPos.method_8327() < otherPos.method_10263() || otherPos.method_10260() < chunkPos.method_8328() || chunkPos.method_8329() < otherPos.method_10260()) {
                        externalLinks.add(linkHolder.getPos());
                        continue;
                    }
                    internalLinks.add(linkHolder.getPos());
                }
                ++nodeCount;
            }
            buf.setInt(nodeCountIndex, nodeCount);
            buf.writeMarker("il");
            int iLinkCountIndex = buf.writerIndex();
            buf.writeInt(0);
            int iLinkCount = 0;
            for (LinkPos linkPos : internalLinks) {
                int nodeAIndex = indexMap.getInt((Object)linkPos.first());
                int nodeBIndex = indexMap.getInt((Object)linkPos.second());
                if (nodeAIndex < 0 || nodeBIndex < 0) {
                    GLLog.warn("Tried to send an internal link to a node that does not exist within the same chunk. Link: {}", (Object)linkPos);
                    continue;
                }
                buf.writeVarUnsignedInt(nodeAIndex);
                buf.writeVarUnsignedInt(nodeBIndex);
                LinkKey linkKey = linkPos.key();
                GLNet.writeType(buf, ctx.getConnection(), linkKey.getType().getId());
                linkKey.toPacket(buf, ctx);
                SimpleServerGraphWorld.writeLinkEntity(buf, ctx, linkPos, graph);
                ++iLinkCount;
            }
            buf.setInt(iLinkCountIndex, iLinkCount);
            buf.writeMarker("el");
            buf.writeVarUnsignedInt(externalLinks.size());
            for (LinkPos linkPos : externalLinks) {
                linkPos.toPacket(buf, ctx);
                SimpleServerGraphWorld.writeLinkEntity(buf, ctx, linkPos, graph);
            }
            buf.writeMarker("ge");
        }
    }

    private static void writeNodeEntity(NodeHolder<BlockNode> node, NetByteBuf buf, IMsgWriteCtx ctx, BlockGraph graph) {
        NodeEntity entity = graph.getNodeEntity(node.getPos());
        if (entity != null) {
            buf.writeBoolean(true);
            GLNet.writeType(buf, ctx.getConnection(), entity.getType().getId());
            entity.toPacket(buf, ctx);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static void writeLinkEntity(NetByteBuf buf, IMsgWriteCtx ctx, LinkPos link, BlockGraph graph) {
        LinkEntity entity = graph.getLinkEntity(link);
        if (entity != null) {
            buf.writeBoolean(true);
            GLNet.writeType(buf, ctx.getConnection(), entity.getType().getId());
            entity.toPacket(buf, ctx);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void writeNodeAdd(BlockGraph graph, NodeHolder<BlockNode> node, NetByteBuf buf, IMsgWriteCtx ctx) {
        node.getPos().toPacket(buf, ctx);
        buf.writeVarUnsignedLong(graph.getId());
        ((SimpleBlockGraph)graph).writeGraphEntitiesToPacket(buf, ctx);
        SimpleServerGraphWorld.writeNodeEntity(node, buf, ctx, graph);
    }

    @Override
    public void writeMerge(BlockGraph from, BlockGraph into, NetByteBuf buf, IMsgWriteCtx ctx) {
        buf.writeVarUnsignedLong(from.getId());
        buf.writeVarUnsignedLong(into.getId());
        ((SimpleBlockGraph)into).writeGraphEntitiesToPacket(buf, ctx);
    }

    @Override
    public void writeLink(BlockGraph graph, LinkHolder<LinkKey> link, NetByteBuf buf, IMsgWriteCtx ctx) {
        buf.writeVarUnsignedLong(graph.getId());
        LinkPos linkPos = link.getPos();
        linkPos.toPacket(buf, ctx);
        SimpleServerGraphWorld.writeLinkEntity(buf, ctx, linkPos, graph);
    }

    @Override
    public void writeUnlink(BlockGraph graph, NodeHolder<BlockNode> a, NodeHolder<BlockNode> b, LinkKey key, NetByteBuf buf, IMsgWriteCtx ctx) {
        buf.writeVarUnsignedLong(graph.getId());
        LinkPos linkPos = new LinkPos(a.getPos(), b.getPos(), key);
        linkPos.toPacket(buf, ctx);
    }

    @Override
    public void writeSplitInto(BlockGraph from, BlockGraph into, NetByteBuf buf, IMsgWriteCtx ctx) {
        int nodeCount;
        Iterator<Object> iter;
        buf.writeVarUnsignedLong(from.getId());
        buf.writeVarUnsignedLong(into.getId());
        ((SimpleBlockGraph)into).writeGraphEntitiesToPacket(buf, ctx);
        CacheCategory<?> nodeFilter = this.universe.getSyncProfile().getNodeFilter();
        if (nodeFilter != null) {
            Collection<NodeHolder<?>> cachedNodes = into.getCachedNodes(nodeFilter);
            iter = cachedNodes.iterator();
            nodeCount = cachedNodes.size();
        } else {
            iter = into.getNodes().iterator();
            nodeCount = into.size();
        }
        buf.writeVarUnsignedInt(nodeCount);
        while (iter.hasNext()) {
            NodeHolder holder = (NodeHolder)iter.next();
            holder.getPos().toPacket(buf, ctx);
        }
    }

    @Override
    public void writeNodeRemove(BlockGraph graph, NodeHolder<BlockNode> holder, NetByteBuf buf, IMsgWriteCtx ctx) {
        buf.writeVarUnsignedLong(graph.getId());
        holder.getPos().toPacket(buf, ctx);
    }

    @Override
    @NotNull
    public GraphUniverse getUniverse() {
        return this.universe;
    }

    @Override
    @NotNull
    public class_3218 getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public Stream<NodeHolder<BlockNode>> getNodesAt(@NotNull class_2338 pos) {
        return this.getAllGraphIdsAt(pos).mapToObj(this::getGraph).filter(Objects::nonNull).flatMap(g -> g.getNodesAt(pos));
    }

    @Override
    @NotNull
    public Stream<NodeHolder<SidedBlockNode>> getNodesAt(@NotNull SidedPos pos) {
        return this.getAllGraphIdsAt(pos.pos()).mapToObj(this::getGraph).filter(Objects::nonNull).flatMap(g -> g.getNodesAt(pos));
    }

    @Override
    @Nullable
    public NodeHolder<BlockNode> getNodeAt(@NotNull NodePos pos) {
        SimpleBlockGraph graph = this.getGraphForNode(pos);
        if (graph != null) {
            return graph.getNodeAt(pos);
        }
        return null;
    }

    @Override
    public boolean nodeExistsAt(@NotNull NodePos pos) {
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18682((class_2338)pos.pos()));
        if (chunk != null) {
            return chunk.containsNode(pos, (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)this::getGraph));
        }
        return false;
    }

    @Override
    @Nullable
    public SimpleBlockGraph getGraphForNode(@NotNull NodePos pos) {
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18682((class_2338)pos.pos()));
        if (chunk != null) {
            return chunk.getGraphForNode(pos, (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)this::getGraph));
        }
        return null;
    }

    @Override
    @Nullable
    public NodeEntity getNodeEntity(@NotNull NodePos pos) {
        SimpleBlockGraph graph = this.getGraphForNode(pos);
        if (graph != null) {
            return graph.getNodeEntity(pos);
        }
        return null;
    }

    @Override
    public boolean linkExistsAt(@NotNull LinkPos pos) {
        SimpleBlockGraph graph = this.getGraphForNode(pos.first());
        if (graph != null) {
            return graph.linkExistsAt(pos);
        }
        return false;
    }

    @Override
    @Nullable
    public LinkHolder<LinkKey> getLinkAt(@NotNull LinkPos pos) {
        SimpleBlockGraph graph = this.getGraphForNode(pos.first());
        if (graph != null) {
            return graph.getLinkAt(pos);
        }
        return null;
    }

    @Override
    @Nullable
    public LinkEntity getLinkEntity(@NotNull LinkPos pos) {
        SimpleBlockGraph graph = this.getGraphForNode(pos.first());
        if (graph != null) {
            return graph.getLinkEntity(pos);
        }
        return null;
    }

    @Override
    @NotNull
    public LongStream getAllGraphIdsAt(@NotNull class_2338 pos) {
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18682((class_2338)pos));
        if (chunk != null) {
            LongSet graphsInPos = chunk.getGraphsAt(pos);
            if (graphsInPos != null) {
                return graphsInPos.longStream();
            }
            return LongStream.empty();
        }
        return LongStream.empty();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphsAt(@NotNull class_2338 pos) {
        return this.getAllGraphIdsAt(pos).mapToObj(arg_0 -> this.loadedGraphs.get(arg_0)).filter(Objects::nonNull).map(Function.identity());
    }

    @Override
    @NotNull
    public NodeHolder<BlockNode> addBlockNode(@NotNull NodePos pos, @Nullable NodeEntity entity) {
        SimpleBlockGraph existingGraph = this.getGraphForNode(pos);
        if (existingGraph != null) {
            NodeHolder<BlockNode> existingHolder = existingGraph.getNodeAt(pos);
            if (existingHolder != null) {
                if (entity != null) {
                    entity.onDiscard();
                }
                return existingHolder;
            }
            GLLog.warn("Chunk has reference to node {} but the referenced graph does not have that node!", (Object)pos);
            this.logRebuildChunksSuggestion(pos.pos());
        }
        SimpleBlockGraph graph = this.createGraph(true);
        SimpleNodeHolder<BlockNode> node = graph.createNode(pos.pos(), pos.node(), entity, true);
        this.updateConnectionsImpl(node);
        return node;
    }

    @Override
    public boolean removeBlockNode(@NotNull NodePos pos) {
        SimpleBlockGraph graph = this.getGraphForNode(pos);
        if (graph == null) {
            return false;
        }
        NodeHolder<BlockNode> node = graph.getNodeAt(pos);
        if (node == null) {
            return false;
        }
        graph.destroyNode(node, true);
        return true;
    }

    @Override
    @Nullable
    public LinkHolder<LinkKey> connectNodes(@NotNull NodePos a, @NotNull NodePos b, @NotNull LinkKey key, @Nullable LinkEntity entity) {
        SimpleBlockGraphChunk aChunk = this.chunks.getIfExists(class_4076.method_18682((class_2338)a.pos()));
        SimpleBlockGraphChunk bChunk = this.chunks.getIfExists(class_4076.method_18682((class_2338)b.pos()));
        if (aChunk != null && bChunk != null) {
            SimpleBlockGraph aGraph = aChunk.getGraphForNode(a, (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)this::getGraph));
            SimpleBlockGraph bGraph = bChunk.getGraphForNode(b, (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)this::getGraph));
            if (aGraph != null && bGraph != null) {
                SimpleBlockGraph mergedGraph;
                if (aGraph.getId() != bGraph.getId()) {
                    if (aGraph.size() >= bGraph.size()) {
                        aGraph.merge(bGraph);
                        mergedGraph = aGraph;
                    } else {
                        bGraph.merge(aGraph);
                        mergedGraph = bGraph;
                    }
                } else {
                    mergedGraph = aGraph;
                }
                NodeHolder<BlockNode> aHolder = mergedGraph.getNodeAt(a);
                NodeHolder<BlockNode> bHolder = mergedGraph.getNodeAt(b);
                if (aHolder == null) {
                    GLLog.warn("Chunk has reference to node {} but the referenced graph does not have that node!", (Object)a);
                    this.logRebuildChunksSuggestion(a.pos());
                    mergedGraph.split();
                    return null;
                }
                if (bHolder == null) {
                    GLLog.warn("Chunk has reference to node {} but the referenced graph does not have that node!", (Object)b);
                    this.logRebuildChunksSuggestion(b.pos());
                    mergedGraph.split();
                    return null;
                }
                LinkHolder<LinkKey> holder = mergedGraph.link(aHolder, bHolder, key, entity, true);
                ((GraphLibEvents.GraphUpdatedListener)GraphLibEvents.GRAPH_UPDATED.invoker()).graphUpdated(this.world, this, mergedGraph);
                return holder;
            }
        }
        return null;
    }

    @Override
    public boolean disconnectNodes(@NotNull NodePos a, @NotNull NodePos b, @NotNull LinkKey key) {
        SimpleBlockGraph graph;
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18682((class_2338)a.pos()));
        if (chunk != null && (graph = chunk.getGraphForNode(a, (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)this::getGraph))) != null) {
            NodeHolder<BlockNode> aHolder = graph.getNodeAt(a);
            if (aHolder == null) {
                GLLog.warn("Chunk has reference to node {} but the referenced graph does not have that node!", (Object)a);
                this.logRebuildChunksSuggestion(a.pos());
                return false;
            }
            NodeHolder<BlockNode> bHolder = graph.getNodeAt(b);
            if (bHolder == null) {
                return false;
            }
            boolean removed = graph.unlink(aHolder, bHolder, key);
            graph.split();
            return removed;
        }
        return false;
    }

    @Override
    public void updateNodes(@NotNull class_2338 pos) {
        this.nodeUpdates.add((Object)pos.method_10062());
    }

    @Override
    public void updateNodes(@NotNull Iterable<class_2338> poses) {
        for (class_2338 pos : poses) {
            this.updateNodes(pos);
        }
    }

    @Override
    public void updateNodes(@NotNull Stream<class_2338> posStream) {
        posStream.forEach(this::updateNodes);
    }

    @Override
    public void updateConnections(@NotNull class_2338 pos) {
        this.connectionUpdates.add((Object)new UpdateBlockPos(pos.method_10062()));
    }

    @Override
    public void updateConnections(@NotNull SidedPos pos) {
        this.connectionUpdates.add((Object)new UpdateSidedPos(pos));
    }

    @Override
    @Nullable
    public SimpleBlockGraph getGraph(long id) {
        SimpleBlockGraph graph = (SimpleBlockGraph)this.loadedGraphs.get(id);
        if (graph == null && (graph = this.readGraph(id)) != null) {
            this.loadedGraphs.put(id, (Object)graph);
        }
        if (graph != null) {
            LongIterator longIterator = graph.chunks.iterator();
            while (longIterator.hasNext()) {
                long posLong = (Long)longIterator.next();
                this.timer.onChunkUse(class_4076.method_18677((long)posLong));
            }
        }
        return graph;
    }

    @Override
    @NotNull
    public LongStream getAllGraphIdsInChunkSection(@NotNull class_4076 pos) {
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(pos);
        if (chunk != null) {
            return chunk.getGraphs().longStream();
        }
        return LongStream.empty();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphsInChunkSection(@NotNull class_4076 pos) {
        return this.getAllGraphIdsInChunkSection(pos).mapToObj(arg_0 -> this.loadedGraphs.get(arg_0)).filter(Objects::nonNull).map(Function.identity());
    }

    @Override
    @NotNull
    public LongStream getAllGraphIdsInChunk(@NotNull class_1923 pos) {
        return LongStream.range(this.world.method_32891(), this.world.method_31597()).flatMap(y -> this.getAllGraphIdsInChunkSection(class_4076.method_18681((class_1923)pos, (int)((int)y))));
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphsInChunk(@NotNull class_1923 pos) {
        return this.getAllGraphIdsInChunk(pos).mapToObj(arg_0 -> this.loadedGraphs.get(arg_0)).filter(Objects::nonNull).map(Function.identity());
    }

    @Override
    @NotNull
    public LongStream getAllGraphIds() {
        return this.getExistingGraphs().longStream();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphs() {
        return this.loadedGraphs.values().stream().map(Function.identity());
    }

    @Override
    public int removeEmptyGraphs() {
        int removed = 0;
        LongBidirectionalIterator longBidirectionalIterator = this.getExistingGraphs().iterator();
        while (longBidirectionalIterator.hasNext()) {
            long id = (Long)longBidirectionalIterator.next();
            if (this.loadedGraphs.containsKey(id)) {
                SimpleBlockGraph graph = (SimpleBlockGraph)this.loadedGraphs.get(id);
                if (!graph.isEmpty()) continue;
                GLLog.warn("Encountered empty graph! The graph's nodes probably failed to load. Removing graph... Id: {}, chunks: {}", (Object)graph.getId(), graph.chunks.longStream().mapToObj(class_4076::method_18677).toList());
                this.destroyGraphImpl(graph);
                ++removed;
                continue;
            }
            if (this.readGraph(id) != null) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public void rebuildChunks(List<class_4076> toRebuild, RebuildChunksListener listener) {
        if (this.rebuildState == null) {
            LongLinkedOpenHashSet chunksToRebuild = new LongLinkedOpenHashSet();
            for (class_4076 pos : toRebuild) {
                chunksToRebuild.add(pos.method_18694());
                SimpleBlockGraphChunk chunk = this.chunks.getIfExists(pos);
                if (chunk == null) continue;
                chunk.clear();
            }
            LongSortedSet existingGraphs = this.getExistingGraphs();
            if (existingGraphs.isEmpty()) {
                listener.onComplete(0, chunksToRebuild.size());
                return;
            }
            long finalGraph = existingGraphs.lastLong();
            listener.onBegin(existingGraphs.size(), chunksToRebuild.size());
            long lastGraph = this.rebuildSomeGraphs(existingGraphs, (LongSet)chunksToRebuild);
            if (lastGraph == finalGraph) {
                listener.onComplete(existingGraphs.size(), chunksToRebuild.size());
            } else {
                this.rebuildState = new ChunkRebuildState((LongSet)chunksToRebuild, listener, finalGraph, lastGraph + 1L, existingGraphs.size());
            }
        } else {
            double progress = (double)this.rebuildState.nextGraph / (double)this.rebuildState.finalGraph;
            this.rebuildState.listener.onAlreadyRunning(progress, this.rebuildState.approximateGraphCount, this.rebuildState.toRebuild.size());
        }
    }

    @Override
    public void markDirty(long graphId) {
        this.unsavedGraphs.add(graphId);
    }

    @Override
    @NotNull
    public SimpleBlockGraph createGraph(boolean initializeGraphEntities) {
        SimpleBlockGraph graph = new SimpleBlockGraph((SimpleGraphCollection)this, this.getNextGraphId(), initializeGraphEntities);
        this.loadedGraphs.put(graph.getId(), (Object)graph);
        ((GraphLibEvents.GraphCreatedListener)GraphLibEvents.GRAPH_CREATED.invoker()).graphCreated(this.world, this, graph);
        return graph;
    }

    @Override
    public void destroyGraph(long id) {
        SimpleBlockGraph graph = this.getGraph(id);
        if (graph == null) {
            GLLog.warn("Attempted to destroy graph that does not exist. Id: {}", (Object)id);
            return;
        }
        this.destroyGraphImpl(graph);
        ((GraphLibEvents.GraphDestroyedListener)GraphLibEvents.GRAPH_DESTROYED.invoker()).graphDestroyed(this.world, this, id);
    }

    @Override
    public void putGraphWithNode(long id, @NotNull NodePos pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos.pos());
        SimpleBlockGraphChunk chunk = this.chunks.getOrCreate(sectionPos);
        chunk.putGraphWithNode(id, pos, (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)this::getGraph));
        this.timer.onChunkUse(sectionPos);
    }

    @Override
    public void removeGraphWithNode(long id, @NotNull NodePos pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos.pos());
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(sectionPos);
        if (chunk != null) {
            chunk.removeGraphWithNodeUnchecked(pos);
        } else {
            GLLog.warn("Tried to remove node from non-existent chunk. Id: {}, chunk: {}, node: {}", id, sectionPos, pos);
        }
    }

    @Override
    public void removeGraphInPos(long id, @NotNull class_2338 pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(sectionPos);
        if (chunk != null) {
            chunk.removeGraphInPosUnchecked(id, pos);
        } else {
            GLLog.warn("Tried to remove graph from non-existent chunk. Id: {}, chunk: {}, block: {}", id, sectionPos, pos);
        }
    }

    @Override
    public void removeGraphInChunk(long id, long pos) {
        class_4076 sectionPos = class_4076.method_18677((long)pos);
        SimpleBlockGraphChunk chunk = this.chunks.getIfExists(sectionPos);
        if (chunk != null) {
            chunk.removeGraphUnchecked(id);
        } else {
            GLLog.warn("Tried to remove graph fom non-existent chunk. Id: {}, chunk: {}", (Object)id, (Object)sectionPos);
        }
    }

    @Override
    public void removeGraphInPoses(long id, @NotNull Iterable<NodePos> nodes, @NotNull Iterable<class_2338> poses, @NotNull LongIterable chunkPoses) {
        for (NodePos node : nodes) {
            this.removeGraphWithNode(id, node);
        }
        for (class_2338 pos : poses) {
            this.removeGraphInPos(id, pos);
        }
        LongIterator longIterator = chunkPoses.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            this.removeGraphInChunk(id, pos);
        }
    }

    @Override
    public void graphUpdated(SimpleBlockGraph graph) {
        ((GraphLibEvents.GraphUpdatedListener)GraphLibEvents.GRAPH_UPDATED.invoker()).graphUpdated(this.world, this, graph);
    }

    @Override
    public void sendNodeAdd(BlockGraph graph, NodeHolder<BlockNode> node) {
        GLNet.sendNodeAdd(graph, node);
    }

    @Override
    public void sendMerge(BlockGraph from, BlockGraph into) {
        GLNet.sendMerge(from, into);
    }

    @Override
    public void sendLink(BlockGraph graph, LinkHolder<LinkKey> link) {
        GLNet.sendLink(graph, link);
    }

    @Override
    public void sendUnlink(BlockGraph graph, NodeHolder<BlockNode> a, NodeHolder<BlockNode> b, LinkKey key) {
        GLNet.sendUnlink(graph, a, b, key);
    }

    @Override
    public void sendSplitInto(BlockGraph from, BlockGraph into) {
        GLNet.sendSplitInto(from, into);
    }

    @Override
    public void sendNodeRemove(BlockGraph graph, NodeHolder<BlockNode> holder) {
        GLNet.sendNodeRemove(graph, holder);
    }

    private void handleNodeUpdates() {
        for (class_2338 pos : this.nodeUpdates) {
            Set<BlockNode> nodes = this.universe.discoverNodesInBlock(this.world, pos);
            this.onNodesChanged(pos, nodes);
        }
        this.nodeUpdates.clear();
    }

    private void handleConnectionUpdates() {
        for (UpdatePos pos : this.connectionUpdates) {
            if (pos instanceof UpdateBlockPos) {
                UpdateBlockPos blockPos = (UpdateBlockPos)pos;
                for (NodeHolder<BlockNode> node : this.getNodesAt(blockPos.pos).toList()) {
                    this.updateConnectionsImpl(node);
                }
                continue;
            }
            if (!(pos instanceof UpdateSidedPos)) continue;
            UpdateSidedPos sidedPos = (UpdateSidedPos)pos;
            for (NodeHolder<BlockNode> node : this.getNodesAt(sidedPos.pos).toList()) {
                this.updateConnectionsImpl(node.cast(BlockNode.class));
            }
        }
        this.connectionUpdates.clear();
    }

    @Override
    public void scheduleCallbackUpdate(@NotNull NodeHolder<BlockNode> node, boolean validate) {
        if (node == null) {
            GLLog.error("Something tried to schedule an update for a NULL node! This should NEVER happen.", new RuntimeException("Stack Trace"));
            return;
        }
        NodePos key = node.getPos();
        if (!this.callbackUpdates.containsKey(key) || !validate) {
            this.callbackUpdates.put(key, new CallbackUpdate(node, validate));
        }
    }

    private void handleCallbackUpdates() {
        ArrayList<NodeHolder<BlockNode>> toRemove = new ArrayList<NodeHolder<BlockNode>>();
        for (CallbackUpdate callbackUpdate : this.callbackUpdates.values()) {
            NodeHolder<BlockNode> node = callbackUpdate.holder();
            node.getNode().onConnectionsChanged(node);
            if (!callbackUpdate.validate() || node.getNode().isValid(node)) continue;
            toRemove.add(node);
        }
        this.callbackUpdates.clear();
        for (NodeHolder nodeHolder : toRemove) {
            SimpleBlockGraph graph = this.getGraph(nodeHolder.getGraphId());
            if (graph == null) continue;
            graph.destroyNode(nodeHolder, true);
        }
    }

    private void onNodesChanged(@NotNull class_2338 pos, @NotNull Set<BlockNode> nodes) {
        LinkedHashSet<BlockNode> newNodes = new LinkedHashSet<BlockNode>(nodes);
        LinkedHashSet distinctNodes = new LinkedHashSet();
        ArrayList nodesPresent = new ArrayList();
        PrimitiveIterator.OfLong graphIdIter = this.getAllGraphIdsAt(pos).iterator();
        while (graphIdIter.hasNext()) {
            long graphId = graphIdIter.nextLong();
            SimpleBlockGraph graph = this.getGraph(graphId);
            if (graph == null) {
                GLLog.warn("Encountered invalid graph in position when detecting node changes. Id: {}, pos: {}", (Object)graphId, (Object)pos);
                this.logRebuildChunksSuggestion(pos);
                continue;
            }
            graph.getNodesAt(pos).forEach(nodesPresent::add);
        }
        for (NodeHolder node : nodesPresent) {
            SimpleBlockGraph graph = this.getGraph(node.getGraphId());
            if (graph == null) {
                GLLog.warn("Encountered node {} associated with graph id {} that does not exist!", (Object)node.getPos(), (Object)node.getGraphId());
                continue;
            }
            Object bn = node.getNode();
            if (bn.isAutomaticRemoval(node) && !nodes.contains(bn)) {
                graph.destroyNode(node, true);
            } else if (distinctNodes.contains(bn)) {
                GLLog.warn("Duplicate nodes {} found at {}. Removing...", bn, (Object)pos);
                graph.destroyNode(node, true);
            }
            newNodes.remove(bn);
            distinctNodes.add(bn);
        }
        for (BlockNode bn : newNodes) {
            if (bn == null) {
                GLLog.warn("Something tried to add a null BlockNode! Ignoring... Pos: {}", (Object)pos, (Object)new RuntimeException("Stack Trace"));
                continue;
            }
            SimpleBlockGraph newGraph = this.createGraph(true);
            SimpleNodeHolder<BlockNode> node = newGraph.createNode(pos, bn, null, true);
            this.updateConnectionsImpl(node);
        }
    }

    private void updateConnectionsImpl(@NotNull NodeHolder<BlockNode> node) {
        NodePos nodePos = node.getPos();
        long nodeGraphId = node.getGraphId();
        SimpleBlockGraph graph = this.getGraph(nodeGraphId);
        if (graph == null) {
            GLLog.warn("Tried to update node with invalid graph id. Node: {}", node);
            return;
        }
        Object2ObjectLinkedOpenHashMap oldConnections = new Object2ObjectLinkedOpenHashMap();
        for (LinkHolder<LinkKey> linkHolder : node.getConnections()) {
            oldConnections.put(linkHolder.getPos(), linkHolder);
        }
        Object2ObjectLinkedOpenHashMap wantedConnections = new Object2ObjectLinkedOpenHashMap();
        for (HalfLink halfLink : node.getNode().findConnections(node)) {
            NodeHolder<BlockNode> nodeHolder = halfLink.other();
            if (!nodeHolder.getNode().canConnect(nodeHolder, halfLink.reverse(node))) continue;
            wantedConnections.put(halfLink.toLinkPos(nodePos), halfLink);
        }
        ObjectArrayList objectArrayList = new ObjectArrayList();
        for (Map.Entry entry : wantedConnections.entrySet()) {
            HalfLink halfLink = (HalfLink)entry.getValue();
            if (halfLink.other().getGraphId() == nodeGraphId && oldConnections.containsKey(entry.getKey())) continue;
            objectArrayList.add(halfLink);
        }
        ObjectArrayList objectArrayList2 = new ObjectArrayList();
        for (Map.Entry entry : oldConnections.entrySet()) {
            LinkPos old = (LinkPos)entry.getKey();
            LinkHolder link = (LinkHolder)entry.getValue();
            if (link.getKey().isAutomaticRemoval(link)) {
                if (wantedConnections.containsKey(old)) continue;
                objectArrayList2.add(link);
                continue;
            }
            if (this.nodeExistsAt(old.other(nodePos))) continue;
            objectArrayList2.add(link);
        }
        long l = nodeGraphId;
        SimpleBlockGraph mergedGraph = graph;
        for (Object link : objectArrayList) {
            long otherGraphId = ((HalfLink)link).other().getGraphId();
            if (otherGraphId != l) {
                SimpleBlockGraph otherGraph = this.getGraph(otherGraphId);
                if (otherGraph == null) {
                    GLLog.warn("Tried to connect to node with invalid graph id. Half-link: {}", link);
                    continue;
                }
                if (otherGraph.size() > mergedGraph.size()) {
                    otherGraph.merge(mergedGraph);
                    mergedGraph = otherGraph;
                    l = otherGraphId;
                } else {
                    mergedGraph.merge(otherGraph);
                }
            }
            mergedGraph.link(node, ((HalfLink)link).other(), ((HalfLink)link).key(), null, true);
        }
        for (Object link : objectArrayList2) {
            mergedGraph.unlink(link.getFirst(), link.getSecond(), (LinkKey)link.getKey());
        }
        if (!objectArrayList2.isEmpty()) {
            mergedGraph.split();
        } else {
            ((GraphLibEvents.GraphUpdatedListener)GraphLibEvents.GRAPH_UPDATED.invoker()).graphUpdated(this.world, this, mergedGraph);
        }
    }

    private void continueRebuildingChunks() {
        if (this.rebuildState != null) {
            LongSortedSet existingGraphs = this.getExistingGraphs();
            this.rebuildState.approximateGraphCount = existingGraphs.size();
            this.rebuildState.finalGraph = existingGraphs.lastLong();
            LongSortedSet nextGraphs = existingGraphs.tailSet(this.rebuildState.nextGraph);
            if (nextGraphs.isEmpty()) {
                this.rebuildState.listener.onComplete(existingGraphs.size(), this.rebuildState.toRebuild.size());
                this.rebuildState = null;
                return;
            }
            long lastGraph = this.rebuildSomeGraphs(nextGraphs, this.rebuildState.toRebuild);
            if (lastGraph == nextGraphs.lastLong()) {
                this.rebuildState.listener.onComplete(existingGraphs.size(), this.rebuildState.toRebuild.size());
                this.rebuildState = null;
            } else {
                this.rebuildState.nextGraph = lastGraph + 1L;
                if (++this.rebuildState.ticksSinceLastProgressReport >= 20) {
                    double progress = (double)lastGraph / (double)this.rebuildState.finalGraph;
                    this.rebuildState.listener.onProgress(progress, this.rebuildState.approximateGraphCount, this.rebuildState.toRebuild.size());
                }
            }
        }
    }

    private long rebuildSomeGraphs(LongSortedSet graphIds, LongSet chunks) {
        LongBidirectionalIterator iter = graphIds.iterator();
        long rebuild = graphIds.firstLong();
        for (int rebuiltCount = 0; rebuiltCount < 100 && iter.hasNext(); ++rebuiltCount) {
            rebuild = iter.nextLong();
            this.reAddGraphToChunks(rebuild, chunks);
        }
        return rebuild;
    }

    private void reAddGraphToChunks(long graphId, LongSet chunkPoses) {
        SimpleBlockGraph graph = (SimpleBlockGraph)this.loadedGraphs.get(graphId);
        if (graph == null) {
            graph = this.readGraph(graphId);
        }
        if (graph == null) {
            return;
        }
        Iterator holderIterator = graph.getNodes().iterator();
        while (holderIterator.hasNext()) {
            NodeHolder holder = (NodeHolder)holderIterator.next();
            class_4076 sectionPos = class_4076.method_18682((class_2338)holder.getBlockPos());
            if (!chunkPoses.contains(sectionPos.method_18694())) continue;
            SimpleBlockGraphChunk chunk = this.chunks.getOrCreate(sectionPos);
            chunk.putGraphWithNode(graphId, holder.getPos(), (Long2ObjectFunction<SimpleBlockGraph>)((Long2ObjectFunction)id -> {
                throw new AssertionError((Object)("This chunk (" + sectionPos + ") should already have had its node->graph map initialized and should not need to rebuild it. This is a bug."));
            }));
        }
    }

    private void tickGraphs() {
        for (SimpleBlockGraph graph : this.loadedGraphs.values()) {
            graph.onTick();
        }
    }

    private void loadGraphs(@NotNull class_1923 pos) {
        for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
            SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18676((int)pos.field_9181, (int)y, (int)pos.field_9180));
            if (chunk == null) continue;
            LongIterator longIterator = chunk.getGraphs().iterator();
            while (longIterator.hasNext()) {
                long id = (Long)longIterator.next();
                this.getGraph(id);
            }
        }
    }

    private void saveGraphs(@NotNull class_1923 pos) {
        LongOpenHashSet chunkSectionPillar = new LongOpenHashSet(this.world.method_31597() - this.world.method_32891());
        for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
            chunkSectionPillar.add(class_4076.method_18685((int)pos.field_9181, (int)y, (int)pos.field_9180));
        }
        block1: for (SimpleBlockGraph loadedGraph : this.loadedGraphs.values()) {
            LongIterator longIterator = loadedGraph.chunks.iterator();
            while (longIterator.hasNext()) {
                long graphChunk = (Long)longIterator.next();
                if (!chunkSectionPillar.contains(graphChunk)) continue;
                this.writeGraph(loadedGraph);
                this.unsavedGraphs.remove(loadedGraph.getId());
                continue block1;
            }
        }
    }

    private void unloadGraphs() {
        List<class_4076> chunksToUnload = this.timer.chunksToUnload();
        for (class_4076 chunk : chunksToUnload) {
            this.timer.onChunkUnload(chunk);
        }
        if (!chunksToUnload.isEmpty()) {
            LongLinkedOpenHashSet toUnload = new LongLinkedOpenHashSet();
            for (SimpleBlockGraph graph : this.loadedGraphs.values()) {
                if (!graph.chunks.longStream().mapToObj(class_4076::method_18677).noneMatch(this.timer::isChunkLoaded)) continue;
                toUnload.add(graph.getId());
            }
            ObjectIterator objectIterator = toUnload.iterator();
            while (objectIterator.hasNext()) {
                long id = (Long)objectIterator.next();
                SimpleBlockGraph graph = (SimpleBlockGraph)this.loadedGraphs.remove(id);
                ((GraphLibEvents.GraphUnloadingListener)GraphLibEvents.GRAPH_UNLOADING.invoker()).graphUnloading(this.world, this, graph);
                graph.onUnload();
                this.writeGraph(graph);
                this.unsavedGraphs.remove(id);
            }
        }
    }

    private void saveUnsvedGraphs() {
        if (this.unsavedGraphs.isEmpty() || this.saveMode != SaveMode.INCREMENTAL && this.saveMode != SaveMode.IMMEDIATE) {
            return;
        }
        int saveCount = this.saveMode == SaveMode.IMMEDIATE ? this.unsavedGraphs.size() : (this.unsavedGraphs.size() + 10 - 1) / 10;
        LongIterator iter = this.unsavedGraphs.longIterator();
        while (iter.hasNext() && saveCount > 0) {
            SimpleBlockGraph graph = (SimpleBlockGraph)this.loadedGraphs.get(iter.nextLong());
            if (graph != null) {
                this.writeGraph(graph);
                --saveCount;
            }
            iter.remove();
        }
    }

    private void saveAllGraphs() {
        for (SimpleBlockGraph graph : this.loadedGraphs.values()) {
            this.writeGraph(graph);
        }
        this.unsavedGraphs.clear();
    }

    private long getNextGraphId() {
        do {
            ++this.prevGraphId;
        } while (this.graphExists(this.prevGraphId));
        this.markStateDirty();
        return this.prevGraphId;
    }

    private boolean graphExists(long id) {
        return this.loadedGraphs.containsKey(id) || Files.exists(this.getGraphFile(id), new LinkOption[0]);
    }

    @NotNull
    private Path getGraphFile(long id) {
        return this.graphsDir.resolve(String.format("%016X.dat", id));
    }

    @NotNull
    private LongSortedSet getExistingGraphs() {
        LongRBTreeSet ids = new LongRBTreeSet(Long::compareUnsigned);
        ids.addAll((LongCollection)this.loadedGraphs.keySet());
        try (Stream<Path> children = Files.list(this.graphsDir);){
            children.forEach(arg_0 -> SimpleServerGraphWorld.lambda$getExistingGraphs$5((LongSortedSet)ids, arg_0));
        }
        catch (IOException e) {
            GLLog.error("Error listing children of {}", (Object)this.graphsDir, (Object)e);
        }
        return ids;
    }

    private void writeGraph(@NotNull SimpleBlockGraph graph) {
        Path graphFile = this.getGraphFile(graph.getId());
        class_2487 root = new class_2487();
        root.method_10566("data", (class_2520)graph.toTag());
        try (OutputStream os = Files.newOutputStream(graphFile, new OpenOption[0]);){
            class_2507.method_10634((class_2487)root, (OutputStream)os);
        }
        catch (IOException e) {
            GLLog.error("Unable to save graph {}.", (Object)graph.getId(), (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private SimpleBlockGraph readGraph(long id) {
        Path graphFile = this.getGraphFile(id);
        if (!Files.exists(graphFile, new LinkOption[0])) {
            return null;
        }
        try (InputStream is = Files.newInputStream(graphFile, new OpenOption[0]);){
            class_2487 root = class_2507.method_10629((InputStream)is);
            class_2487 data = root.method_10562("data");
            SimpleBlockGraph graph = SimpleBlockGraph.fromTag(this, id, data);
            if (graph.isEmpty()) {
                GLLog.warn("Loaded empty graph! The graph's nodes probably failed to load. Removing graph... Id: {}, chunks: {}", (Object)graph.getId(), graph.chunks.longStream().mapToObj(class_4076::method_18677).toList());
                this.destroyGraphImpl(graph);
                SimpleBlockGraph simpleBlockGraph2 = null;
                return simpleBlockGraph2;
            }
            SimpleBlockGraph simpleBlockGraph = graph;
            return simpleBlockGraph;
        }
        catch (IOException e) {
            GLLog.error("Unable to load graph {}. Removing graph...", (Object)id, (Object)e);
            if (!Files.exists(graphFile, new LinkOption[0])) return null;
            try {
                Files.delete(graphFile);
                return null;
            }
            catch (IOException ex) {
                GLLog.error("Error deleting broken graph file: {}", (Object)graphFile, (Object)ex);
            }
            return null;
        }
    }

    private void destroyGraphImpl(SimpleBlockGraph graph) {
        long id = graph.getId();
        this.loadedGraphs.remove(id);
        this.unsavedGraphs.remove(id);
        try {
            Files.deleteIfExists(this.getGraphFile(id));
        }
        catch (IOException e) {
            GLLog.error("Error removing graph file. Id: {}", (Object)id, (Object)e);
        }
        LongIterator longIterator = graph.chunks.iterator();
        while (longIterator.hasNext()) {
            long sectionPos = (Long)longIterator.next();
            SimpleBlockGraphChunk chunk = this.chunks.getIfExists(class_4076.method_18677((long)sectionPos));
            if (chunk != null) {
                chunk.removeGraph(id);
                continue;
            }
            GLLog.warn("Attempted to destroy graph in chunk that does not exist. Id: {}, chunk: {}", (Object)id, (Object)class_4076.method_18677((long)sectionPos));
        }
        graph.onDestroy();
    }

    private void markStateDirty() {
        this.stateDirty = true;
    }

    private void loadState() {
        if (Files.exists(this.stateFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(this.stateFile, new OpenOption[0]);){
                class_2487 root = class_2507.method_10629((InputStream)is);
                class_2487 data = root.method_10562("data");
                this.prevGraphId = data.method_10537("prevGraphId");
            }
            catch (Exception e) {
                GLLog.error("Error loading graph controller state file.", e);
            }
        }
    }

    private void saveState() {
        if (this.stateDirty) {
            class_2487 root = new class_2487();
            class_2487 data = new class_2487();
            data.method_10544("prevGraphId", this.prevGraphId);
            root.method_10566("data", (class_2520)data);
            if (!Files.exists(this.stateFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.stateFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    GLLog.error("Error creating graph controller state save directory.", e);
                }
            }
            try (OutputStream os = Files.newOutputStream(this.stateFile, new OpenOption[0]);){
                class_2507.method_10634((class_2487)root, (OutputStream)os);
            }
            catch (IOException e) {
                GLLog.error("Error saving graph controller state.", e);
                return;
            }
            this.stateDirty = false;
        }
    }

    private void logRebuildChunksSuggestion(class_2338 affected) {
        GLLog.info("Use the command '/graphlib {} rebuildchunks {} {} {} {} {} {}' in the {} dimension to fix the issue.", this.universe.getId(), affected.method_10263(), affected.method_10264(), affected.method_10260(), affected.method_10263(), affected.method_10264(), affected.method_10260(), this.world.method_27983().method_29177());
    }

    private static /* synthetic */ void lambda$getExistingGraphs$5(LongSortedSet ids, Path child) {
        String filename = child.getFileName().toString();
        Matcher matcher = GRAPH_ID_PATTERN.matcher(filename);
        if (matcher.matches()) {
            try {
                long id = Long.parseLong(matcher.group("id"), 16);
                ids.add(id);
            }
            catch (NumberFormatException e) {
                GLLog.warn("Encountered NumberFormatException while parsing graph id from filename: {}", (Object)filename, (Object)e);
            }
        } else {
            GLLog.warn("Encountered non-graph file in graphs dir: {}", (Object)child);
        }
    }

    private static class ChunkRebuildState {
        final LongSet toRebuild;
        final RebuildChunksListener listener;
        long finalGraph;
        long nextGraph;
        int approximateGraphCount;
        int ticksSinceLastProgressReport = 0;

        ChunkRebuildState(LongSet toRebuild, RebuildChunksListener listener, long finalGraph, long nextGraph, int approximateGraphCount) {
            this.toRebuild = toRebuild;
            this.listener = listener;
            this.finalGraph = finalGraph;
            this.nextGraph = nextGraph;
            this.approximateGraphCount = approximateGraphCount;
        }
    }

    private record UpdateBlockPos(class_2338 pos) implements UpdatePos
    {
    }

    private record UpdateSidedPos(SidedPos pos) implements UpdatePos
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface UpdatePos {
    }

    private record CallbackUpdate(NodeHolder<BlockNode> holder, boolean validate) {
    }
}

