/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.BlockNodeType;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.graph.GraphUniverseImpl;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleNodeWrapper {
    @NotNull
    final class_2338 pos;
    @NotNull
    final BlockNode node;
    long graphId;

    public SimpleNodeWrapper(@NotNull class_2338 pos, @NotNull BlockNode node, long graphId) {
        this.pos = pos.method_10062();
        this.node = node;
        this.graphId = graphId;
    }

    @NotNull
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("x", this.pos.method_10263());
        tag.method_10569("y", this.pos.method_10264());
        tag.method_10569("z", this.pos.method_10260());
        class_2520 nodeTag = this.node.toTag();
        if (nodeTag != null) {
            tag.method_10566("node", nodeTag);
        }
        tag.method_10582("type", this.node.getType().getId().toString());
        return tag;
    }

    @Nullable
    public static SimpleNodeWrapper fromTag(@NotNull GraphUniverseImpl universe, @NotNull class_2487 tag, long graphId) {
        class_2338 pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
        class_2960 typeId = new class_2960(tag.method_10558("type"));
        BlockNodeType type = universe.getNodeType(typeId);
        if (type == null) {
            GLLog.warn("Tried to load unknown BlockNode type: {} @ {}", (Object)typeId, (Object)pos);
            return null;
        }
        class_2520 nodeTag = tag.method_10580("node");
        BlockNode node = type.getDecoder().decode(nodeTag);
        if (node == null) {
            GLLog.warn("Unable to decode BlockNode with type: {} @ {}", (Object)typeId, (Object)pos);
            return null;
        }
        return new SimpleNodeWrapper(pos, node, graphId);
    }

    @NotNull
    public class_2338 getPos() {
        return this.pos;
    }

    @NotNull
    public BlockNode getNode() {
        return this.node;
    }

    public long getGraphId() {
        return this.graphId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SimpleNodeWrapper that = (SimpleNodeWrapper)obj;
        return Objects.equals(this.pos, that.pos) && Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.node);
    }

    public String toString() {
        return "BlockNodeWrapper[pos=" + this.pos + ", graphId=" + this.graphId + ", node=" + this.node + "]";
    }
}

