/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.SnapshotNode;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.api.util.graph.Link;
import com.kneelawk.graphlib.api.util.graph.Node;
import com.kneelawk.graphlib.impl.graph.simple.SimpleLinkHolder;
import com.kneelawk.graphlib.impl.graph.simple.SimpleNodeWrapper;
import com.kneelawk.graphlib.impl.util.ReadOnlyMappingCollection;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

public class SimpleNodeHolder<T extends BlockNode>
implements NodeHolder<T> {
    final class_1937 blockWorld;
    final GraphView graphWorld;
    public final Node<SimpleNodeWrapper, LinkKey> node;

    public SimpleNodeHolder(class_1937 blockWorld, GraphView graphWorld, Node<SimpleNodeWrapper, LinkKey> node) {
        this.blockWorld = blockWorld;
        this.graphWorld = graphWorld;
        this.node = node;
    }

    @Override
    @NotNull
    public class_2338 getBlockPos() {
        return this.node.data().getPos();
    }

    @Override
    @NotNull
    public T getNode() {
        return (T)this.node.data().getNode();
    }

    @Override
    public long getGraphId() {
        return this.node.data().getGraphId();
    }

    @Override
    public class_1937 getBlockWorld() {
        return this.blockWorld;
    }

    @Override
    public GraphView getGraphWorld() {
        return this.graphWorld;
    }

    @Override
    @NotNull
    public Collection<LinkHolder<LinkKey>> getConnections() {
        return new ReadOnlyMappingCollection<Link, LinkHolder>(this.node.connections(), link -> new SimpleLinkHolder(this.blockWorld, this.graphWorld, link));
    }

    @Override
    @NotNull
    public <K extends LinkKey> Stream<LinkHolder<K>> getConnectionsOfType(Class<K> keyClass) {
        return this.node.connections().stream().filter(link -> keyClass.isInstance(link.key())).map(link -> new SimpleLinkHolder(this.blockWorld, this.graphWorld, link));
    }

    @Override
    @NotNull
    public <K extends LinkKey> Stream<LinkHolder<K>> getConnectionsThatMatch(Class<K> keyClass, Predicate<K> filter) {
        return this.node.connections().stream().filter(link -> keyClass.isInstance(link.key()) && filter.test((LinkKey)keyClass.cast(link.key()))).map(link -> new SimpleLinkHolder(this.blockWorld, this.graphWorld, link));
    }

    @Override
    @NotNull
    public SnapshotNode<T> toSnapshot() {
        return new SnapshotNode<BlockNode>(this.node.data().getPos(), this.node.data().getNode(), this.node.data().getGraphId());
    }

    @Override
    @NotNull
    public NodePos getPos() {
        return new NodePos(this.node.data().getPos(), this.node.data().getNode());
    }

    @Override
    public boolean canCast(Class<?> newType) {
        return newType.isInstance(this.node.data().getNode());
    }

    @Override
    public <R extends BlockNode> NodeHolder<R> cast(Class<R> newType) throws ClassCastException {
        if (!this.canCast(newType)) {
            throw new ClassCastException(this.node.data().getNode().getClass() + " cannot be cast to " + newType);
        }
        return new SimpleNodeHolder<T>(this.blockWorld, this.graphWorld, this.node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleNodeHolder that = (SimpleNodeHolder)o;
        return Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }

    public String toString() {
        return "SimpleNodeHolder{node=" + this.node + "}";
    }
}

