/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.BlockNodeDiscoverer;
import com.kneelawk.graphlib.api.graph.user.BlockNodeType;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkKeyType;
import com.kneelawk.graphlib.api.graph.user.NodeEntityType;
import com.kneelawk.graphlib.api.graph.user.SyncProfile;
import com.kneelawk.graphlib.api.util.CacheCategory;
import com.kneelawk.graphlib.api.util.ColorUtils;
import com.kneelawk.graphlib.api.util.EmptyLinkKey;
import com.kneelawk.graphlib.api.world.SaveMode;
import com.kneelawk.graphlib.impl.CommonProxy;
import com.kneelawk.graphlib.impl.GraphLibImpl;
import com.kneelawk.graphlib.impl.graph.ClientGraphWorldImpl;
import com.kneelawk.graphlib.impl.graph.ClientGraphWorldStorage;
import com.kneelawk.graphlib.impl.graph.GraphUniverseImpl;
import com.kneelawk.graphlib.impl.graph.GraphWorldStorage;
import com.kneelawk.graphlib.impl.graph.ServerGraphWorldImpl;
import com.kneelawk.graphlib.impl.graph.simple.SimpleClientGraphWorld;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphUniverseBuilder;
import com.kneelawk.graphlib.impl.graph.simple.SimpleServerGraphWorld;
import com.kneelawk.graphlib.impl.mixin.api.StorageHelper;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphUniverse
implements GraphUniverse,
GraphUniverseImpl {
    private final class_2960 id;
    private final List<BlockNodeDiscoverer> discoverers = new ArrayList<BlockNodeDiscoverer>();
    private final Map<class_2960, BlockNodeType> nodeTypes = new LinkedHashMap<class_2960, BlockNodeType>();
    private final Object2IntMap<class_2960> typeIndices = new Object2IntLinkedOpenHashMap();
    private final Map<class_2960, NodeEntityType> nodeEntityTypes = new LinkedHashMap<class_2960, NodeEntityType>();
    private final Map<class_2960, LinkKeyType> linkKeyTypes = new LinkedHashMap<class_2960, LinkKeyType>();
    private final Map<class_2960, LinkEntityType> linkEntityTypes = new LinkedHashMap<class_2960, LinkEntityType>();
    private final Map<class_2960, GraphEntityType<?>> graphEntityTypes = new LinkedHashMap();
    private final Set<CacheCategory<?>> cacheCategories = new ObjectLinkedOpenHashSet();
    final SaveMode saveMode;
    final SyncProfile syncProfile;

    public SimpleGraphUniverse(class_2960 universeId, SimpleGraphUniverseBuilder builder) {
        this.id = universeId;
        this.saveMode = builder.saveMode;
        this.syncProfile = builder.profile;
        this.addLinkKeyType(EmptyLinkKey.TYPE);
        if (this.syncProfile.getNodeFilter() != null) {
            this.addCacheCategory(this.syncProfile.getNodeFilter());
        }
    }

    @Override
    @Deprecated
    @NotNull
    public GraphView getGraphView(@NotNull class_1937 world) {
        return CommonProxy.INSTANCE.getStorage(world).get(this.id);
    }

    @Override
    @Nullable
    public GraphView getSidedGraphView(@NotNull class_1937 world) {
        GraphWorldStorage storage = CommonProxy.INSTANCE.getSidedStorage(world);
        if (storage == null) {
            return null;
        }
        return storage.get(this.id);
    }

    @Override
    @NotNull
    public ServerGraphWorldImpl getServerGraphWorld(@NotNull class_3218 world) {
        return StorageHelper.getStorage(world).get(this.id);
    }

    @Override
    @Nullable
    public ClientGraphWorldImpl getClientGraphView() {
        ClientGraphWorldStorage storage = CommonProxy.INSTANCE.getClientStorage();
        if (storage == null) {
            return null;
        }
        return storage.get(this.id);
    }

    @Override
    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    @Override
    @NotNull
    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    @Override
    public void addDiscoverer(@NotNull BlockNodeDiscoverer discoverer) {
        this.discoverers.add(discoverer);
    }

    @Override
    public void addDiscoverers(BlockNodeDiscoverer ... discoverers) {
        this.discoverers.addAll(Arrays.asList(discoverers));
    }

    @Override
    public void addDiscoverers(@NotNull Iterable<BlockNodeDiscoverer> discoverers) {
        for (BlockNodeDiscoverer discoverer : discoverers) {
            this.discoverers.add(discoverer);
        }
    }

    @Override
    public void addDiscoverers(@NotNull Collection<BlockNodeDiscoverer> discoverers) {
        this.discoverers.addAll(discoverers);
    }

    @Override
    public void addNodeType(@NotNull BlockNodeType type) {
        this.nodeTypes.put(type.getId(), type);
        this.typeIndices.put((Object)type.getId(), this.typeIndices.size());
    }

    @Override
    public void addNodeEntityType(@NotNull NodeEntityType type) {
        this.nodeEntityTypes.put(type.getId(), type);
    }

    @Override
    public void addLinkKeyType(@NotNull LinkKeyType type) {
        this.linkKeyTypes.put(type.getId(), type);
    }

    @Override
    public void addLinkEntityType(@NotNull LinkEntityType type) {
        this.linkEntityTypes.put(type.getId(), type);
    }

    @Override
    public void addGraphEntityType(@NotNull GraphEntityType<?> type) {
        this.graphEntityTypes.put(type.getId(), type);
    }

    @Override
    public void addCacheCategory(@NotNull CacheCategory<?> category) {
        this.cacheCategories.add(category);
    }

    @Override
    @NotNull
    public Iterable<CacheCategory<?>> getCacheCatetories() {
        return this.cacheCategories;
    }

    @Override
    public void register() {
        GraphLibImpl.register(this);
    }

    @Override
    public int getDefaultDebugColor(@NotNull class_2960 typeId) {
        return ColorUtils.hsba2Argb((float)this.typeIndices.getInt((Object)typeId) / (float)this.typeIndices.size(), 1.0f, 1.0f, 1.0f);
    }

    @Override
    @NotNull
    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    @Override
    public ServerGraphWorldImpl createGraphWorld(class_3218 world, Path path, boolean syncChunkWrites) {
        return new SimpleServerGraphWorld(this, world, path, syncChunkWrites);
    }

    @Override
    public ClientGraphWorldImpl createClientGraphWorld(class_1937 world, int loadDistance) {
        return new SimpleClientGraphWorld(this, world, loadDistance);
    }

    @Override
    @NotNull
    public Set<BlockNode> discoverNodesInBlock(@NotNull class_3218 world, @NotNull class_2338 pos) {
        return this.discoverers.stream().flatMap(discoverer -> discoverer.getNodesInBlock(world, pos).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    @Nullable
    public BlockNodeType getNodeType(@NotNull class_2960 typeId) {
        return this.nodeTypes.get(typeId);
    }

    @Override
    @Nullable
    public NodeEntityType getNodeEntityType(@NotNull class_2960 typeId) {
        return this.nodeEntityTypes.get(typeId);
    }

    @Override
    @Nullable
    public LinkKeyType getLinkKeyType(@NotNull class_2960 typeId) {
        return this.linkKeyTypes.get(typeId);
    }

    @Override
    @Nullable
    public LinkEntityType getLinkEntityType(@NotNull class_2960 typeId) {
        return this.linkEntityTypes.get(typeId);
    }

    @Override
    @Nullable
    public GraphEntityType<?> getGraphEntityType(@NotNull class_2960 typeId) {
        return this.graphEntityTypes.get(typeId);
    }

    @Override
    @NotNull
    public Iterable<GraphEntityType<?>> getAllGraphEntityTypes() {
        return this.graphEntityTypes.values();
    }
}

