/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.LinkEntityPacketDecoder;
import com.kneelawk.graphlib.api.graph.user.LinkEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.LinkKeyPacketDecoder;
import com.kneelawk.graphlib.api.graph.user.LinkKeyType;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.graph.user.NodeEntityPacketDecoder;
import com.kneelawk.graphlib.api.graph.user.NodeEntityType;
import com.kneelawk.graphlib.api.graph.user.SidedBlockNode;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.api.util.SidedPos;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.graph.ClientGraphWorldImpl;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraph;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraphChunk;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraphPillar;
import com.kneelawk.graphlib.impl.graph.simple.SimpleClientGraphChunkManager;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphCollection;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphUniverse;
import com.kneelawk.graphlib.impl.graph.simple.SimpleNodeHolder;
import com.kneelawk.graphlib.impl.net.GLNet;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleClientGraphWorld
implements GraphView,
ClientGraphWorldImpl,
SimpleGraphCollection {
    private final SimpleGraphUniverse universe;
    final class_1937 world;
    private final SimpleClientGraphChunkManager manager;
    private final Long2ObjectMap<SimpleBlockGraph> graphs = new Long2ObjectLinkedOpenHashMap();

    public SimpleClientGraphWorld(SimpleGraphUniverse universe, class_1937 world, int loadDistance) {
        this.universe = universe;
        this.world = world;
        this.manager = new SimpleClientGraphChunkManager(loadDistance, world, this::onUnload);
    }

    @Override
    public void unload(int chunkX, int chunkZ) {
        this.manager.unload(chunkX, chunkZ);
    }

    @Override
    public void setChunkMapCenter(int x, int z) {
        this.manager.setPillarMapCenter(x, z);
    }

    @Override
    public void updateLoadDistance(int loadDistance) {
        this.manager.updateLoadDistance(loadDistance);
    }

    @Override
    public void readChunkPillar(int chunkX, int chunkZ, NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        SimpleBlockGraphPillar pillar = this.manager.getOrCreatePillar(chunkX, chunkZ);
        if (pillar == null) {
            GLLog.warn("Received pillar outside current client range at ({}, {})", (Object)chunkX, (Object)chunkZ);
            ctx.drop("Pillar outside range");
            return;
        }
        int graphCount = buf.readVarUnsignedInt();
        for (int graphIndex = 0; graphIndex < graphCount; ++graphIndex) {
            buf.readMarker("gs");
            long graphId = buf.readVarUnsignedLong();
            SimpleBlockGraph graph = this.getOrCreateGraph(graphId);
            graph.loadGraphEntitiesFromPacket(buf, ctx);
            ObjectArrayList nodeList = new ObjectArrayList();
            buf.readMarker("n");
            int nodeCount = buf.readInt();
            for (int i = 0; i < nodeCount; ++i) {
                NodePos nodePos = NodePos.fromPacket(buf, ctx, this.universe);
                class_2338 blockPos = nodePos.pos();
                NodeEntity entity = this.readNodeEntity(ctx, buf, blockPos);
                SimpleNodeHolder<BlockNode> holder = graph.createNode(blockPos, nodePos.node(), entity, false);
                nodeList.add(holder);
            }
            buf.readMarker("il");
            int linkCount = buf.readInt();
            for (int i = 0; i < linkCount; ++i) {
                int nodeAIndex = buf.readVarUnsignedInt();
                int nodeBIndex = buf.readVarUnsignedInt();
                if (nodeAIndex < 0 || nodeAIndex >= nodeList.size()) {
                    GLLog.warn("Received packet with invalid links. Node index {} is invalid.", (Object)nodeAIndex);
                    throw new InvalidInputDataException("Received packet with invalid links. Node index " + nodeAIndex + " is invalid.");
                }
                if (nodeBIndex < 0 || nodeBIndex >= nodeList.size()) {
                    GLLog.warn("Received packet with invalid links. Node index {} is invalid.", (Object)nodeBIndex);
                    throw new InvalidInputDataException("Received packet with invalid links. Node index " + nodeBIndex + " is invalid.");
                }
                NodeHolder nodeA = (NodeHolder)nodeList.get(nodeAIndex);
                NodeHolder nodeB = (NodeHolder)nodeList.get(nodeBIndex);
                LinkKeyType linkType = GLNet.readType(buf, ctx.getConnection(), this.universe::getLinkKeyType, "LinkKey", nodeA.getBlockPos());
                LinkKeyPacketDecoder linkDecoder = linkType.getPacketDecoder();
                if (linkDecoder == null) {
                    GLLog.error("Unable to decode LinkKey {} @ {}-{} because it has no packet decoder", linkType.getId(), nodeA.getBlockPos(), nodeB.getBlockPos());
                    throw new InvalidInputDataException("Unable to decode LinkKey " + linkType.getId() + " @ " + nodeA.getBlockPos() + "-" + nodeB.getBlockPos() + " because it has no packet decoder");
                }
                LinkKey linkKey = linkDecoder.decode(buf, ctx);
                LinkEntity entity = this.readLinkEntity(buf, ctx, new LinkPos(nodeA.getPos(), nodeB.getPos(), linkKey));
                graph.link(nodeA, nodeB, linkKey, entity, false);
            }
            buf.readMarker("el");
            int eLinkCount = buf.readVarUnsignedInt();
            for (int i = 0; i < eLinkCount; ++i) {
                LinkPos link = LinkPos.fromPacket(buf, ctx, this.universe);
                NodeHolder<BlockNode> holderA = graph.getNodeAt(link.first());
                NodeHolder<BlockNode> holderB = graph.getNodeAt(link.second());
                LinkEntity entity = this.readLinkEntity(buf, ctx, link);
                if (holderA != null && holderB != null) {
                    graph.link(holderA, holderB, link.key(), entity, false);
                    continue;
                }
                if (entity == null) continue;
                entity.onDiscard();
            }
            buf.readMarker("ge");
        }
    }

    @Nullable
    private NodeEntity readNodeEntity(IMsgReadCtx ctx, NetByteBuf buf, class_2338 blockPos) throws InvalidInputDataException {
        NodeEntity entity = null;
        if (buf.readBoolean()) {
            NodeEntityType entityType = GLNet.readType(buf, ctx.getConnection(), this.universe::getNodeEntityType, "NodeEntity", blockPos);
            NodeEntityPacketDecoder entityDecoder = entityType.getPacketDecoder();
            if (entityDecoder == null) {
                GLLog.error("Unable to decode NodeEntity {} @ {} because it has no packet decoder", (Object)entityType.getId(), (Object)blockPos);
                throw new InvalidInputDataException("Unable to decode NodeEntity " + entityType.getId() + " @ " + blockPos + " because it has no packet decoder");
            }
            entity = entityDecoder.decode(buf, ctx);
        }
        return entity;
    }

    @Nullable
    private LinkEntity readLinkEntity(NetByteBuf buf, IMsgReadCtx ctx, LinkPos link) throws InvalidInputDataException {
        LinkEntity entity = null;
        if (buf.readBoolean()) {
            LinkEntityType entityType = GLNet.readType(buf, ctx.getConnection(), this.universe::getLinkEntityType, "LinkEntity", link.first().pos());
            LinkEntityPacketDecoder entityDecoder = entityType.getPacketDecoder();
            if (entityDecoder == null) {
                GLLog.error("Unable to decode LinkEntity {} @ {} because it has no packet decoder", (Object)entityType.getId(), (Object)link);
                throw new InvalidInputDataException("Unable to decode LinkEntity " + entityType.getId() + " @ " + link + " because it has no packet decoder");
            }
            entity = entityDecoder.decode(buf, ctx);
        }
        return entity;
    }

    @Override
    public void readNodeAdd(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        NodePos pos = NodePos.fromPacket(buf, ctx, this.universe);
        BlockNode node = pos.node();
        class_2338 blockPos = pos.pos();
        class_1923 chunkPos = new class_1923(pos.pos());
        if (!this.manager.isInRadius(chunkPos)) {
            GLLog.warn("Received node add @ {} that is outside client chunk radius", (Object)pos);
            ctx.drop("Received node add outside client chunk radius");
            return;
        }
        long graphId = buf.readVarUnsignedLong();
        SimpleBlockGraph graph = this.getOrCreateGraph(graphId);
        graph.loadGraphEntitiesFromPacket(buf, ctx);
        NodeEntity entity = this.readNodeEntity(ctx, buf, blockPos);
        graph.createNode(blockPos, node, entity, true);
    }

    @Override
    public void readMerge(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        long fromId = buf.readVarUnsignedLong();
        SimpleBlockGraph from = (SimpleBlockGraph)this.graphs.get(fromId);
        if (from == null) {
            ctx.drop("Unknown from graph");
            return;
        }
        long intoId = buf.readVarUnsignedLong();
        SimpleBlockGraph into = this.getOrCreateGraph(intoId);
        into.loadGraphEntitiesFromPacket(buf, ctx);
        into.merge(from);
    }

    @Override
    public void readLink(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        long graphId = buf.readVarUnsignedLong();
        SimpleBlockGraph graph = (SimpleBlockGraph)this.graphs.get(graphId);
        if (graph == null) {
            GLLog.warn("Received link in unknown graph {}", (Object)graphId);
            ctx.drop("Unknown graph");
            return;
        }
        LinkPos linkPos = LinkPos.fromPacket(buf, ctx, this.universe);
        NodeHolder<BlockNode> nodeA = graph.getNodeAt(linkPos.first());
        NodeHolder<BlockNode> nodeB = graph.getNodeAt(linkPos.second());
        if (nodeA == null || nodeB == null) {
            ctx.drop("Link outside range");
            return;
        }
        LinkEntity entity = this.readLinkEntity(buf, ctx, linkPos);
        graph.link(nodeA, nodeB, linkPos.key(), entity, true);
    }

    @Override
    public void readUnlink(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        long graphId = buf.readVarUnsignedLong();
        SimpleBlockGraph graph = (SimpleBlockGraph)this.graphs.get(graphId);
        if (graph == null) {
            GLLog.warn("Received unlink in unknown graph {}", (Object)graphId);
            ctx.drop("Unknown graph");
            return;
        }
        LinkPos linkPos = LinkPos.fromPacket(buf, ctx, this.universe);
        NodeHolder<BlockNode> nodeA = graph.getNodeAt(linkPos.first());
        NodeHolder<BlockNode> nodeB = graph.getNodeAt(linkPos.second());
        if (nodeA == null || nodeB == null) {
            ctx.drop("Link outside range");
            return;
        }
        graph.unlink(nodeA, nodeB, linkPos.key());
    }

    @Override
    public void readSplitInto(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        long fromId = buf.readVarUnsignedLong();
        SimpleBlockGraph from = (SimpleBlockGraph)this.graphs.get(fromId);
        if (from == null) {
            ctx.drop("Unknown from graph");
            return;
        }
        long intoId = buf.readVarUnsignedLong();
        SimpleBlockGraph into = this.getOrCreateGraph(intoId);
        into.loadGraphEntitiesFromPacket(buf, ctx);
        ObjectLinkedOpenHashSet toSplit = new ObjectLinkedOpenHashSet();
        int nodeCount = buf.readVarUnsignedInt();
        for (int i = 0; i < nodeCount; ++i) {
            NodePos pos = NodePos.fromPacket(buf, ctx, this.universe);
            toSplit.add(pos);
        }
        from.splitInto(into, (Collection<NodePos>)toSplit);
    }

    @Override
    public void readNodeRemove(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        long graphId = buf.readVarUnsignedLong();
        SimpleBlockGraph graph = (SimpleBlockGraph)this.graphs.get(graphId);
        if (graph == null) {
            GLLog.warn("Received node remove in unknown graph {}", (Object)graphId);
            ctx.drop("Unknown graph");
            return;
        }
        NodePos pos = NodePos.fromPacket(buf, ctx, this.universe);
        NodeHolder<BlockNode> node = graph.getNodeAt(pos);
        if (node == null) {
            return;
        }
        graph.destroyNode(node, false);
    }

    @Override
    @NotNull
    public GraphUniverse getUniverse() {
        return this.universe;
    }

    @Override
    @NotNull
    public class_1937 getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public Stream<NodeHolder<BlockNode>> getNodesAt(@NotNull class_2338 pos) {
        return this.getAllGraphIdsAt(pos).mapToObj(this.graphs).filter(Objects::nonNull).flatMap(g -> g.getNodesAt(pos));
    }

    @Override
    @NotNull
    public Stream<NodeHolder<SidedBlockNode>> getNodesAt(@NotNull SidedPos pos) {
        return this.getAllGraphIdsAt(pos.pos()).mapToObj(this.graphs).filter(Objects::nonNull).flatMap(g -> g.getNodesAt(pos));
    }

    @Override
    @Nullable
    public NodeHolder<BlockNode> getNodeAt(@NotNull NodePos pos) {
        BlockGraph graph = this.getGraphForNode(pos);
        if (graph == null) {
            return null;
        }
        return graph.getNodeAt(pos);
    }

    @Override
    public boolean nodeExistsAt(@NotNull NodePos pos) {
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(class_4076.method_18682((class_2338)pos.pos()));
        if (chunk == null) {
            return false;
        }
        return chunk.containsNode(pos, (Long2ObjectFunction<SimpleBlockGraph>)this.graphs);
    }

    @Override
    @Nullable
    public BlockGraph getGraphForNode(@NotNull NodePos pos) {
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(class_4076.method_18682((class_2338)pos.pos()));
        if (chunk == null) {
            return null;
        }
        return chunk.getGraphForNode(pos, (Long2ObjectFunction<SimpleBlockGraph>)this.graphs);
    }

    @Override
    @Nullable
    public NodeEntity getNodeEntity(@NotNull NodePos pos) {
        BlockGraph graph = this.getGraphForNode(pos);
        if (graph == null) {
            return null;
        }
        return graph.getNodeEntity(pos);
    }

    @Override
    public boolean linkExistsAt(@NotNull LinkPos pos) {
        BlockGraph graph = this.getGraphForNode(pos.first());
        if (graph == null) {
            return false;
        }
        return graph.linkExistsAt(pos);
    }

    @Override
    @Nullable
    public LinkHolder<LinkKey> getLinkAt(@NotNull LinkPos pos) {
        BlockGraph graph = this.getGraphForNode(pos.first());
        if (graph == null) {
            return null;
        }
        return graph.getLinkAt(pos);
    }

    @Override
    @Nullable
    public LinkEntity getLinkEntity(@NotNull LinkPos pos) {
        BlockGraph graph = this.getGraphForNode(pos.first());
        if (graph == null) {
            return null;
        }
        return graph.getLinkEntity(pos);
    }

    @Override
    @NotNull
    public LongStream getAllGraphIdsAt(@NotNull class_2338 pos) {
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(class_4076.method_18682((class_2338)pos));
        if (chunk == null) {
            return LongStream.empty();
        }
        return chunk.getGraphsAt(pos).longStream();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphsAt(@NotNull class_2338 pos) {
        return this.getAllGraphIdsAt(pos).mapToObj(this.graphs);
    }

    @Override
    @Nullable
    public BlockGraph getGraph(long id) {
        return (BlockGraph)this.graphs.get(id);
    }

    @Override
    @NotNull
    public LongStream getAllGraphIdsInChunkSection(@NotNull class_4076 pos) {
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(pos);
        if (chunk == null) {
            return LongStream.empty();
        }
        return chunk.getGraphs().longStream();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphsInChunkSection(@NotNull class_4076 pos) {
        return this.getAllGraphIdsInChunkSection(pos).mapToObj(this.graphs);
    }

    @Override
    @NotNull
    public LongStream getAllGraphIdsInChunk(@NotNull class_1923 pos) {
        SimpleBlockGraphPillar pillar = this.manager.getPillar(pos.field_9181, pos.field_9180);
        if (pillar == null) {
            return LongStream.empty();
        }
        LongLinkedOpenHashSet graphsInChunk = new LongLinkedOpenHashSet();
        for (int chunkY = this.world.method_32891(); chunkY < this.world.method_31597(); ++chunkY) {
            SimpleBlockGraphChunk chunk = pillar.get(chunkY);
            if (chunk == null) continue;
            graphsInChunk.addAll((LongCollection)chunk.getGraphs());
        }
        return graphsInChunk.longStream();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphsInChunk(@NotNull class_1923 pos) {
        return this.getAllGraphIdsInChunk(pos).mapToObj(this.graphs);
    }

    @Override
    @NotNull
    public LongStream getAllGraphIds() {
        return this.graphs.keySet().longStream();
    }

    @Override
    @NotNull
    public Stream<BlockGraph> getLoadedGraphs() {
        return this.graphs.values().stream().map(Function.identity());
    }

    private void onUnload(SimpleBlockGraphPillar pillar) {
        LongLinkedOpenHashSet unloading = new LongLinkedOpenHashSet();
        for (int chunkY = this.world.method_32891(); chunkY < this.world.method_31597(); ++chunkY) {
            SimpleBlockGraphChunk chunk = pillar.get(chunkY);
            if (chunk == null) continue;
            unloading.addAll((LongCollection)chunk.getGraphs());
        }
        LongIterator longIterator = unloading.iterator();
        while (longIterator.hasNext()) {
            long graphId = (Long)longIterator.next();
            SimpleBlockGraph graph = (SimpleBlockGraph)this.graphs.get(graphId);
            if (graph != null) {
                graph.unloadInChunk(pillar.x, pillar.z);
                continue;
            }
            GLLog.warn("Tried to unload graph that does not exist. Id: {}", (Object)graphId);
        }
    }

    @Override
    public void markDirty(long graphId) {
    }

    @Override
    @NotNull
    public SimpleBlockGraph createGraph(boolean initializeGraphEntities) {
        throw new UnsupportedOperationException("Graphs should never be split on the client");
    }

    @NotNull
    private SimpleBlockGraph getOrCreateGraph(long graphId) {
        return (SimpleBlockGraph)this.graphs.computeIfAbsent(graphId, id -> new SimpleBlockGraph((SimpleGraphCollection)this, id, false));
    }

    @Override
    public void destroyGraph(long id) {
        SimpleBlockGraph graph = (SimpleBlockGraph)this.graphs.get(id);
        if (graph == null) {
            GLLog.warn("Attempted to destroy graph that does not exist. Id: {}", (Object)id);
            return;
        }
        this.destroyGraphImpl(graph);
    }

    private void destroyGraphImpl(SimpleBlockGraph graph) {
        long id = graph.getId();
        this.graphs.remove(id);
        LongIterator longIterator = graph.chunks.iterator();
        while (longIterator.hasNext()) {
            long sectionPos = (Long)longIterator.next();
            SimpleBlockGraphChunk chunk = this.manager.getIfExists(class_4076.method_18677((long)sectionPos));
            if (chunk != null) {
                chunk.removeGraph(id);
                continue;
            }
            GLLog.warn("Attempted to destroy graph in chunk that does not exist. Id: {}, chunk: {}", (Object)id, (Object)class_4076.method_18677((long)sectionPos));
        }
        graph.onDestroy();
    }

    @Override
    public void putGraphWithNode(long id, @NotNull NodePos pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos.pos());
        SimpleBlockGraphChunk chunk = this.manager.getOrCreate(sectionPos);
        if (chunk != null) {
            chunk.putGraphWithNode(id, pos, (Long2ObjectFunction<SimpleBlockGraph>)this.graphs);
        } else {
            GLLog.warn("Attempted to add graph in chunk that is outside client range. Id: {}, chunk: {}, node: {}", id, sectionPos, pos);
        }
    }

    @Override
    public void removeGraphWithNode(long id, @NotNull NodePos pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos.pos());
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(sectionPos);
        if (chunk != null) {
            chunk.removeGraphWithNodeUnchecked(pos);
        } else {
            GLLog.warn("Tried to remove node from non-existent chunk. Id: {}, chunk: {}, node: {}", id, sectionPos, pos);
        }
    }

    @Override
    public void removeGraphInPos(long id, @NotNull class_2338 pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(sectionPos);
        if (chunk != null) {
            chunk.removeGraphInPosUnchecked(id, pos);
        } else {
            GLLog.warn("Tried to remove graph from non-existent chunk. Id: {}, chunk: {}, block: {}", id, sectionPos, pos);
        }
    }

    @Override
    public void removeGraphInChunk(long id, long pos) {
        class_4076 sectionPos = class_4076.method_18677((long)pos);
        SimpleBlockGraphChunk chunk = this.manager.getIfExists(sectionPos);
        if (chunk != null) {
            chunk.removeGraphUnchecked(id);
        } else {
            GLLog.warn("Tried to remove graph from non-existent chunk. Id: {}, chunk: {}", (Object)id, (Object)sectionPos);
        }
    }

    @Override
    public void removeGraphInPoses(long id, @NotNull Iterable<NodePos> nodes, @NotNull Iterable<class_2338> poses, @NotNull LongIterable chunkPoses) {
        for (NodePos node : nodes) {
            this.removeGraphWithNode(id, node);
        }
        for (class_2338 pos : poses) {
            this.removeGraphInPos(id, pos);
        }
        LongIterator longIterator = chunkPoses.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            this.removeGraphInChunk(id, pos);
        }
    }

    @Override
    public void scheduleCallbackUpdate(@NotNull NodeHolder<BlockNode> node, boolean validate) {
    }

    @Override
    public void graphUpdated(SimpleBlockGraph graph) {
    }

    @Override
    public void sendNodeAdd(BlockGraph graph, NodeHolder<BlockNode> node) {
    }

    @Override
    public void sendMerge(BlockGraph from, BlockGraph into) {
    }

    @Override
    public void sendLink(BlockGraph graph, LinkHolder<LinkKey> link) {
    }

    @Override
    public void sendUnlink(BlockGraph graph, NodeHolder<BlockNode> a, NodeHolder<BlockNode> b, LinkKey key) {
    }

    @Override
    public void sendSplitInto(BlockGraph from, BlockGraph into) {
    }

    @Override
    public void sendNodeRemove(BlockGraph graph, NodeHolder<BlockNode> holder) {
    }
}

