/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraphChunk;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraphPillar;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleClientGraphChunkManager {
    volatile ClientPillarMap pillars;
    final class_1937 world;
    private final UnloadListener unloadListener;

    public SimpleClientGraphChunkManager(int loadDistance, class_1937 world, UnloadListener unloadListener) {
        this.pillars = new ClientPillarMap(SimpleClientGraphChunkManager.getChunkMapRadius(loadDistance));
        this.world = world;
        this.unloadListener = unloadListener;
    }

    private static int getChunkMapRadius(int loadDistance) {
        return Math.max(2, loadDistance) + 3;
    }

    private static boolean positionEquals(@Nullable SimpleBlockGraphPillar pillar, int x, int z) {
        if (pillar == null) {
            return false;
        }
        return pillar.x == x && pillar.z == z;
    }

    public void unload(int chunkX, int chunkZ) {
        int i;
        SimpleBlockGraphPillar pillar;
        if (this.pillars.isInRadius(chunkX, chunkZ) && SimpleClientGraphChunkManager.positionEquals(pillar = this.pillars.getPillar(i = this.pillars.getIndex(chunkX, chunkZ)), chunkX, chunkZ)) {
            this.unloadListener.onPillarUnload(pillar);
            this.pillars.compareAndSet(i, pillar, null);
        }
    }

    @Nullable
    public SimpleBlockGraphPillar getPillar(int chunkX, int chunkZ) {
        SimpleBlockGraphPillar pillar;
        if (this.pillars.isInRadius(chunkX, chunkZ) && SimpleClientGraphChunkManager.positionEquals(pillar = this.pillars.getPillar(this.pillars.getIndex(chunkX, chunkZ)), chunkX, chunkZ)) {
            return pillar;
        }
        return null;
    }

    public boolean isInRadius(int chunkX, int chunkZ) {
        return this.pillars.isInRadius(chunkX, chunkZ);
    }

    public boolean isInRadius(class_1923 pos) {
        return this.isInRadius(pos.field_9181, pos.field_9180);
    }

    @Nullable
    public SimpleBlockGraphPillar getOrCreatePillar(int x, int z) {
        if (!this.pillars.isInRadius(x, z)) {
            return null;
        }
        int i = this.pillars.getIndex(x, z);
        SimpleBlockGraphPillar pillar = this.pillars.pillars.get(i);
        if (!SimpleClientGraphChunkManager.positionEquals(pillar, x, z)) {
            if (pillar != null) {
                this.unloadListener.onPillarUnload(pillar);
            }
            pillar = new SimpleBlockGraphPillar(x, z, this.world);
            this.pillars.set(i, pillar);
        }
        return pillar;
    }

    @Nullable
    public SimpleBlockGraphChunk getIfExists(int chunkX, int chunkY, int chunkZ) {
        SimpleBlockGraphPillar pillar = this.getPillar(chunkX, chunkZ);
        if (pillar == null) {
            return null;
        }
        return pillar.get(chunkY);
    }

    @Nullable
    public SimpleBlockGraphChunk getIfExists(class_4076 pos) {
        return this.getIfExists(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @Nullable
    public SimpleBlockGraphChunk getOrCreate(int chunkX, int chunkY, int chunkZ) {
        SimpleBlockGraphPillar pillar = this.getOrCreatePillar(chunkX, chunkZ);
        if (pillar == null) {
            return null;
        }
        return pillar.getOrCreate(chunkY);
    }

    @Nullable
    public SimpleBlockGraphChunk getOrCreate(class_4076 pos) {
        return this.getOrCreate(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public void setPillarMapCenter(int x, int z) {
        this.pillars.centerChunkX = x;
        this.pillars.centerChunkZ = z;
    }

    public void updateLoadDistance(int loadDistance) {
        int oldRadius = this.pillars.radius;
        int newRadius = SimpleClientGraphChunkManager.getChunkMapRadius(loadDistance);
        if (oldRadius != newRadius) {
            ClientPillarMap map = new ClientPillarMap(newRadius);
            map.centerChunkX = this.pillars.centerChunkX;
            map.centerChunkZ = this.pillars.centerChunkZ;
            for (int i = 0; i < this.pillars.pillars.length(); ++i) {
                SimpleBlockGraphPillar pillar = this.pillars.pillars.get(i);
                if (pillar == null) continue;
                if (map.isInRadius(pillar.x, pillar.z)) {
                    map.set(map.getIndex(pillar.x, pillar.z), pillar);
                    continue;
                }
                this.unloadListener.onPillarUnload(pillar);
            }
            this.pillars = map;
        }
    }

    public int getLoadedPillarCount() {
        return this.pillars.loadedPillarCount;
    }

    static final class ClientPillarMap {
        final AtomicReferenceArray<@Nullable SimpleBlockGraphPillar> pillars;
        final int radius;
        private final int diameter;
        volatile int centerChunkX;
        volatile int centerChunkZ;
        int loadedPillarCount;

        ClientPillarMap(int radius) {
            this.radius = radius;
            this.diameter = radius * 2 + 1;
            this.pillars = new AtomicReferenceArray(this.diameter * this.diameter);
        }

        int getIndex(int chunkX, int chunkZ) {
            return Math.floorMod(chunkZ, this.diameter) * this.diameter + Math.floorMod(chunkX, this.diameter);
        }

        private void set(int index, @Nullable SimpleBlockGraphPillar pillar) {
            @Nullable SimpleBlockGraphPillar oldPillar = this.pillars.getAndSet(index, pillar);
            if (oldPillar != null) {
                --this.loadedPillarCount;
            }
            if (pillar != null) {
                ++this.loadedPillarCount;
            }
        }

        private SimpleBlockGraphPillar compareAndSet(int index, SimpleBlockGraphPillar expect, SimpleBlockGraphPillar update) {
            if (this.pillars.compareAndSet(index, expect, update) && update == null) {
                --this.loadedPillarCount;
            }
            return expect;
        }

        boolean isInRadius(int chunkX, int chunkZ) {
            return Math.abs(chunkX - this.centerChunkX) <= this.radius && Math.abs(chunkZ - this.centerChunkZ) <= this.radius;
        }

        @Nullable
        protected SimpleBlockGraphPillar getPillar(int index) {
            return this.pillars.get(index);
        }
    }

    public static interface UnloadListener {
        public void onPillarUnload(@NotNull SimpleBlockGraphPillar var1);
    }
}

