/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.BlockNodeType;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.api.world.StorageChunk;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.graph.simple.SimpleBlockGraph;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphUniverse;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockGraphChunk
implements StorageChunk {
    final class_4076 chunkPos;
    private final Runnable markDirty;
    private final Short2ObjectMap<LongSet> graphsInPos = new Short2ObjectLinkedOpenHashMap();
    private final LongSet graphsInChunk = new LongLinkedOpenHashSet();
    @Nullable
    private Short2ObjectMap<Object2LongMap<BlockNode>> blockNodes = null;

    public SimpleBlockGraphChunk(@NotNull class_2487 nbt, @NotNull class_4076 chunkPos, @NotNull Runnable markDirty, SimpleGraphUniverse universe) {
        this.chunkPos = chunkPos;
        this.markDirty = markDirty;
        class_2499 inChunkList = nbt.method_10554("inChunk", 4);
        for (class_2520 element : inChunkList) {
            this.graphsInChunk.add(((class_2503)element).method_10699());
        }
        class_2499 inPosList = nbt.method_10554("inPos", 10);
        for (class_2520 element : inPosList) {
            class_2499 ids;
            LongSet inPos;
            class_2487 com = (class_2487)element;
            class_2338 pos = new class_2338((int)com.method_10571("x"), (int)com.method_10571("y"), (int)com.method_10571("z"));
            class_2499 nodes = com.method_10554("nodes", 10);
            if (!nodes.isEmpty()) {
                short shortPos = class_4076.method_19454((class_2338)pos);
                inPos = (LongSet)this.graphsInPos.computeIfAbsent(shortPos, s -> new LongLinkedOpenHashSet());
                for (class_2520 keyElement : nodes) {
                    class_2487 keyCom = (class_2487)keyElement;
                    long graphId = keyCom.method_10537("id");
                    inPos.add(graphId);
                    class_2338 keyPos = pos.method_10069(chunkPos.method_19527(), chunkPos.method_19528(), chunkPos.method_19529());
                    class_2960 typeId = new class_2960(keyCom.method_10558("type"));
                    BlockNodeType type = universe.getNodeType(typeId);
                    if (type == null) {
                        GLLog.error("Chunk tried to load unknown NodeKey type: {} @ {}.", (Object)typeId, (Object)keyPos);
                        continue;
                    }
                    class_2520 dataTag = keyCom.method_10580("data");
                    BlockNode data = type.getDecoder().decode(dataTag);
                    if (this.blockNodes == null) {
                        this.blockNodes = new Short2ObjectLinkedOpenHashMap();
                    }
                    ((Object2LongMap)this.blockNodes.computeIfAbsent(shortPos, pos1 -> new Object2LongLinkedOpenHashMap())).put((Object)data, graphId);
                }
            }
            if ((ids = com.method_10554("ids", 4)).isEmpty()) continue;
            inPos = (LongSet)this.graphsInPos.computeIfAbsent(class_4076.method_19454((class_2338)pos), s -> new LongLinkedOpenHashSet());
            for (class_2520 idElement : ids) {
                inPos.add(((class_2503)idElement).method_10699());
            }
        }
    }

    public SimpleBlockGraphChunk(@NotNull class_4076 chunkPos, @NotNull Runnable markDirty) {
        this.chunkPos = chunkPos;
        this.markDirty = markDirty;
        this.blockNodes = new Short2ObjectLinkedOpenHashMap();
    }

    @Override
    public void toNbt(@NotNull class_2487 nbt) {
        class_2499 inChunkList = new class_2499();
        LongIterator longIterator = this.graphsInChunk.iterator();
        while (longIterator.hasNext()) {
            long id = (Long)longIterator.next();
            inChunkList.add((Object)class_2503.method_23251((long)id));
        }
        nbt.method_10566("inChunk", (class_2520)inChunkList);
        class_2499 inPosList = new class_2499();
        ShortIterator keyIterator = this.graphsInPos.keySet().iterator();
        while (keyIterator.hasNext()) {
            short shortPos = keyIterator.nextShort();
            class_2487 inPos = new class_2487();
            class_2338 localPos = new class_2338(class_4076.method_30551((short)shortPos), class_4076.method_30552((short)shortPos), class_4076.method_30553((short)shortPos));
            inPos.method_10567("x", (byte)localPos.method_10263());
            inPos.method_10567("y", (byte)localPos.method_10264());
            inPos.method_10567("z", (byte)localPos.method_10260());
            if (this.blockNodes == null || !this.blockNodes.containsKey(shortPos)) {
                class_2499 ids = new class_2499();
                LongIterator longIterator2 = ((LongSet)this.graphsInPos.get(shortPos)).iterator();
                while (longIterator2.hasNext()) {
                    long id = (Long)longIterator2.next();
                    ids.add((Object)class_2503.method_23251((long)id));
                }
                inPos.method_10566("ids", (class_2520)ids);
            } else {
                Object2LongMap keyMap = (Object2LongMap)this.blockNodes.get(shortPos);
                class_2499 nodes = new class_2499();
                for (Object2LongMap.Entry entry : keyMap.object2LongEntrySet()) {
                    class_2487 keyCom = new class_2487();
                    long id = entry.getLongValue();
                    keyCom.method_10544("id", id);
                    class_2520 data = ((BlockNode)entry.getKey()).toTag();
                    if (data != null) {
                        keyCom.method_10566("data", data);
                    }
                    keyCom.method_10582("type", ((BlockNode)entry.getKey()).getType().getId().toString());
                    nodes.add((Object)keyCom);
                }
                inPos.method_10566("nodes", (class_2520)nodes);
            }
            inPosList.add((Object)inPos);
        }
        nbt.method_10566("inPos", (class_2520)inPosList);
    }

    public void clear() {
        this.graphsInPos.clear();
        this.graphsInChunk.clear();
        if (this.blockNodes == null) {
            this.blockNodes = new Short2ObjectLinkedOpenHashMap();
        } else {
            this.blockNodes.clear();
        }
    }

    public void putGraphWithNode(long id, @NotNull NodePos key, Long2ObjectFunction<SimpleBlockGraph> graphGetter) {
        this.markDirty.run();
        short posShort = class_4076.method_19454((class_2338)key.pos());
        Short2ObjectMap<Object2LongMap<BlockNode>> graphNodes = this.getGraphNodes(graphGetter);
        ((Object2LongMap)graphNodes.computeIfAbsent(posShort, pos -> new Object2LongLinkedOpenHashMap())).put((Object)key.node(), id);
        this.graphsInChunk.add(id);
        ((LongSet)this.graphsInPos.computeIfAbsent(posShort, s -> new LongLinkedOpenHashSet())).add(id);
    }

    public void removeGraph(long id) {
        this.markDirty.run();
        this.graphsInChunk.remove(id);
        IntIterator posIterator = this.graphsInPos.keySet().intIterator();
        while (posIterator.hasNext()) {
            Object2LongMap nodes;
            short posShort = (short)posIterator.nextInt();
            LongSet graphs = (LongSet)this.graphsInPos.get(posShort);
            boolean removed = graphs.remove(id);
            if (graphs.isEmpty()) {
                posIterator.remove();
            }
            if (!removed || this.blockNodes == null || (nodes = (Object2LongMap)this.blockNodes.get(posShort)) == null) continue;
            nodes.values().removeIf(l -> l == id);
            if (!nodes.isEmpty()) continue;
            this.blockNodes.remove(posShort);
        }
    }

    @Nullable
    public SimpleBlockGraph getGraphForNode(NodePos key, Long2ObjectFunction<SimpleBlockGraph> graphGetter) {
        Short2ObjectMap<Object2LongMap<BlockNode>> nodes = this.getGraphNodes(graphGetter);
        Object2LongMap uNodes = (Object2LongMap)nodes.get(class_4076.method_19454((class_2338)key.pos()));
        if (uNodes == null) {
            return null;
        }
        if (!uNodes.containsKey((Object)key.node())) {
            return null;
        }
        return (SimpleBlockGraph)graphGetter.get(uNodes.getLong((Object)key.node()));
    }

    public boolean containsNode(NodePos key, Long2ObjectFunction<SimpleBlockGraph> graphGetter) {
        Short2ObjectMap<Object2LongMap<BlockNode>> nodes = this.getGraphNodes(graphGetter);
        Object2LongMap uNodes = (Object2LongMap)nodes.get(class_4076.method_19454((class_2338)key.pos()));
        if (uNodes == null) {
            return false;
        }
        return uNodes.containsKey((Object)key.node());
    }

    public LongSet getGraphsAt(class_2338 pos) {
        return (LongSet)this.graphsInPos.get(class_4076.method_19454((class_2338)pos));
    }

    public LongSet getGraphs() {
        return this.graphsInChunk;
    }

    public void removeGraphWithNodeUnchecked(@NotNull NodePos key) {
        Object2LongMap nodes;
        this.markDirty.run();
        short posShort = class_4076.method_19454((class_2338)key.pos());
        if (this.blockNodes != null && (nodes = (Object2LongMap)this.blockNodes.get(posShort)) != null) {
            nodes.removeLong((Object)key.node());
            if (nodes.isEmpty()) {
                this.blockNodes.remove(posShort);
            }
        }
    }

    public void removeGraphInPosUnchecked(long id, @NotNull class_2338 pos) {
        this.markDirty.run();
        short local = class_4076.method_19454((class_2338)pos);
        LongSet graphs = (LongSet)this.graphsInPos.get(local);
        graphs.remove(id);
        if (graphs.isEmpty()) {
            this.graphsInPos.remove(local);
        }
    }

    public void removeGraphUnchecked(long id) {
        this.markDirty.run();
        this.graphsInChunk.remove(id);
    }

    @NotNull
    private Short2ObjectMap<Object2LongMap<BlockNode>> getGraphNodes(Long2ObjectFunction<SimpleBlockGraph> graphGetter) {
        if (this.blockNodes == null) {
            this.blockNodes = new Short2ObjectLinkedOpenHashMap();
            this.rebuildGraphNodes(graphGetter);
        }
        return this.blockNodes;
    }

    private void rebuildGraphNodes(Long2ObjectFunction<SimpleBlockGraph> graphGetter) {
        assert (this.blockNodes != null);
        GLLog.debug("Rebuilding block node -> graph lookup for chunk {}", this.chunkPos);
        this.markDirty.run();
        this.blockNodes.clear();
        LongIterator iter = this.graphsInChunk.iterator();
        while (iter.hasNext()) {
            long graphId = iter.nextLong();
            BlockGraph graph = (BlockGraph)graphGetter.get(graphId);
            if (graph == null) {
                GLLog.warn("Chunk encountered null graph for {} when rebuilding block node -> graph lookup @ {}", (Object)graphId, (Object)this.chunkPos);
                continue;
            }
            for (NodeHolder<BlockNode> holder : graph.getNodes().toList()) {
                NodePos key = holder.getPos();
                class_2338 pos = key.pos();
                if (this.chunkPos.method_19527() > pos.method_10263() || pos.method_10263() > this.chunkPos.method_19530() || this.chunkPos.method_19528() > pos.method_10264() || pos.method_10264() > this.chunkPos.method_19531() || this.chunkPos.method_19529() > pos.method_10260() || pos.method_10260() > this.chunkPos.method_19532()) continue;
                ((Object2LongMap)this.blockNodes.computeIfAbsent(class_4076.method_19454((class_2338)pos), pos1 -> new Object2LongLinkedOpenHashMap())).put((Object)key.node(), graphId);
            }
        }
    }
}

