/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph.simple;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityPacketDecoder;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.LinkEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.LinkKeyType;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.graph.user.NodeEntityType;
import com.kneelawk.graphlib.api.graph.user.SidedBlockNode;
import com.kneelawk.graphlib.api.util.CacheCategory;
import com.kneelawk.graphlib.api.util.EmptyLinkKey;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.api.util.SidedPos;
import com.kneelawk.graphlib.api.util.graph.Graph;
import com.kneelawk.graphlib.api.util.graph.Link;
import com.kneelawk.graphlib.api.util.graph.Node;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphCollection;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphEntityContext;
import com.kneelawk.graphlib.impl.graph.simple.SimpleLinkEntityContext;
import com.kneelawk.graphlib.impl.graph.simple.SimpleLinkHolder;
import com.kneelawk.graphlib.impl.graph.simple.SimpleNodeEntityContext;
import com.kneelawk.graphlib.impl.graph.simple.SimpleNodeHolder;
import com.kneelawk.graphlib.impl.graph.simple.SimpleNodeWrapper;
import com.kneelawk.graphlib.impl.graph.simple.SimpleServerGraphWorld;
import com.kneelawk.graphlib.impl.net.GLNet;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockGraph
implements BlockGraph {
    final SimpleGraphCollection world;
    private final long id;
    private final Graph<SimpleNodeWrapper, LinkKey> graph = new Graph();
    private final Map<NodePos, NodeEntity> nodeEntities = new Object2ObjectLinkedOpenHashMap();
    private final Map<LinkPos, LinkEntity> linkEntities = new Object2ObjectLinkedOpenHashMap();
    private final Multimap<class_2338, NodeHolder<BlockNode>> nodesInPos = LinkedHashMultimap.create();
    private final Long2ObjectMap<Set<NodeHolder<BlockNode>>> nodesInChunk = new Long2ObjectLinkedOpenHashMap();
    private final Map<NodePos, NodeHolder<BlockNode>> nodesToHolders = new Object2ObjectLinkedOpenHashMap();
    final LongSet chunks = new LongLinkedOpenHashSet();
    private final Map<CacheCategory<?>, List<?>> nodeCaches = new Object2ObjectLinkedOpenHashMap();
    private final Map<GraphEntityType<?>, GraphEntity<?>> graphEntities = new Object2ObjectLinkedOpenHashMap();

    @NotNull
    static SimpleBlockGraph fromTag(@NotNull SimpleServerGraphWorld controller, long id, @NotNull class_2487 tag) {
        GraphEntity<?> entity;
        class_2499 chunksTag = tag.method_10554("chunks", 4);
        LongLinkedOpenHashSet chunks = new LongLinkedOpenHashSet();
        for (class_2520 chunkElement : chunksTag) {
            chunks.add(((class_2503)chunkElement).method_10699());
        }
        SimpleBlockGraph graph = new SimpleBlockGraph((SimpleGraphCollection)controller, id, (LongSet)chunks);
        class_2499 nodesTag = tag.method_10554("nodes", 10);
        class_2499 linksTag = tag.method_10554("links", 10);
        class_2487 graphEntities = tag.method_10562("graphEntities");
        ArrayList<@Nullable SimpleNodeHolder<BlockNode>> nodes = new ArrayList<SimpleNodeHolder<BlockNode>>();
        for (class_2520 nodeElement : nodesTag) {
            class_2487 com = (class_2487)nodeElement;
            SimpleNodeWrapper node = SimpleNodeWrapper.fromTag(controller.universe, com, id);
            if (node != null) {
                entity = null;
                if (com.method_10573("entityType", 8)) {
                    class_2960 entityTypeId = new class_2960(com.method_10558("entityType"));
                    NodeEntityType type = controller.universe.getNodeEntityType(entityTypeId);
                    if (type != null) {
                        entity = type.getDecoder().decode(com.method_10580("entity"));
                    } else {
                        GLLog.warn("Encountered Node Entity with unknown type id: {}", (Object)entityTypeId);
                    }
                }
                nodes.add(graph.createNode(node.getPos(), node.getNode(), (NodeEntity)((Object)entity), false));
                continue;
            }
            nodes.add(null);
        }
        for (class_2520 linkElement : linksTag) {
            class_2487 linkTag = (class_2487)linkElement;
            NodeHolder first = (NodeHolder)nodes.get(linkTag.method_10550("first"));
            NodeHolder second = (NodeHolder)nodes.get(linkTag.method_10550("second"));
            if (first == null || second == null) continue;
            LinkKey key = EmptyLinkKey.INSTANCE;
            if (linkTag.method_10573("keyType", 8)) {
                class_2960 keyTypeId = new class_2960(linkTag.method_10558("keyType"));
                LinkKeyType type = controller.universe.getLinkKeyType(keyTypeId);
                if (type != null) {
                    LinkKey decodedKey = type.getDecoder().decode(linkTag.method_10580("key"));
                    if (decodedKey != null) {
                        key = decodedKey;
                    }
                } else {
                    GLLog.warn("Encountered link key with unknown type id: {}", (Object)keyTypeId);
                }
            }
            LinkEntity entity2 = null;
            if (linkTag.method_10573("entityType", 8)) {
                class_2960 entityTypeId = new class_2960(linkTag.method_10558("entityType"));
                LinkEntityType type = controller.universe.getLinkEntityType(entityTypeId);
                if (type != null) {
                    entity2 = type.getDecoder().decode(linkTag.method_10580("entity"));
                } else {
                    GLLog.warn("Encountered Link Entity with unknown id: {}", (Object)entityTypeId);
                }
            }
            graph.link(first, second, key, entity2, false);
        }
        for (GraphEntityType<?> type : controller.universe.getAllGraphEntityTypes()) {
            SimpleGraphEntityContext ctx = new SimpleGraphEntityContext((class_1937)controller.world, controller, graph);
            if (graphEntities.method_10573(type.getId().toString(), 10)) {
                class_2487 entityCom = graphEntities.method_10562(type.getId().toString());
                entity = type.getDecoder().decode(entityCom.method_10580("entity"));
                if (entity == null) {
                    entity = type.getFactory().createNew();
                }
                graph.graphEntities.put(type, entity);
                entity.onInit(ctx);
                continue;
            }
            GLLog.warn("Graph missing graph entity of type: {}, creating a new one...", (Object)type.getId());
            GraphEntity<?> entity3 = type.getFactory().createNew();
            graph.graphEntities.put(type, entity3);
            entity3.onInit(ctx);
        }
        return graph;
    }

    public SimpleBlockGraph(@NotNull SimpleGraphCollection world, long id, boolean initializeGraphEntities) {
        this(world, id, LongSet.of());
        this.world.markDirty(id);
        if (initializeGraphEntities) {
            for (GraphEntityType<?> type : this.world.getUniverse().getAllGraphEntityTypes()) {
                GraphEntity<?> entity = type.getFactory().createNew();
                this.graphEntities.put(type, entity);
                entity.onInit(new SimpleGraphEntityContext(this.world.getWorld(), this.world, this));
            }
        }
    }

    private SimpleBlockGraph(@NotNull SimpleGraphCollection world, long id, @NotNull LongSet chunks) {
        this.world = world;
        this.id = id;
        this.chunks.addAll((LongCollection)chunks);
    }

    @NotNull
    class_2487 toTag() {
        class_2520 entityTag;
        class_2487 tag = new class_2487();
        class_2499 chunksTag = new class_2499();
        LongIterator longIterator = this.chunks.iterator();
        while (longIterator.hasNext()) {
            long chunk = (Long)longIterator.next();
            chunksTag.add((Object)class_2503.method_23251((long)chunk));
        }
        tag.method_10566("chunks", (class_2520)chunksTag);
        List<Node<SimpleNodeWrapper, LinkKey>> nodes = this.graph.stream().toList();
        Map<Node, Integer> nodeIndexMap = IntStream.range(0, nodes.size()).mapToObj(i -> new class_3545((Object)((Node)nodes.get(i)), (Object)i)).collect(Collectors.toMap(class_3545::method_15442, class_3545::method_15441));
        class_2499 nodesTag = new class_2499();
        for (Node<SimpleNodeWrapper, LinkKey> node2 : nodes) {
            class_2487 com = node2.data().toTag();
            NodePos key = new NodePos(node2.data().getPos(), node2.data().getNode());
            NodeEntity entity = this.nodeEntities.get(key);
            if (entity != null) {
                com.method_10582("entityType", entity.getType().getId().toString());
                entityTag = entity.toTag();
                if (entityTag != null) {
                    com.method_10566("entity", entityTag);
                }
            }
            nodesTag.add((Object)com);
        }
        tag.method_10566("nodes", (class_2520)nodesTag);
        class_2499 linksTag = new class_2499();
        for (Link link : nodes.stream().flatMap(node -> node.connections().stream()).distinct().toList()) {
            LinkEntity entity;
            if (!nodeIndexMap.containsKey(link.first())) {
                GLLog.warn("Attempted to save link with non-existent node. Graph Id: {}, offending node: {}, missing node: {}", this.id, link.second(), link.first());
                continue;
            }
            if (!nodeIndexMap.containsKey(link.second())) {
                GLLog.warn("Attempted to save link with non-existent node. Graph Id: {}, offending node: {}, missing node: {}", this.id, link.first(), link.second());
                continue;
            }
            class_2487 linkTag = new class_2487();
            linkTag.method_10569("first", nodeIndexMap.get(link.first()).intValue());
            linkTag.method_10569("second", nodeIndexMap.get(link.second()).intValue());
            LinkKey key = (LinkKey)link.key();
            linkTag.method_10582("keyType", key.getType().getId().toString());
            class_2520 keyTag = key.toTag();
            if (keyTag != null) {
                linkTag.method_10566("key", keyTag);
            }
            if ((entity = this.linkEntities.get(new LinkPos(((SimpleNodeWrapper)link.first().data()).getPos(), ((SimpleNodeWrapper)link.first().data()).getNode(), ((SimpleNodeWrapper)link.second().data()).getPos(), ((SimpleNodeWrapper)link.second().data()).getNode(), (LinkKey)link.key()))) != null) {
                linkTag.method_10582("entityType", entity.getType().getId().toString());
                class_2520 entityTag2 = entity.toTag();
                if (entityTag2 != null) {
                    linkTag.method_10566("entity", entityTag2);
                }
            }
            linksTag.add((Object)linkTag);
        }
        tag.method_10566("links", (class_2520)linksTag);
        class_2487 class_24872 = new class_2487();
        for (Map.Entry<GraphEntityType<?>, GraphEntity<?>> entry : this.graphEntities.entrySet()) {
            class_2487 graphEntityCom = new class_2487();
            entityTag = entry.getValue().toTag();
            if (entityTag != null) {
                graphEntityCom.method_10566("entity", entityTag);
            }
            class_24872.method_10566(entry.getKey().getId().toString(), (class_2520)graphEntityCom);
        }
        tag.method_10566("graphEntities", (class_2520)class_24872);
        return tag;
    }

    void loadGraphEntitiesFromPacket(NetByteBuf buf, IMsgReadCtx ctx) throws InvalidInputDataException {
        int entityCount = buf.readVarUnsignedInt();
        for (int entityIndex = 0; entityIndex < entityCount; ++entityIndex) {
            int typeIdInt = buf.readVarUnsignedInt();
            class_2960 typeId = (class_2960)GLNet.ID_CACHE.getObj(ctx.getConnection(), typeIdInt);
            if (typeId == null) {
                GLLog.warn("Unable to decode graph entity type id int as id. Int: {}", (Object)typeIdInt);
                throw new InvalidInputDataException("Unable to decode graph entity type id int as id. Int: " + typeIdInt);
            }
            GraphEntityType<?> type = this.world.getUniverse().getGraphEntityType(typeId);
            if (type == null) {
                GLLog.warn("Received unknown graph entity type id: {}", (Object)typeId);
                throw new InvalidInputDataException("Received unknown graph entity type id: " + typeId);
            }
            GraphEntityPacketDecoder decoder = type.getPacketDecoder();
            if (decoder == null) {
                GLLog.warn("Received graph entity but type has no packet decoder. Id: {}", (Object)typeId);
                throw new InvalidInputDataException("Received graph entity but type has no packet decoder. Id: " + typeId);
            }
            GraphEntity<?> entity = decoder.decode(buf, ctx);
            if (this.graphEntities.containsKey(type)) {
                entity.onDiscard();
                continue;
            }
            this.graphEntities.put(type, entity);
            entity.onInit(new SimpleGraphEntityContext(this.world.getWorld(), this.world, this));
        }
        for (GraphEntityType<?> type : this.world.getUniverse().getAllGraphEntityTypes()) {
            if (this.graphEntities.containsKey(type)) continue;
            GraphEntity<?> entity = type.getFactory().createNew();
            this.graphEntities.put(type, entity);
            entity.onInit(new SimpleGraphEntityContext(this.world.getWorld(), this.world, this));
        }
    }

    void writeGraphEntitiesToPacket(NetByteBuf buf, IMsgWriteCtx ctx) {
        buf.writeVarUnsignedInt(this.graphEntities.size());
        for (Map.Entry<GraphEntityType<?>, GraphEntity<?>> entry : this.graphEntities.entrySet()) {
            buf.writeVarUnsignedInt(GLNet.ID_CACHE.getId(ctx.getConnection(), (Object)entry.getKey().getId()));
            entry.getValue().toPacket(buf, ctx);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public GraphView getGraphView() {
        return this.world;
    }

    @Override
    @NotNull
    public Stream<NodeHolder<BlockNode>> getNodesAt(@NotNull class_2338 pos) {
        return this.nodesInPos.get((Object)pos).stream();
    }

    @Override
    @NotNull
    public Stream<NodeHolder<SidedBlockNode>> getNodesAt(@NotNull SidedPos pos) {
        return this.nodesInPos.get((Object)pos.pos()).stream().filter(node -> {
            SidedBlockNode sidedNode;
            Object patt16823$temp = node.getNode();
            return patt16823$temp instanceof SidedBlockNode && (sidedNode = (SidedBlockNode)patt16823$temp).getSide() == pos.side();
        }).map(node -> node.cast(SidedBlockNode.class));
    }

    @Override
    public boolean nodeExistsAt(@NotNull NodePos pos) {
        return this.nodesToHolders.containsKey(pos);
    }

    @Override
    @Nullable
    public NodeHolder<BlockNode> getNodeAt(@NotNull NodePos pos) {
        return this.nodesToHolders.get(pos);
    }

    @Override
    public boolean linkExistsAt(@NotNull LinkPos pos) {
        SimpleNodeHolder node1 = (SimpleNodeHolder)this.nodesToHolders.get(pos.first());
        SimpleNodeHolder node2 = (SimpleNodeHolder)this.nodesToHolders.get(pos.second());
        if (node1 == null || node2 == null) {
            return false;
        }
        Link<SimpleNodeWrapper, LinkKey> rawLink = new Link<SimpleNodeWrapper, LinkKey>(node1.node, node2.node, pos.key());
        return node1.node.connections().contains(rawLink) && node2.node.connections().contains(rawLink);
    }

    @Override
    @Nullable
    public LinkHolder<LinkKey> getLinkAt(@NotNull LinkPos pos) {
        SimpleNodeHolder node1 = (SimpleNodeHolder)this.nodesToHolders.get(pos.first());
        SimpleNodeHolder node2 = (SimpleNodeHolder)this.nodesToHolders.get(pos.second());
        if (node1 == null || node2 == null) {
            return null;
        }
        Link<SimpleNodeWrapper, LinkKey> rawLink = new Link<SimpleNodeWrapper, LinkKey>(node1.node, node2.node, pos.key());
        if (!node1.node.connections().contains(rawLink) || !node2.node.connections().contains(rawLink)) {
            return null;
        }
        return new SimpleLinkHolder<LinkKey>(this.world.getWorld(), this.world, rawLink);
    }

    @Override
    @Nullable
    public NodeEntity getNodeEntity(@NotNull NodePos pos) {
        return this.nodeEntities.get(pos);
    }

    @Override
    @Nullable
    public LinkEntity getLinkEntity(@NotNull LinkPos pos) {
        return this.linkEntities.get(pos);
    }

    @Override
    @NotNull
    public Stream<NodeHolder<BlockNode>> getNodesInChunkSection(class_4076 pos) {
        Set inChunk = (Set)this.nodesInChunk.get(pos.method_18694());
        if (inChunk != null) {
            return inChunk.stream();
        }
        return Stream.empty();
    }

    @Override
    @NotNull
    public Stream<NodeHolder<BlockNode>> getNodes() {
        return this.graph.stream().map(node -> new SimpleNodeHolder(this.world.getWorld(), this.world, (Node<SimpleNodeWrapper, LinkKey>)node));
    }

    @Override
    @NotNull
    public Stream<NodeEntity> getNodeEntities() {
        return this.nodeEntities.values().stream();
    }

    @Override
    @NotNull
    public Stream<LinkEntity> getLinkEntities() {
        return this.linkEntities.values().stream();
    }

    @Override
    @NotNull
    public <T extends BlockNode> Collection<NodeHolder<T>> getCachedNodes(@NotNull CacheCategory<T> category) {
        ImmutableList cached = this.nodeCaches.get(category);
        if (cached == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Node<SimpleNodeWrapper, LinkKey> node : this.graph) {
                SimpleNodeHolder holder = new SimpleNodeHolder(this.world.getWorld(), this.world, node);
                if (!category.matches(holder)) continue;
                builder.add(holder.cast(category.getNodeClass()));
            }
            cached = builder.build();
            this.nodeCaches.put(category, (List<?>)cached);
        }
        return cached;
    }

    @Override
    @NotNull
    public Stream<class_4076> getChunks() {
        return this.chunks.longStream().mapToObj(class_4076::method_18677);
    }

    @Override
    @NotNull
    public <G extends GraphEntity<G>> G getGraphEntity(GraphEntityType<G> type) {
        GraphEntity<?> entity = this.graphEntities.get(type);
        if (entity == null) {
            throw new IllegalArgumentException("No graph entity type registered with id: " + type.getId());
        }
        return (G)entity;
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    private void rebuildRefs() {
        this.chunks.clear();
        this.nodesInPos.clear();
        this.nodesInChunk.clear();
        this.nodesToHolders.clear();
        this.world.markDirty(this.id);
        for (Node<SimpleNodeWrapper, LinkKey> node : this.graph) {
            SimpleNodeWrapper data = node.data();
            data.graphId = this.id;
            class_2338 pos = data.getPos();
            long sectionPos = class_4076.method_18682((class_2338)pos).method_18694();
            this.chunks.add(sectionPos);
            SimpleNodeHolder holder = new SimpleNodeHolder(this.world.getWorld(), this.world, node);
            this.nodesInPos.put((Object)pos, holder);
            ((Set)this.nodesInChunk.computeIfAbsent(sectionPos, posLong -> new ObjectLinkedOpenHashSet())).add(holder);
            this.nodesToHolders.put(holder.getPos(), holder);
        }
    }

    private void rebuildCaches() {
        this.nodeCaches.clear();
        for (CacheCategory<?> category : this.world.getUniverse().getCacheCatetories()) {
            this.getCachedNodes(category);
        }
    }

    @NotNull
    SimpleNodeHolder<BlockNode> createNode(@NotNull class_2338 blockPos, @NotNull BlockNode node, @Nullable NodeEntity entity, boolean newlyAdded) {
        boolean initialize;
        NodeEntity nodeEntity;
        class_2338 pos = blockPos.method_10062();
        NodePos nodePos = new NodePos(pos, node);
        if (this.nodesToHolders.containsKey(nodePos)) {
            if (entity != null) {
                entity.onDiscard();
            }
            return (SimpleNodeHolder)this.nodesToHolders.get(nodePos);
        }
        SimpleNodeHolder<BlockNode> graphNode = new SimpleNodeHolder<BlockNode>(this.world.getWorld(), this.world, this.graph.add(new SimpleNodeWrapper(pos, node, this.id)));
        if (entity != null) {
            if (node.shouldHaveNodeEntity(graphNode) && !this.nodeEntities.containsKey(nodePos)) {
                this.nodeEntities.put(nodePos, entity);
                nodeEntity = entity;
                initialize = true;
            } else {
                entity.onDiscard();
                nodeEntity = this.nodeEntities.get(nodePos);
                initialize = false;
            }
        } else if (node.shouldHaveNodeEntity(graphNode) && !this.nodeEntities.containsKey(nodePos)) {
            nodeEntity = node.createNodeEntity(graphNode);
            if (nodeEntity != null) {
                this.nodeEntities.put(nodePos, nodeEntity);
                initialize = true;
            } else {
                initialize = false;
            }
        } else {
            nodeEntity = this.nodeEntities.get(nodePos);
            initialize = false;
        }
        this.nodesInPos.put((Object)pos, graphNode);
        long sectionPos = class_4076.method_18682((class_2338)pos).method_18694();
        ((Set)this.nodesInChunk.computeIfAbsent(sectionPos, posLong -> new ObjectLinkedOpenHashSet())).add(graphNode);
        this.nodesToHolders.put(nodePos, graphNode);
        this.chunks.add(sectionPos);
        this.world.putGraphWithNode(this.id, nodePos);
        this.world.scheduleCallbackUpdate(graphNode, true);
        this.rebuildCaches();
        if (initialize) {
            nodeEntity.onInit(new SimpleNodeEntityContext(graphNode, this.world.getWorld(), this.world));
            if (newlyAdded) {
                nodeEntity.onAdded();
            } else {
                nodeEntity.onLoaded();
            }
        }
        for (GraphEntity<?> graphEntity : this.graphEntities.values()) {
            graphEntity.onNodeCreated(graphNode, nodeEntity);
        }
        this.world.markDirty(this.id);
        this.world.sendNodeAdd(this, graphNode);
        return graphNode;
    }

    void destroyNode(@NotNull NodeHolder<BlockNode> holder, boolean doSplit) {
        NodeEntity nodeEntity;
        this.world.sendNodeRemove(this, holder);
        SimpleNodeHolder node = (SimpleNodeHolder)holder;
        NodePos removedNode = node.getPos();
        class_2338 removedPos = node.getBlockPos();
        class_4076 removedChunk = class_4076.method_18682((class_2338)removedPos);
        this.nodesInPos.remove((Object)removedPos, (Object)node);
        Set inRemovedChunk = (Set)this.nodesInChunk.get(removedChunk.method_18694());
        if (inRemovedChunk != null) {
            inRemovedChunk.remove(holder);
            if (inRemovedChunk.isEmpty()) {
                this.nodesInChunk.remove(removedChunk.method_18694());
            }
        }
        this.nodesToHolders.remove(removedNode);
        this.world.markDirty(this.id);
        Object2ObjectLinkedOpenHashMap removedLinks = new Object2ObjectLinkedOpenHashMap();
        for (Link<SimpleNodeWrapper, LinkKey> link : node.node.connections()) {
            this.world.scheduleCallbackUpdate(new SimpleNodeHolder<BlockNode>(this.world.getWorld(), this.world, link.other(node.node)), true);
            LinkPos linkPos = new LinkPos(link.first().data().getPos(), link.first().data().getNode(), link.second().data().getPos(), link.second().data().getNode(), link.key());
            LinkEntity linkEntity = this.linkEntities.get(linkPos);
            if (linkEntity == null) continue;
            removedLinks.put(linkPos, linkEntity);
        }
        this.world.scheduleCallbackUpdate(node, false);
        this.graph.remove(node.node);
        for (Node node2 : this.graph) {
            class_2338 class_23382 = ((SimpleNodeWrapper)node2.data()).getPos();
            if (class_23382.equals((Object)removedPos)) {
                removedPos = null;
                removedChunk = null;
                break;
            }
            if (!class_4076.method_18682((class_2338)class_23382).equals((Object)removedChunk)) continue;
            removedChunk = null;
        }
        this.world.removeGraphWithNode(this.id, removedNode);
        if (removedPos != null) {
            this.world.removeGraphInPos(this.id, removedPos);
        }
        if (removedChunk != null) {
            long chunkLong = removedChunk.method_18694();
            this.world.removeGraphInChunk(this.id, chunkLong);
            this.chunks.remove(chunkLong);
        }
        if ((nodeEntity = this.nodeEntities.remove(node.getPos())) != null) {
            nodeEntity.onDelete();
        }
        for (Map.Entry entry : removedLinks.entrySet()) {
            this.linkEntities.remove(entry.getKey());
            ((LinkEntity)entry.getValue()).onDelete();
        }
        for (GraphEntity<?> graphEntity : this.graphEntities.values()) {
            graphEntity.onNodeDestroyed(holder, nodeEntity, (Map<LinkPos, LinkEntity>)removedLinks);
        }
        this.rebuildCaches();
        if (this.graph.isEmpty()) {
            this.world.destroyGraph(this.id);
        } else if (doSplit) {
            this.split();
        }
    }

    @NotNull
    LinkHolder<LinkKey> link(@NotNull NodeHolder<BlockNode> a, @NotNull NodeHolder<BlockNode> b, LinkKey key, @Nullable LinkEntity entity, boolean newlyAdded) {
        boolean initialize;
        LinkEntity linkEntity;
        Link<SimpleNodeWrapper, LinkKey> rawLink = new Link<SimpleNodeWrapper, LinkKey>(((SimpleNodeHolder)a).node, ((SimpleNodeHolder)b).node, key);
        SimpleLinkHolder<LinkKey> link = new SimpleLinkHolder<LinkKey>(this.world.getWorld(), this.world, rawLink);
        boolean unique = this.graph.link(rawLink);
        if (!unique) {
            if (entity != null) {
                entity.onDiscard();
            }
            return link;
        }
        LinkPos linkPos = link.getPos();
        if (entity != null) {
            if (key.shouldHaveLinkEntity(link) && !this.linkEntities.containsKey(linkPos)) {
                this.linkEntities.put(linkPos, entity);
                linkEntity = entity;
                initialize = true;
            } else {
                entity.onDiscard();
                linkEntity = this.linkEntities.get(linkPos);
                initialize = false;
            }
        } else if (key.shouldHaveLinkEntity(link) && !this.linkEntities.containsKey(linkPos)) {
            linkEntity = key.createLinkEntity(link);
            if (linkEntity != null) {
                this.linkEntities.put(linkPos, linkEntity);
                initialize = true;
            } else {
                initialize = false;
            }
        } else {
            linkEntity = this.linkEntities.get(linkPos);
            initialize = false;
        }
        this.world.scheduleCallbackUpdate(a, true);
        this.world.scheduleCallbackUpdate(b, true);
        if (initialize) {
            linkEntity.onInit(new SimpleLinkEntityContext(link, this.world.getWorld(), this.world));
            if (newlyAdded) {
                linkEntity.onAdded();
            } else {
                linkEntity.onLoaded();
            }
        }
        for (GraphEntity<?> graphEntity : this.graphEntities.values()) {
            graphEntity.onLink(a, b, linkEntity);
        }
        this.world.markDirty(this.id);
        this.world.sendLink(this, link);
        return link;
    }

    boolean unlink(@NotNull NodeHolder<BlockNode> a, @NotNull NodeHolder<BlockNode> b, LinkKey key) {
        this.world.sendUnlink(this, a, b, key);
        boolean linkRemoved = this.graph.unlink(((SimpleNodeHolder)a).node, ((SimpleNodeHolder)b).node, key);
        LinkEntity entity = this.linkEntities.remove(new LinkPos(a.getPos(), b.getPos(), key));
        if (entity != null) {
            entity.onDelete();
        }
        if (!linkRemoved) {
            return false;
        }
        this.world.scheduleCallbackUpdate(a, true);
        this.world.scheduleCallbackUpdate(b, true);
        for (GraphEntity<?> graphEntity : this.graphEntities.values()) {
            graphEntity.onUnlink(a, b, entity);
        }
        this.world.markDirty(this.id);
        return true;
    }

    void merge(@NotNull SimpleBlockGraph other) {
        if (other.id == this.id) {
            return;
        }
        this.world.sendMerge(other, this);
        for (Node<SimpleNodeWrapper, LinkKey> node : other.graph) {
            this.world.putGraphWithNode(this.id, new NodePos(node.data().getPos(), node.data().getNode()));
            node.data().graphId = this.id;
        }
        this.graph.join(other.graph);
        this.nodeEntities.putAll(other.nodeEntities);
        this.linkEntities.putAll(other.linkEntities);
        this.nodesInPos.putAll(other.nodesInPos);
        for (Long2ObjectMap.Entry entry : other.nodesInChunk.long2ObjectEntrySet()) {
            this.nodesInChunk.merge(entry.getLongKey(), (Object)((Set)entry.getValue()), (a, b) -> {
                a.addAll(b);
                return a;
            });
        }
        this.nodesToHolders.putAll(other.nodesToHolders);
        this.chunks.addAll((LongCollection)other.chunks);
        this.world.markDirty(this.id);
        for (Map.Entry entry : this.graphEntities.entrySet()) {
            GraphEntityType type = (GraphEntityType)entry.getKey();
            GraphEntity<?> otherEntity = other.graphEntities.get(type);
            if (otherEntity != null) {
                type.merge((GraphEntity)entry.getValue(), otherEntity);
                continue;
            }
            GLLog.warn("Merging graph with missing graph entity: {}. Skipping...", (Object)type.getId());
        }
        this.rebuildCaches();
        this.world.destroyGraph(other.id);
    }

    @NotNull
    List<SimpleBlockGraph> split() {
        List<Graph<SimpleNodeWrapper, LinkKey>> newGraphs = this.graph.split();
        if (!newGraphs.isEmpty()) {
            LinkedHashSet<NodePos> removedNodes = new LinkedHashSet<NodePos>();
            LinkedHashSet<class_2338> removedPoses = new LinkedHashSet<class_2338>();
            LongLinkedOpenHashSet removedChunks = new LongLinkedOpenHashSet();
            for (Graph<SimpleNodeWrapper, LinkKey> graph : newGraphs) {
                for (Node<SimpleNodeWrapper, LinkKey> node : graph) {
                    class_2338 pos = node.data().getPos();
                    NodePos nodePos = new NodePos(pos, node.data().getNode());
                    removedNodes.add(nodePos);
                    removedPoses.add(pos);
                    long sectionPos = class_4076.method_18682((class_2338)pos).method_18694();
                    removedChunks.add(sectionPos);
                    SimpleNodeHolder holder = new SimpleNodeHolder(this.world.getWorld(), this.world, node);
                    this.nodesInPos.remove((Object)pos, holder);
                    Set inRemovedChunk = (Set)this.nodesInChunk.get(sectionPos);
                    if (inRemovedChunk != null) {
                        inRemovedChunk.remove(holder);
                        if (inRemovedChunk.isEmpty()) {
                            this.nodesInChunk.remove(sectionPos);
                        }
                    }
                    this.nodesToHolders.remove(nodePos);
                }
            }
            for (Node node : this.graph) {
                SimpleNodeWrapper data = (SimpleNodeWrapper)node.data();
                removedPoses.remove(data.getPos());
                removedChunks.remove(class_4076.method_18682((class_2338)data.getPos()).method_18694());
            }
            this.world.removeGraphInPoses(this.id, removedNodes, removedPoses, (LongIterable)removedChunks);
            this.chunks.removeAll((LongCollection)removedChunks);
            this.world.markDirty(this.id);
            ArrayList<SimpleBlockGraph> newBlockGraphs = new ArrayList<SimpleBlockGraph>(newGraphs.size());
            for (Graph<SimpleNodeWrapper, LinkKey> graph : newGraphs) {
                Object entity;
                SimpleBlockGraph simpleBlockGraph = this.world.createGraph(false);
                simpleBlockGraph.graph.join(graph);
                simpleBlockGraph.rebuildRefs();
                for (Node<SimpleNodeWrapper, LinkKey> node : simpleBlockGraph.graph) {
                    NodePos key = new NodePos(node.data().getPos(), node.data().getNode());
                    this.world.putGraphWithNode(simpleBlockGraph.id, key);
                    entity = this.nodeEntities.remove(key);
                    if (entity != null) {
                        simpleBlockGraph.nodeEntities.put(key, (NodeEntity)entity);
                    }
                    for (Link<SimpleNodeWrapper, LinkKey> link : node.connections()) {
                        Node<SimpleNodeWrapper, LinkKey> other = link.other(node);
                        LinkPos linkKey = new LinkPos(key, new NodePos(other.data().getPos(), other.data().getNode()), link.key());
                        LinkEntity linkEntity = this.linkEntities.remove(linkKey);
                        if (linkEntity == null) continue;
                        simpleBlockGraph.linkEntities.put(linkKey, linkEntity);
                    }
                }
                for (Map.Entry entry : this.graphEntities.entrySet()) {
                    GraphEntityType type = (GraphEntityType)entry.getKey();
                    entity = type.splitNew((GraphEntity)entry.getValue(), this, simpleBlockGraph);
                    simpleBlockGraph.graphEntities.put(type, (GraphEntity<?>)entity);
                    entity.onInit(new SimpleGraphEntityContext(this.world.getWorld(), this.world, simpleBlockGraph));
                }
                simpleBlockGraph.rebuildCaches();
                newBlockGraphs.add(simpleBlockGraph);
                this.world.graphUpdated(simpleBlockGraph);
                this.world.sendSplitInto(this, simpleBlockGraph);
            }
            this.rebuildCaches();
            this.world.graphUpdated(this);
            return newBlockGraphs;
        }
        this.world.graphUpdated(this);
        return List.of();
    }

    void splitInto(SimpleBlockGraph into, Collection<NodePos> nodes) {
        Object entity;
        LinkedHashSet movedNodes = new LinkedHashSet();
        LinkedHashSet<NodePos> removedNodes = new LinkedHashSet<NodePos>();
        LinkedHashSet<class_2338> removedPoses = new LinkedHashSet<class_2338>();
        LongLinkedOpenHashSet removedChunks = new LongLinkedOpenHashSet();
        for (NodePos nodePos : nodes) {
            NodeHolder<BlockNode> holder = this.nodesToHolders.remove(nodePos);
            if (holder == null) continue;
            class_2338 pos = nodePos.pos();
            removedNodes.add(nodePos);
            removedPoses.add(pos);
            long sectionPos = class_4076.method_18682((class_2338)pos).method_18694();
            removedChunks.add(sectionPos);
            this.nodesInPos.remove((Object)pos, holder);
            Set inRemovedChunk = (Set)this.nodesInChunk.get(sectionPos);
            if (inRemovedChunk != null) {
                inRemovedChunk.remove(holder);
                if (inRemovedChunk.isEmpty()) {
                    this.nodesInChunk.remove(sectionPos);
                }
            }
            movedNodes.add(((SimpleNodeHolder)holder).node);
        }
        if (movedNodes.isEmpty()) {
            return;
        }
        this.graph.moveBulkUnchecked(into.graph, movedNodes);
        for (Node node : this.graph) {
            SimpleNodeWrapper data = (SimpleNodeWrapper)node.data();
            removedPoses.remove(data.getPos());
            removedChunks.remove(class_4076.method_18682((class_2338)data.getPos()).method_18694());
        }
        this.world.removeGraphInPoses(this.id, removedNodes, removedPoses, (LongIterable)removedChunks);
        this.chunks.removeAll((LongCollection)removedChunks);
        this.world.markDirty(this.id);
        into.rebuildRefs();
        for (Node node : into.graph) {
            NodePos key = new NodePos(((SimpleNodeWrapper)node.data()).getPos(), ((SimpleNodeWrapper)node.data()).getNode());
            this.world.putGraphWithNode(into.id, key);
            entity = this.nodeEntities.remove(key);
            if (entity != null) {
                into.nodeEntities.put(key, (NodeEntity)entity);
            }
            for (Link link : node.connections()) {
                Node other = link.other(node);
                LinkPos linkKey = new LinkPos(key, new NodePos(((SimpleNodeWrapper)other.data()).getPos(), ((SimpleNodeWrapper)other.data()).getNode()), (LinkKey)link.key());
                LinkEntity linkEntity = this.linkEntities.remove(linkKey);
                if (linkEntity == null) continue;
                into.linkEntities.put(linkKey, linkEntity);
            }
        }
        for (Map.Entry entry : this.graphEntities.entrySet()) {
            GraphEntityType type = (GraphEntityType)entry.getKey();
            entity = type.splitNew((GraphEntity)entry.getValue(), this, into);
            into.graphEntities.put(type, (GraphEntity<?>)entity);
            entity.onInit(new SimpleGraphEntityContext(this.world.getWorld(), this.world, into));
        }
        into.rebuildCaches();
    }

    void unloadInChunk(int chunkX, int chunkZ) {
        LinkedHashSet<NodePos> removedNodes = new LinkedHashSet<NodePos>();
        LinkedHashSet<class_2338> removedPoses = new LinkedHashSet<class_2338>();
        LongLinkedOpenHashSet removedChunks = new LongLinkedOpenHashSet();
        for (int sectionY = this.world.getWorld().method_32891(); sectionY < this.world.getWorld().method_31597(); ++sectionY) {
            long longPos = class_4076.method_18685((int)chunkX, (int)sectionY, (int)chunkZ);
            Set inRemovedChunk = (Set)this.nodesInChunk.get(longPos);
            if (inRemovedChunk == null) continue;
            removedChunks.add(longPos);
            for (NodeHolder holder : inRemovedChunk) {
                NodePos nodePos = holder.getPos();
                removedNodes.add(nodePos);
                removedPoses.add(nodePos.pos());
                NodeEntity nodeEntity = this.nodeEntities.get(nodePos);
                if (nodeEntity != null) {
                    nodeEntity.onUnload();
                }
                for (LinkHolder<LinkKey> link : holder.getConnections()) {
                    LinkPos linkKey = link.getPos();
                    LinkEntity linkEntity = this.linkEntities.remove(linkKey);
                    if (linkEntity == null) continue;
                    linkEntity.onUnload();
                }
                this.graph.remove(((SimpleNodeHolder)holder).node);
                this.nodesInPos.removeAll((Object)nodePos.pos());
                this.nodesToHolders.remove(nodePos);
                this.nodeEntities.remove(nodePos);
            }
            this.nodesInChunk.remove(longPos);
        }
        this.chunks.removeAll((LongCollection)removedChunks);
        this.rebuildCaches();
        this.world.removeGraphInPoses(this.id, removedNodes, removedPoses, (LongIterable)removedChunks);
    }

    void onUnload() {
        for (NodeEntity nodeEntity : this.nodeEntities.values()) {
            nodeEntity.onUnload();
        }
        for (LinkEntity linkEntity : this.linkEntities.values()) {
            linkEntity.onUnload();
        }
        for (GraphEntity graphEntity : this.graphEntities.values()) {
            graphEntity.onUnload();
        }
    }

    void onDestroy() {
        for (GraphEntity<?> entity : this.graphEntities.values()) {
            entity.onDestroy();
        }
    }

    void onTick() {
        for (GraphEntity<?> entity : this.graphEntities.values()) {
            entity.onTick();
        }
    }
}

