/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph;

import com.kneelawk.graphlib.api.event.UniverseModifyInitializer;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.UniverseModifierRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class UniverseModifierRegistryImpl
implements UniverseModifierRegistry {
    private final Map<class_2960, List<UniverseModifierRegistry.Modify>> individualModifiers = new HashMap<class_2960, List<UniverseModifierRegistry.Modify>>();
    private final List<UniverseModifierRegistry.ModifyAll> allModifiers = new ArrayList<UniverseModifierRegistry.ModifyAll>();

    private UniverseModifierRegistryImpl() {
    }

    public void preBuild(class_2960 universeId, GraphUniverse.Builder builder) {
        List<UniverseModifierRegistry.Modify> modifyList = this.individualModifiers.get(universeId);
        if (modifyList != null) {
            for (UniverseModifierRegistry.Modify modify : modifyList) {
                modify.modify(builder);
            }
        }
        for (UniverseModifierRegistry.ModifyAll modifyAll : this.allModifiers) {
            modifyAll.modify(universeId, builder);
        }
    }

    @Override
    public void modify(@NotNull class_2960 universeId, @NotNull UniverseModifierRegistry.Modify modifier) {
        List modifyList = this.individualModifiers.computeIfAbsent(universeId, k -> new ArrayList());
        modifyList.add(modifier);
    }

    @Override
    public void modifyAll(@NotNull UniverseModifierRegistry.ModifyAll modifier) {
        this.allModifiers.add(modifier);
    }

    public static UniverseModifierRegistryImpl setup() {
        UniverseModifierRegistryImpl impl = new UniverseModifierRegistryImpl();
        List modifyInitializers = FabricLoader.getInstance().getEntrypoints("graphlib:universe_modify", UniverseModifyInitializer.class);
        for (UniverseModifyInitializer modifyInitializer : modifyInitializers) {
            modifyInitializer.register(impl);
        }
        return impl;
    }
}

