/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph;

import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.GraphLibImpl;
import com.kneelawk.graphlib.impl.graph.GraphUniverseImpl;
import com.kneelawk.graphlib.impl.graph.GraphWorldStorage;
import com.kneelawk.graphlib.impl.graph.ServerGraphWorldImpl;
import com.kneelawk.graphlib.impl.net.GLNet;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class ServerGraphWorldStorage
implements GraphWorldStorage,
AutoCloseable {
    private final Map<class_2960, ServerGraphWorldImpl> worlds = new Object2ObjectLinkedOpenHashMap();
    private final class_3218 serverWorld;
    private final boolean synchronizationRequired;

    public ServerGraphWorldStorage(class_3218 world, Path dataDir, boolean syncChunkWrites) {
        this.serverWorld = world;
        boolean synced = false;
        for (GraphUniverseImpl universe : GraphLibImpl.UNIVERSE) {
            class_2960 universeId = universe.getId();
            Path path = dataDir.resolve(universeId.method_12836()).resolve(universeId.method_12832());
            this.worlds.put(universeId, universe.createGraphWorld(world, path, syncChunkWrites));
            if (!universe.getSyncProfile().isEnabled()) continue;
            synced = true;
        }
        this.synchronizationRequired = synced;
    }

    @Override
    @NotNull
    public ServerGraphWorldImpl get(@NotNull class_2960 universe) {
        if (!this.worlds.containsKey(universe)) {
            throw new IllegalStateException("Attempted to get a graph world for a universe that has not been registered. Make sure to call the universe's register() function in your mod's init. Universe: " + universe);
        }
        return this.worlds.get(universe);
    }

    public boolean isSynchronizationRequired() {
        return this.synchronizationRequired;
    }

    public void onWorldChunkLoad(class_1923 pos) {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            try {
                world.onWorldChunkLoad(pos);
            }
            catch (Exception e) {
                GLLog.error("Error loading chunk in GraphWorld. World: '{}'/{}, Chunk: {}", this.serverWorld, this.serverWorld.method_27983().method_29177(), pos, e);
            }
        }
    }

    public void onWorldChunkUnload(class_1923 pos) {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            try {
                world.onWorldChunkUnload(pos);
            }
            catch (Exception e) {
                GLLog.error("Error unloading chunk in GraphWorld. World: '{}'/{}, Chunk: {}", this.serverWorld, this.serverWorld.method_27983().method_29177(), pos, e);
            }
        }
    }

    public void tick() {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            try {
                world.tick();
            }
            catch (Exception e) {
                GLLog.error("Error ticking GraphWorld. World: '{}'/{}", this.serverWorld, this.serverWorld.method_27983().method_29177(), e);
            }
        }
    }

    public void saveChunk(class_1923 pos) {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            try {
                world.saveChunk(pos);
            }
            catch (Exception e) {
                GLLog.error("Error saving chunk in GraphWorld. World: '{}'/{}, Chunk: {}", this.serverWorld, this.serverWorld.method_27983().method_29177(), pos, e);
            }
        }
    }

    public void saveAll(boolean flush) {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            try {
                world.saveAll(flush);
            }
            catch (Exception e) {
                GLLog.error("Error saving all chunks in GraphWorld. World: '{}'/{}", this.serverWorld, this.serverWorld.method_27983().method_29177(), e);
            }
        }
    }

    @Override
    public void close() {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            try {
                world.close();
            }
            catch (Exception e) {
                GLLog.error("Error closing GraphWorld. World: '{}'/{}", this.serverWorld, this.serverWorld.method_27983().method_29177(), e);
            }
        }
    }

    public void sendChunkDataPackets(class_3222 player, class_1923 pos) {
        for (ServerGraphWorldImpl world : this.worlds.values()) {
            GraphUniverse universe = world.getUniverse();
            if (!universe.getSyncProfile().isEnabled() || !universe.getSyncProfile().getPlayerFilter().shouldSync(player)) continue;
            try {
                GLNet.sendChunkDataPacket(world, player, pos);
            }
            catch (Exception e) {
                GLLog.error("Error sending GraphWorld chunk packets. World: '{}'/{}, Chunk: {}", this.serverWorld, this.serverWorld.method_27983().method_29177(), pos, e);
            }
        }
    }
}

