/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.graph;

import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.GraphLibImpl;
import com.kneelawk.graphlib.impl.graph.ClientGraphWorldImpl;
import com.kneelawk.graphlib.impl.graph.GraphUniverseImpl;
import com.kneelawk.graphlib.impl.graph.GraphWorldStorage;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class ClientGraphWorldStorage
implements GraphWorldStorage {
    private final Map<class_2960, ClientGraphWorldImpl> worlds = new Object2ObjectLinkedOpenHashMap();
    private final class_1937 clientWorld;

    public ClientGraphWorldStorage(class_1937 clientWorld, int loadDistance) {
        this.clientWorld = clientWorld;
        for (GraphUniverseImpl universe : GraphLibImpl.UNIVERSE) {
            if (!universe.getSyncProfile().isEnabled()) continue;
            class_2960 universeId = universe.getId();
            this.worlds.put(universeId, universe.createClientGraphWorld(clientWorld, loadDistance));
        }
    }

    @Override
    @NotNull
    public ClientGraphWorldImpl get(@NotNull class_2960 universeId) {
        if (!this.worlds.containsKey(universeId)) {
            throw new IllegalStateException("Attempted to get a client graph world for a universe that has not been synchronized. Make sure your universe builder's synchronizeToClient(...) is called with something that allows synchronization. Universe: " + universeId);
        }
        return this.worlds.get(universeId);
    }

    public void unload(int chunkX, int chunkZ) {
        for (ClientGraphWorldImpl impl : this.worlds.values()) {
            try {
                impl.unload(chunkX, chunkZ);
            }
            catch (Exception e) {
                GLLog.error("Error unloading chunk in client GraphWorld. World: '{}'/{}, Chunk: ({}, {})", this.clientWorld, this.clientWorld.method_27983().method_29177(), chunkX, chunkZ, e);
            }
        }
    }

    public void setChunkMapCenter(int x, int z) {
        for (ClientGraphWorldImpl impl : this.worlds.values()) {
            try {
                impl.setChunkMapCenter(x, z);
            }
            catch (Exception e) {
                GLLog.error("Error setting center chunk in client GraphWorld. World: '{}'/{}, Chunk: ({}, {})", this.clientWorld, this.clientWorld.method_27983().method_29177(), x, z, e);
            }
        }
    }

    public void updateLoadDistance(int loadDistance) {
        for (ClientGraphWorldImpl impl : this.worlds.values()) {
            try {
                impl.updateLoadDistance(loadDistance);
            }
            catch (Exception | OutOfMemoryError e) {
                GLLog.error("Error setting load distance in client GraphWorld. World: '{}'/{}, Load distance: {}", this.clientWorld, this.clientWorld.method_27983().method_29177(), loadDistance, e);
            }
        }
    }
}

