/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.command;

import com.kneelawk.graphlib.impl.Constants;
import com.kneelawk.graphlib.impl.GraphLibImpl;
import com.kneelawk.graphlib.impl.graph.GraphUniverseImpl;
import com.kneelawk.graphlib.impl.graph.RebuildChunksListener;
import com.kneelawk.graphlib.impl.net.GLDebugNet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;

public class GraphLibCommand {
    private static final DynamicCommandExceptionType UNKNOWN_UNIVERSE = new DynamicCommandExceptionType(arg -> new LiteralMessage("Unknown universe: " + arg));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"graphlib").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"list").executes(context -> GraphLibCommand.listUniverses((class_2168)context.getSource())))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"universe", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            class_2172.method_9268((Iterable)GraphLibImpl.UNIVERSE.method_42021(), (String)remaining, class_5321::method_29177, id -> builder.suggest(id.method_29177().toString()));
            return builder.buildFuture();
        }).then(class_2170.method_9247((String)"updateblocks").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(context -> GraphLibCommand.updateBlocks((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"universe"), class_2262.method_9697((CommandContext)context, (String)"from"), class_2262.method_9697((CommandContext)context, (String)"to"))))))).then(class_2170.method_9247((String)"removeemptygraphs").executes(context -> GraphLibCommand.removeEmptyGraphsCommand((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"universe"))))).then(class_2170.method_9247((String)"rebuildchunks").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(context -> GraphLibCommand.rebuildChunks((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"universe"), class_2262.method_9697((CommandContext)context, (String)"from"), class_2262.method_9697((CommandContext)context, (String)"to"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debugrender").then(class_2170.method_9247((String)"start").executes(context -> GraphLibCommand.startDebugRender((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"universe"))))).then(class_2170.method_9247((String)"stop").executes(context -> GraphLibCommand.stopDebugRender((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"universe")))))));
    }

    private static int listUniverses(class_2168 source) {
        class_5250 msg = class_2561.method_43470((String)"Universes:");
        for (class_5321 key : GraphLibImpl.UNIVERSE.method_42021()) {
            msg.method_27693("\n");
            msg.method_10852((class_2561)class_2561.method_43470((String)key.method_29177().toString()).method_27694(style -> style.method_10977(class_124.field_1075).method_10958(new class_2558(class_2558.class_2559.field_21462, key.method_29177().toString()))));
        }
        source.method_9226(() -> msg, false);
        return GraphLibImpl.UNIVERSE.method_10204();
    }

    private static int updateBlocks(class_2168 source, class_2960 universeId, class_2338 from, class_2338 to) throws CommandSyntaxException {
        source.method_9226(() -> Constants.command("graphlib.updateblocks.starting", GraphLibCommand.blockPosText(from), GraphLibCommand.blockPosText(to)), true);
        class_3218 world = source.method_9225();
        GraphUniverseImpl universe = (GraphUniverseImpl)GraphLibImpl.UNIVERSE.method_10223(universeId);
        if (universe == null) {
            throw UNKNOWN_UNIVERSE.create((Object)universeId);
        }
        universe.getServerGraphWorld(world).updateNodes(class_2338.method_20437((class_2338)from, (class_2338)to));
        source.method_9226(() -> Constants.command("graphlib.updateblocks.success", GraphLibCommand.blockPosText(from), GraphLibCommand.blockPosText(to)), true);
        return 15;
    }

    private static int removeEmptyGraphsCommand(class_2168 source, class_2960 universeId) throws CommandSyntaxException {
        GraphUniverseImpl universe = (GraphUniverseImpl)GraphLibImpl.UNIVERSE.method_10223(universeId);
        if (universe == null) {
            throw UNKNOWN_UNIVERSE.create((Object)universeId);
        }
        int result = universe.getServerGraphWorld(source.method_9225()).removeEmptyGraphs();
        source.method_9226(() -> Constants.command("graphlib.removeemptygraphs.success", result), true);
        return result;
    }

    private static int rebuildChunks(final class_2168 source, final class_2960 universeId, class_2338 from, class_2338 to) throws CommandSyntaxException {
        class_3218 world = source.method_9225();
        GraphUniverseImpl universe = (GraphUniverseImpl)GraphLibImpl.UNIVERSE.method_10223(universeId);
        if (universe == null) {
            throw UNKNOWN_UNIVERSE.create((Object)universeId);
        }
        final class_4076 fromSection = class_4076.method_18682((class_2338)from);
        final class_4076 toSection = class_4076.method_18682((class_2338)to);
        List<class_4076> toRebuild = class_4076.method_20438((int)fromSection.method_10263(), (int)fromSection.method_10264(), (int)fromSection.method_10260(), (int)toSection.method_10263(), (int)toSection.method_10264(), (int)toSection.method_10260()).toList();
        universe.getServerGraphWorld(world).rebuildChunks(toRebuild, new RebuildChunksListener(){

            @Override
            public void onAlreadyRunning(double progress, int graphCount, int chunkCount) {
                source.method_9226(() -> Constants.command("graphlib.rebuildchunks.alreadyrunning", progress, universeId, graphCount, fromSection.method_10263(), fromSection.method_10264(), fromSection.method_10260(), toSection.method_10263(), toSection.method_10264(), toSection.method_10260(), chunkCount), false);
            }

            @Override
            public void onBegin(int graphCount, int chunkCount) {
                source.method_9226(() -> Constants.command("graphlib.rebuildchunks.begin", universeId, graphCount, fromSection.method_10263(), fromSection.method_10264(), fromSection.method_10260(), toSection.method_10263(), toSection.method_10264(), toSection.method_10260(), chunkCount), true);
            }

            @Override
            public void onProgress(double progress, int graphCount, int chunkCount) {
                source.method_9226(() -> Constants.command("graphlib.rebuildchunks.progress", progress, universeId, graphCount, fromSection.method_10263(), fromSection.method_10264(), fromSection.method_10260(), toSection.method_10263(), toSection.method_10264(), toSection.method_10260(), chunkCount), true);
            }

            @Override
            public void onComplete(int graphCount, int chunkCount) {
                source.method_9226(() -> Constants.command("graphlib.rebuildchunks.complete", universeId, graphCount, fromSection.method_10263(), fromSection.method_10264(), fromSection.method_10260(), toSection.method_10263(), toSection.method_10264(), toSection.method_10260(), chunkCount), true);
            }
        });
        return toRebuild.size();
    }

    private static int startDebugRender(class_2168 source, class_2960 universeId) throws CommandSyntaxException {
        GraphUniverseImpl universe = (GraphUniverseImpl)GraphLibImpl.UNIVERSE.method_10223(universeId);
        if (universe == null) {
            throw UNKNOWN_UNIVERSE.create((Object)universeId);
        }
        GLDebugNet.startDebuggingPlayer(source.method_9207(), universe);
        return 15;
    }

    private static int stopDebugRender(class_2168 source, class_2960 universeId) throws CommandSyntaxException {
        GLDebugNet.stopDebuggingPlayer(source.method_9207(), universeId);
        return 15;
    }

    private static class_5250 blockPosText(class_2338 pos) {
        return class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()})).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/tp @s " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.coordinates.tooltip"))));
    }
}

