/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.client.debug.render;

import com.kneelawk.graphlib.api.client.ClientBlockNodeHolder;
import com.kneelawk.graphlib.api.client.render.RenderUtils;
import com.kneelawk.graphlib.api.graph.user.debug.DebugBlockNode;
import com.kneelawk.graphlib.api.graph.user.debug.SidedDebugBlockNode;
import com.kneelawk.graphlib.api.util.EmptyLinkKey;
import com.kneelawk.graphlib.api.util.SidedPos;
import com.kneelawk.graphlib.api.util.graph.Link;
import com.kneelawk.graphlib.api.util.graph.Node;
import com.kneelawk.graphlib.impl.client.GraphLibClientImpl;
import com.kneelawk.graphlib.impl.client.debug.graph.DebugBlockGraph;
import com.kneelawk.graphlib.impl.client.debug.render.BlockNodeDebugRendererHolder;
import com.kneelawk.graphlib.impl.mixin.api.RenderLayerHelper;
import com.kneelawk.kmodlib.client.overlay.RenderToOverlay;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4668;

public final class DebugRenderer {
    public static final Map<class_2960, Long2ObjectMap<DebugBlockGraph>> DEBUG_GRAPHS = new LinkedHashMap<class_2960, Long2ObjectMap<DebugBlockGraph>>();

    private DebugRenderer() {
    }

    public static void init() {
        RenderToOverlay.EVENT.register(DebugRenderer::render);
    }

    private static void render(WorldRenderContext context) {
        if (DEBUG_GRAPHS.isEmpty()) {
            return;
        }
        class_243 camPos = context.camera().method_19326();
        class_4587 stack = context.matrixStack();
        stack.method_22903();
        stack.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        DebugRenderer.renderGraphs(stack);
        stack.method_22909();
    }

    private static void renderGraphs(class_4587 stack) {
        HashMap<NPos, NPosData> nodeEndpoints = new HashMap<NPos, NPosData>();
        for (Long2ObjectMap<DebugBlockGraph> universe : DEBUG_GRAPHS.values()) {
            for (DebugBlockGraph graph : universe.values()) {
                for (Node<ClientBlockNodeHolder, EmptyLinkKey> node : graph.graph()) {
                    Object pos;
                    DebugBlockNode cbn = node.data().node();
                    if (cbn instanceof SidedDebugBlockNode) {
                        SidedDebugBlockNode sidedDebugBlockNode = (SidedDebugBlockNode)cbn;
                        pos = new NSidedPos(new SidedPos(node.data().pos(), sidedDebugBlockNode.getSide()));
                    } else {
                        pos = new NBlockPos(node.data().pos());
                    }
                    ++nodeEndpoints.computeIfAbsent(pos, (Function<NPos, NPosData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$renderGraphs$0(com.kneelawk.graphlib.impl.client.debug.render.DebugRenderer$NPos ), (Lcom/kneelawk/graphlib/impl/client/debug/render/DebugRenderer$NPos;)Lcom/kneelawk/graphlib/impl/client/debug/render/DebugRenderer$NPosData;)()).nodeCount;
                }
            }
        }
        for (Long2ObjectMap<DebugBlockGraph> universe : DEBUG_GRAPHS.values()) {
            for (DebugBlockGraph graph : universe.values()) {
                int graphColor = RenderUtils.graphColor(graph.graphId());
                Object2ObjectLinkedOpenHashMap object2ObjectLinkedOpenHashMap = new Object2ObjectLinkedOpenHashMap(graph.graph().size());
                ObjectLinkedOpenHashSet links = new ObjectLinkedOpenHashSet();
                for (Node node : graph.graph()) {
                    Record pos;
                    DebugBlockNode cbn = ((ClientBlockNodeHolder)node.data()).node();
                    BlockNodeDebugRendererHolder<?> renderer = GraphLibClientImpl.getDebugRenderer(graph.universeId(), cbn.getRenderId());
                    if (renderer == null) continue;
                    if (cbn instanceof SidedDebugBlockNode) {
                        SidedDebugBlockNode scbn = (SidedDebugBlockNode)cbn;
                        pos = new NSidedPos(new SidedPos(((ClientBlockNodeHolder)node.data()).pos(), scbn.getSide()));
                    } else {
                        pos = new NBlockPos(((ClientBlockNodeHolder)node.data()).pos());
                    }
                    NPosData data = (NPosData)nodeEndpoints.get(pos);
                    class_243 endpoint = renderer.getLineEndpoint(cbn, node, graph, data.nodeCount, data.endpoints.size(), data.endpoints);
                    object2ObjectLinkedOpenHashMap.put((Object)node, (Object)endpoint);
                    data.endpoints.add(endpoint);
                    class_2338 origin = ((ClientBlockNodeHolder)node.data()).pos();
                    stack.method_22903();
                    stack.method_46416((float)origin.method_10263(), (float)origin.method_10264(), (float)origin.method_10260());
                    renderer.render(cbn, node, RenderToOverlay.CONSUMERS, stack, graph, endpoint, graphColor);
                    stack.method_22909();
                    links.addAll(node.connections());
                }
                class_4588 consumer = RenderToOverlay.CONSUMERS.getBuffer(Layers.DEBUG_LINES);
                for (Link link : links) {
                    Node nodeA = link.first();
                    Node nodeB = link.second();
                    if (!object2ObjectLinkedOpenHashMap.containsKey(nodeA) || !object2ObjectLinkedOpenHashMap.containsKey(nodeB)) continue;
                    class_243 endpointA = (class_243)object2ObjectLinkedOpenHashMap.get(nodeA);
                    class_243 endpointB = (class_243)object2ObjectLinkedOpenHashMap.get(nodeB);
                    class_2338 posA = ((ClientBlockNodeHolder)nodeA.data()).pos();
                    class_2338 posB = ((ClientBlockNodeHolder)nodeB.data()).pos();
                    RenderUtils.drawLine(stack, consumer, (float)((double)posA.method_10263() + endpointA.field_1352), (float)((double)posA.method_10264() + endpointA.field_1351), (float)((double)posA.method_10260() + endpointA.field_1350), (float)((double)posB.method_10263() + endpointB.field_1352), (float)((double)posB.method_10264() + endpointB.field_1351), (float)((double)posB.method_10260() + endpointB.field_1350), graphColor);
                }
            }
        }
    }

    private static /* synthetic */ NPosData lambda$renderGraphs$0(NPos nPos) {
        return new NPosData();
    }

    static {
        RenderToOverlay.LAYER_MAP.put((Object)Layers.DEBUG_LINES, (Object)new class_287(Layers.DEBUG_LINES.method_22722()));
        RenderToOverlay.LAYER_MAP.put((Object)Layers.DEBUG_QUADS, (Object)new class_287(Layers.DEBUG_QUADS.method_22722()));
    }

    private record NSidedPos(SidedPos pos) implements NPos
    {
    }

    private record NBlockPos(class_2338 pos) implements NPos
    {
    }

    private static class NPosData {
        int nodeCount = 0;
        List<class_243> endpoints = new ArrayList<class_243>();

        private NPosData() {
        }
    }

    public static final class Layers
    extends class_4668 {
        public static final class_1921 DEBUG_LINES = RenderLayerHelper.of("debug_lines", class_290.field_29337, class_293.class_5596.field_27377, 256, false, false, class_1921.class_4688.method_23598().method_34578(class_4668.field_29433).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23615(class_4668.field_21370).method_23616(class_4668.field_21349).method_23603(class_4668.field_21345).method_23617(false));
        public static final class_1921 DEBUG_QUADS = RenderLayerHelper.of("debug_quads", class_290.field_1576, class_293.class_5596.field_27382, 256, false, false, class_1921.class_4688.method_23598().method_34578(class_4668.field_29442).method_23615(class_4668.field_21370).method_23616(class_4668.field_21349).method_23603(class_4668.field_21345).method_23617(false));

        private Layers(String string, Runnable runnable, Runnable runnable2) {
            super(string, runnable, runnable2);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface NPos {
    }
}

