/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.client;

import com.kneelawk.graphlib.impl.client.ClientProxy;
import com.kneelawk.graphlib.impl.client.GLClientDebugNet;
import com.kneelawk.graphlib.impl.client.GraphLibClientImpl;
import com.kneelawk.graphlib.impl.client.debug.graph.DebugBlockGraph;
import com.kneelawk.graphlib.impl.client.debug.render.DebugRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;

public class GraphLibFabricModClient
implements ClientModInitializer {
    private final LongSet loadedChunks = new LongLinkedOpenHashSet();

    public void onInitializeClient() {
        GraphLibClientImpl.register();
        ClientProxy.init();
        GLClientDebugNet.init();
        DebugRenderer.init();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            DebugRenderer.DEBUG_GRAPHS.clear();
            GraphLibClientImpl.GRAPHS_PER_CHUNK.clear();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            DebugRenderer.DEBUG_GRAPHS.clear();
            GraphLibClientImpl.GRAPHS_PER_CHUNK.clear();
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> this.loadedChunks.add(chunk.method_12004().method_8324()));
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            long chunkLong = chunk.method_12004().method_8324();
            this.loadedChunks.remove(chunkLong);
            Set graphs = (Set)GraphLibClientImpl.GRAPHS_PER_CHUNK.get(chunkLong);
            if (graphs != null) {
                for (DebugBlockGraph graph : new ArrayList(graphs)) {
                    boolean anyChunkLoaded = false;
                    LongIterator longIterator = graph.chunks().iterator();
                    while (longIterator.hasNext()) {
                        long graphChunk = (Long)longIterator.next();
                        if (!this.loadedChunks.contains(graphChunk)) continue;
                        anyChunkLoaded = true;
                        break;
                    }
                    if (anyChunkLoaded) continue;
                    Long2ObjectMap<DebugBlockGraph> universe = DebugRenderer.DEBUG_GRAPHS.get(graph.universeId());
                    universe.remove(graph.graphId());
                    if (universe.isEmpty()) {
                        DebugRenderer.DEBUG_GRAPHS.remove(graph.universeId());
                    }
                    GraphLibClientImpl.removeGraphChunks(graph);
                }
            }
        });
    }
}

