/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.client;

import com.kneelawk.graphlib.api.client.BlockNodeDebugPacketDecoder;
import com.kneelawk.graphlib.api.client.GraphLibClient;
import com.kneelawk.graphlib.impl.Constants;
import com.kneelawk.graphlib.impl.client.debug.graph.DebugBlockGraph;
import com.kneelawk.graphlib.impl.client.debug.graph.SimpleDebugBlockNode;
import com.kneelawk.graphlib.impl.client.debug.graph.SimpleDebugSidedBlockNode;
import com.kneelawk.graphlib.impl.client.debug.render.BlockNodeDebugRendererHolder;
import com.kneelawk.graphlib.impl.client.debug.render.SimpleBlockNodeDebugRenderer;
import com.kneelawk.graphlib.impl.client.debug.render.SimpleSidedBlockNodeDebugRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GraphLibClientImpl {
    public static final Map<class_2960, Map<class_2960, BlockNodeDebugPacketDecoder>> DEBUG_DECODERS = new HashMap<class_2960, Map<class_2960, BlockNodeDebugPacketDecoder>>();
    public static final Map<class_2960, Map<class_2960, BlockNodeDebugRendererHolder<?>>> DEBUG_RENDERERS = new HashMap();
    public static final Map<class_2960, BlockNodeDebugRendererHolder<?>> ALL_UNIVERSE_DEBUG_RENDERERS = new HashMap();
    public static final Long2ObjectMap<Set<DebugBlockGraph>> GRAPHS_PER_CHUNK = new Long2ObjectLinkedOpenHashMap();

    private GraphLibClientImpl() {
    }

    @Nullable
    public static BlockNodeDebugPacketDecoder getDebugDecoder(class_2960 universeId, class_2960 typeId) {
        Map<class_2960, BlockNodeDebugPacketDecoder> universeDecoders = DEBUG_DECODERS.get(universeId);
        if (universeDecoders == null) {
            return null;
        }
        return universeDecoders.get(typeId);
    }

    @Nullable
    public static BlockNodeDebugRendererHolder<?> getDebugRenderer(class_2960 universeId, class_2960 renderId) {
        Map<class_2960, BlockNodeDebugRendererHolder<?>> universeRenderers = DEBUG_RENDERERS.get(universeId);
        if (universeRenderers == null) {
            return ALL_UNIVERSE_DEBUG_RENDERERS.get(renderId);
        }
        BlockNodeDebugRendererHolder<?> holder = universeRenderers.get(renderId);
        if (holder == null) {
            return ALL_UNIVERSE_DEBUG_RENDERERS.get(renderId);
        }
        return holder;
    }

    static void register() {
        GraphLibClient.registerDebugRendererForAllUniverses(Constants.id("simple"), SimpleDebugBlockNode.class, SimpleBlockNodeDebugRenderer.INSTANCE);
        GraphLibClient.registerDebugRendererForAllUniverses(Constants.id("simple_sided"), SimpleDebugSidedBlockNode.class, SimpleSidedBlockNodeDebugRenderer.INSTANCE);
    }

    static void removeGraphChunks(DebugBlockGraph graph) {
        LongIterator longIterator = graph.chunks().iterator();
        while (longIterator.hasNext()) {
            long graphChunk = (Long)longIterator.next();
            Set graphsAt = (Set)GRAPHS_PER_CHUNK.get(graphChunk);
            if (graphsAt == null) continue;
            graphsAt.remove(graph);
            if (!graphsAt.isEmpty()) continue;
            GRAPHS_PER_CHUNK.remove(graphChunk);
        }
    }
}

