/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl.client;

import com.kneelawk.graphlib.api.client.BlockNodeDebugPacketDecoder;
import com.kneelawk.graphlib.api.client.ClientBlockNodeHolder;
import com.kneelawk.graphlib.api.graph.user.debug.DebugBlockNode;
import com.kneelawk.graphlib.api.util.EmptyLinkKey;
import com.kneelawk.graphlib.api.util.graph.Graph;
import com.kneelawk.graphlib.api.util.graph.Node;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.client.GraphLibClientImpl;
import com.kneelawk.graphlib.impl.client.debug.graph.DebugBlockGraph;
import com.kneelawk.graphlib.impl.client.debug.graph.SimpleDebugBlockNode;
import com.kneelawk.graphlib.impl.client.debug.graph.SimpleDebugSidedBlockNode;
import com.kneelawk.graphlib.impl.client.debug.render.DebugRenderer;
import com.kneelawk.graphlib.impl.net.GLDebugNet;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class GLClientDebugNet {
    private static final Map<Integer, class_2960> idMap = Collections.synchronizedMap(new Int2ObjectLinkedOpenHashMap());
    public static final BlockNodeDebugPacketDecoder DEFAULT_DECODER = buf -> {
        int hashCode = buf.readInt();
        int color = buf.readInt();
        byte type = buf.readByte();
        return switch (type) {
            case 0 -> new SimpleDebugBlockNode(hashCode, color);
            case 1 -> new SimpleDebugSidedBlockNode(hashCode, color, class_2350.method_10143((int)buf.readByte()));
            default -> {
                GLLog.error("Attempted default BlockNode decoding but encountered unknown default id: {}", (Object)type);
                yield null;
            }
        };
    };

    private GLClientDebugNet() {
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GLDebugNet.ID_MAP_BULK_ID, (client, handler, buf, responseSender) -> {
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                class_2960 id = buf.method_10810();
                int index = buf.method_10816();
                idMap.put(index, id);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GLDebugNet.ID_MAP_PUT_ID, (client, handler, buf, responseSender) -> {
            class_2960 id = buf.method_10810();
            int index = buf.method_10816();
            idMap.put(index, id);
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GLDebugNet.GRAPH_UPDATE_ID, (client, handler, buf, responseSender) -> {
            int universeInt = buf.method_10816();
            class_2960 universeId = idMap.get(universeInt);
            if (universeId == null) {
                GLLog.error("Received unknown universe id: {}", (Object)universeInt);
                return;
            }
            DebugBlockGraph debugGraph = GLClientDebugNet.decodeBlockGraph(universeId, buf);
            if (debugGraph == null) {
                return;
            }
            client.execute(() -> GLClientDebugNet.addBlockGraph(universeId, debugGraph));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GLDebugNet.GRAPH_UPDATE_BULK_ID, (client, handler, buf, responseSender) -> {
            int universeInt = buf.method_10816();
            class_2960 universeId = idMap.get(universeInt);
            if (universeId == null) {
                GLLog.error("Received unknown universe id: {}", (Object)universeInt);
                return;
            }
            int graphCount = buf.method_10816();
            ArrayList<DebugBlockGraph> graphs = new ArrayList<DebugBlockGraph>(graphCount);
            for (int i = 0; i < graphCount; ++i) {
                DebugBlockGraph debugGraph = GLClientDebugNet.decodeBlockGraph(universeId, buf);
                if (debugGraph == null) {
                    return;
                }
                graphs.add(debugGraph);
            }
            client.execute(() -> {
                for (DebugBlockGraph debugGraph : graphs) {
                    GLClientDebugNet.addBlockGraph(universeId, debugGraph);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GLDebugNet.GRAPH_DESTROY_ID, (client, handler, buf, responseSender) -> {
            int universeInt = buf.method_10816();
            class_2960 universeId = idMap.get(universeInt);
            if (universeId == null) {
                GLLog.error("Received unknown universe id: {}", (Object)universeInt);
                return;
            }
            long graphId = buf.readLong();
            client.execute(() -> {
                Long2ObjectMap<DebugBlockGraph> universe = DebugRenderer.DEBUG_GRAPHS.get(universeId);
                if (universe == null) {
                    GLLog.warn("Received GRAPH_DESTROY for un-tracked universe: {}", (Object)universeId);
                    return;
                }
                DebugBlockGraph graph = (DebugBlockGraph)universe.remove(graphId);
                if (universe.isEmpty()) {
                    DebugRenderer.DEBUG_GRAPHS.remove(universeId);
                }
                if (graph != null) {
                    GraphLibClientImpl.removeGraphChunks(graph);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GLDebugNet.DEBUGGING_STOP_ID, (client, handler, buf, responseSender) -> {
            int universeInt = buf.method_10816();
            client.execute(() -> {
                class_2960 universeId = idMap.get(universeInt);
                if (universeId == null) {
                    GLLog.error("Received unknown universe id: {}", (Object)universeInt);
                    return;
                }
                Long2ObjectMap<DebugBlockGraph> universe = DebugRenderer.DEBUG_GRAPHS.remove(universeId);
                if (DebugRenderer.DEBUG_GRAPHS.isEmpty()) {
                    GraphLibClientImpl.GRAPHS_PER_CHUNK.clear();
                } else {
                    if (universe == null) {
                        GLLog.warn("Received DEBUGGING_STOP for un-tracked universe: {}", (Object)universeId);
                        return;
                    }
                    for (DebugBlockGraph graph : universe.values()) {
                        GraphLibClientImpl.removeGraphChunks(graph);
                    }
                }
            });
        });
    }

    @Nullable
    private static DebugBlockGraph decodeBlockGraph(class_2960 universeId, class_2540 buf) {
        Graph<ClientBlockNodeHolder, EmptyLinkKey> graph = new Graph<ClientBlockNodeHolder, EmptyLinkKey>();
        ArrayList<Node<ClientBlockNodeHolder, EmptyLinkKey>> nodeList = new ArrayList<Node<ClientBlockNodeHolder, EmptyLinkKey>>();
        LongLinkedOpenHashSet chunks = new LongLinkedOpenHashSet();
        long graphId = buf.readLong();
        int nodeCount = buf.method_10816();
        for (int i = 0; i < nodeCount; ++i) {
            DebugBlockNode data;
            int nodeTypeInt = buf.method_10816();
            class_2960 nodeTypeId = idMap.get(nodeTypeInt);
            if (nodeTypeId == null) {
                GLLog.error("Received unknown BlockNode id: {}", (Object)nodeTypeInt);
                return null;
            }
            class_2338 pos = buf.method_10811();
            BlockNodeDebugPacketDecoder decoder = GraphLibClientImpl.getDebugDecoder(universeId, nodeTypeId);
            if (decoder == null) {
                decoder = DEFAULT_DECODER;
            }
            if ((data = decoder.fromPacket(buf)) == null) {
                GLLog.error("Unable to decode BlockNode packet for {}", (Object)nodeTypeId);
                return null;
            }
            Node<ClientBlockNodeHolder, EmptyLinkKey> node = graph.add(new ClientBlockNodeHolder(pos, data, graphId));
            nodeList.add(node);
            chunks.add(class_1923.method_37232((class_2338)pos));
        }
        int linkCount = buf.method_10816();
        for (int i = 0; i < linkCount; ++i) {
            int nodeAIndex = buf.method_10816();
            int nodeBIndex = buf.method_10816();
            if (nodeAIndex < 0 || nodeAIndex >= nodeList.size()) {
                GLLog.warn("Received packet with invalid links. Node {} points to nothing.", (Object)nodeAIndex);
                continue;
            }
            if (nodeBIndex < 0 || nodeBIndex >= nodeList.size()) {
                GLLog.warn("Received packet with invalid links. Node {} points to nothing.", (Object)nodeBIndex);
                continue;
            }
            Node nodeA = (Node)nodeList.get(nodeAIndex);
            Node nodeB = (Node)nodeList.get(nodeBIndex);
            graph.link(nodeA, nodeB, EmptyLinkKey.INSTANCE);
        }
        return new DebugBlockGraph(universeId, graphId, graph, (LongSet)chunks);
    }

    private static void addBlockGraph(class_2960 universeId, DebugBlockGraph debugGraph) {
        DebugBlockGraph oldGraph;
        Long2ObjectLinkedOpenHashMap universe = DebugRenderer.DEBUG_GRAPHS.get(universeId);
        if (universe == null) {
            universe = new Long2ObjectLinkedOpenHashMap();
            DebugRenderer.DEBUG_GRAPHS.put(universeId, (Long2ObjectMap<DebugBlockGraph>)universe);
        }
        if ((oldGraph = (DebugBlockGraph)universe.put(debugGraph.graphId(), (Object)debugGraph)) != null) {
            GraphLibClientImpl.removeGraphChunks(oldGraph);
        }
        LongIterator longIterator = debugGraph.chunks().iterator();
        while (longIterator.hasNext()) {
            long chunk = (Long)longIterator.next();
            LinkedHashSet<DebugBlockGraph> chunkSet = (LinkedHashSet<DebugBlockGraph>)GraphLibClientImpl.GRAPHS_PER_CHUNK.get(chunk);
            if (chunkSet == null) {
                chunkSet = new LinkedHashSet<DebugBlockGraph>();
                chunkSet.add(debugGraph);
                GraphLibClientImpl.GRAPHS_PER_CHUNK.put(chunk, chunkSet);
                continue;
            }
            chunkSet.add(debugGraph);
        }
    }
}

