/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl;

import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.GraphLibImpl;
import com.kneelawk.graphlib.impl.graph.ServerGraphWorldStorage;
import com.kneelawk.graphlib.impl.mixin.api.StorageHelper;
import com.kneelawk.graphlib.impl.net.GLDebugNet;
import com.kneelawk.graphlib.impl.net.GLNet;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;

public class GraphLibFabricMod
implements ModInitializer {
    public void onInitialize() {
        GLLog.setGameDir(FabricLoader.getInstance().getGameDir());
        GLLog.info("Initializing GraphLib...");
        GraphLibImpl.register();
        GLNet.init();
        GLDebugNet.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> GraphLibImpl.registerCommands((CommandDispatcher<class_2168>)dispatcher, context));
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            try {
                StorageHelper.getStorage(world).onWorldChunkLoad(chunk.method_12004());
            }
            catch (Exception e) {
                GLLog.error("Error loading chunk in GraphWorldStorage. World: '{}'/{}, Chunk: {}", world, world.method_27983().method_29177(), chunk.method_12004(), e);
            }
        });
        ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            try {
                ServerGraphWorldStorage storage = StorageHelper.getStorage(world);
                storage.saveChunk(chunk.method_12004());
                storage.onWorldChunkUnload(chunk.method_12004());
            }
            catch (Exception e) {
                GLLog.error("Error unloading chunk in GraphWorldStorage. World: '{}'/{}, Chunk: {}", world, world.method_27983().method_29177(), chunk.method_12004(), e);
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            try {
                StorageHelper.getStorage(world).tick();
            }
            catch (Exception e) {
                GLLog.error("Error ticking GraphWorldStorage. World: '{}'/{}", world, world.method_27983().method_29177(), e);
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            try {
                StorageHelper.getStorage(world).close();
            }
            catch (Exception e) {
                GLLog.error("Error closing GraphWorldStorage. World: '{}'/{}", world, world.method_27983().method_29177(), e);
            }
        });
        GLLog.info("GraphLib Initialized.");
    }
}

