/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.FileHandler;
import java.util.logging.SimpleFormatter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class GLLog {
    private static final String LOGS_DIR = "logs";
    private static final String GRAPHLIB_DIR = "graphlib";
    private static final String LOG_FILE_NAME = "%s.log";
    private static final DateTimeFormatter timeStampPattern = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final Logger log = LoggerFactory.getLogger((String)"graphlib");
    private static final java.util.logging.Logger fileLogger = java.util.logging.Logger.getLogger("graphlib");
    private static Path gameDir = null;
    private static boolean fileLoggerInitialized = false;

    static void setGameDir(Path dir) {
        gameDir = dir;
    }

    static void ensureLogging() {
        if (!fileLoggerInitialized && gameDir != null) {
            fileLoggerInitialized = true;
            Path logsDir = gameDir.resolve(LOGS_DIR);
            Path graphLibDir = logsDir.resolve(GRAPHLIB_DIR);
            Path logFile = graphLibDir.resolve(LOG_FILE_NAME.formatted(LocalDateTime.now().format(timeStampPattern)));
            try {
                if (!Files.exists(graphLibDir, new LinkOption[0])) {
                    Files.createDirectories(graphLibDir, new FileAttribute[0]);
                }
                FileHandler fh = new FileHandler(logFile.toString());
                fileLogger.addHandler(fh);
                SimpleFormatter sf = new SimpleFormatter();
                fh.setFormatter(sf);
                fileLogger.setUseParentHandlers(false);
            }
            catch (IOException e) {
                log.error("Unable to initialize separate logger.", (Throwable)e);
            }
        }
    }

    private GLLog() {
    }

    public static void debug(String msg, Object arg1) {
        log.debug(msg, arg1);
    }

    public static void info(String msg) {
        log.info(msg);
    }

    public static void info(String msg, Object arg1) {
        log.info(msg, arg1);
    }

    public static void info(String msg, Object arg1, Object arg2) {
        log.info(msg, arg1, arg2);
    }

    public static void info(String msg, Object ... args) {
        log.info(msg, args);
    }

    public static void info(String msg, Throwable t) {
        log.info(msg, t);
    }

    public static void warn(String msg) {
        GLLog.ensureLogging();
        log.warn(msg);
        fileLogger.warning(msg);
    }

    public static void warn(String msg, Object arg1) {
        GLLog.ensureLogging();
        log.warn(msg, arg1);
        fileLogger.warning(GLLog.format(msg, arg1));
    }

    public static void warn(String msg, Object arg1, Object arg2) {
        GLLog.ensureLogging();
        log.warn(msg, arg1, arg2);
        fileLogger.warning(GLLog.format(msg, arg1, arg2));
    }

    public static void warn(String msg, Object ... args) {
        GLLog.ensureLogging();
        log.warn(msg, args);
        fileLogger.warning(GLLog.format(msg, args));
    }

    public static void warn(String msg, Throwable t) {
        GLLog.ensureLogging();
        log.warn(msg, t);
        fileLogger.warning(GLLog.format(msg, t));
    }

    public static void error(String msg) {
        GLLog.ensureLogging();
        log.error(msg);
        fileLogger.severe(msg);
    }

    public static void error(String msg, Object arg1) {
        GLLog.ensureLogging();
        log.error(msg, arg1);
        fileLogger.severe(GLLog.format(msg, arg1));
    }

    public static void error(String msg, Object arg1, Object arg2) {
        GLLog.ensureLogging();
        log.error(msg, arg1, arg2);
        fileLogger.severe(GLLog.format(msg, arg1, arg2));
    }

    public static void error(String msg, Object ... args) {
        GLLog.ensureLogging();
        log.error(msg, args);
        fileLogger.severe(GLLog.format(msg, args));
    }

    public static void error(String msg, Throwable t) {
        GLLog.ensureLogging();
        log.error(msg, t);
        fileLogger.severe(GLLog.format(msg, t));
    }

    private static String format(String msg, Object arg1) {
        FormattingTuple tuple = MessageFormatter.format((String)msg, (Object)arg1);
        return GLLog.format(tuple.getMessage(), tuple.getThrowable());
    }

    private static String format(String msg, Object arg1, Object arg2) {
        FormattingTuple tuple = MessageFormatter.format((String)msg, (Object)arg1, (Object)arg2);
        return GLLog.format(tuple.getMessage(), tuple.getThrowable());
    }

    private static String format(String msg, Object ... args) {
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)msg, (Object[])args);
        return GLLog.format(tuple.getMessage(), tuple.getThrowable());
    }

    private static String format(String msg, Throwable t) {
        if (t == null) {
            return msg;
        }
        return msg + "\n" + ExceptionUtils.getStackTrace((Throwable)t);
    }
}

