/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.world;

import com.kneelawk.graphlib.api.util.ChunkPillarUnloadTimer;
import com.kneelawk.graphlib.api.world.RegionBasedStorage;
import com.kneelawk.graphlib.api.world.SaveMode;
import com.kneelawk.graphlib.api.world.StorageChunk;
import com.kneelawk.graphlib.api.world.TrackingChunkDecoder;
import com.kneelawk.graphlib.api.world.TrackingChunkFactory;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.mixin.api.StorageHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_4698;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnloadingRegionBasedStorage<R extends StorageChunk>
implements RegionBasedStorage<R> {
    private static final int MAX_CHUNK_AGE = 1200;
    private static final int INCREMENTAL_SAVE_FACTOR = 10;
    private final class_3218 world;
    private final TrackingChunkDecoder<R> loadFromNbt;
    private final TrackingChunkFactory<R> createNew;
    private final SaveMode saveMode;
    private final class_4698 worker;
    private final ChunkPillarUnloadTimer timer = new ChunkPillarUnloadTimer(1200L);
    private final Long2ObjectMap<Int2ObjectMap<R>> loadedChunks = new Long2ObjectOpenHashMap();
    private final LongSet unsavedPillars = new LongOpenHashSet();
    private boolean closed = false;

    public UnloadingRegionBasedStorage(@NotNull class_3218 world, @NotNull Path path, boolean syncChunkWrites, @NotNull @NotNull TrackingChunkDecoder<@NotNull R> loadFromNbt, @NotNull @NotNull TrackingChunkFactory<@NotNull R> createNew, @NotNull SaveMode saveMode) {
        this.world = world;
        this.loadFromNbt = loadFromNbt;
        this.createNew = createNew;
        this.saveMode = saveMode;
        this.worker = StorageHelper.newWorker(path, syncChunkWrites, path.getFileName().toString());
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.saveAll();
        this.worker.close();
    }

    @Override
    public void onWorldChunkLoad(@NotNull class_1923 pos) {
        if (this.closed) {
            return;
        }
        this.timer.onWorldChunkLoad(pos);
        this.loadChunkPillar(pos);
    }

    @Override
    public void onWorldChunkUnload(@NotNull class_1923 pos) {
        this.timer.onWorldChunkUnload(pos);
    }

    @Override
    @NotNull
    public R getOrCreate(@NotNull class_4076 pos) {
        class_1923 chunkPos = pos.method_18692();
        this.timer.onChunkUse(chunkPos);
        long longPos = chunkPos.method_8324();
        Int2ObjectMap pillar = (Int2ObjectMap)this.loadedChunks.get(longPos);
        if (pillar != null) {
            return (R)((StorageChunk)pillar.computeIfAbsent(pos.method_10264(), y -> this.createNew(pos, chunkPos)));
        }
        pillar = new Int2ObjectOpenHashMap();
        try {
            Optional root = (Optional)this.worker.method_31738(chunkPos).join();
            if (root.isPresent()) {
                this.loadChunkPillar(chunkPos, pillar, (class_2487)root.get());
                StorageChunk section = (StorageChunk)pillar.get(pos.method_10264());
                if (section == null) {
                    section = this.createNew(pos, chunkPos);
                    pillar.put(pos.method_10264(), (Object)section);
                }
                return (R)section;
            }
            R created = this.createNew(pos, chunkPos);
            pillar.put(pos.method_10264(), created);
            this.loadedChunks.put(longPos, (Object)pillar);
            return created;
        }
        catch (Exception e) {
            GLLog.error("Error loading chunk pillar {}. Discarding chunk.", (Object)chunkPos, (Object)e);
            R created = this.createNew(pos, chunkPos);
            pillar.put(pos.method_10264(), created);
            this.loadedChunks.put(longPos, (Object)pillar);
            return created;
        }
    }

    @NotNull
    private R createNew(@NotNull class_4076 pos, class_1923 chunkPos) {
        this.markDirty(chunkPos);
        return this.createNew.createNew(pos, () -> this.markDirty(chunkPos));
    }

    @Override
    @Nullable
    public R getIfExists(@NotNull class_4076 pos) {
        class_1923 chunkPos = pos.method_18692();
        Int2ObjectMap pillar = (Int2ObjectMap)this.loadedChunks.get(chunkPos.method_8324());
        if (pillar != null) {
            this.timer.onChunkUse(chunkPos);
            return (R)((StorageChunk)pillar.get(pos.method_10264()));
        }
        try {
            Optional root = (Optional)this.worker.method_31738(chunkPos).join();
            if (root.isPresent()) {
                this.timer.onChunkUse(chunkPos);
                pillar = new Int2ObjectOpenHashMap();
                this.loadChunkPillar(chunkPos, pillar, (class_2487)root.get());
                return (R)((StorageChunk)pillar.get(pos.method_10264()));
            }
            this.timer.onChunkUse(chunkPos);
            this.loadedChunks.put(chunkPos.method_8324(), (Object)new Int2ObjectOpenHashMap());
            return null;
        }
        catch (Exception e) {
            GLLog.error("Error loading chunk pillar {}.", (Object)chunkPos, (Object)e);
            return null;
        }
    }

    private CompletableFuture<Void> loadChunkPillar(@NotNull class_1923 chunkPos) {
        if (!this.loadedChunks.containsKey(chunkPos.method_8324())) {
            return this.worker.method_31738(chunkPos).thenAcceptAsync(root -> {
                try {
                    if (!this.loadedChunks.containsKey(chunkPos.method_8324())) {
                        if (root.isPresent()) {
                            this.timer.onChunkUse(chunkPos);
                            Int2ObjectOpenHashMap pillar = new Int2ObjectOpenHashMap();
                            this.loadChunkPillar(chunkPos, (Int2ObjectMap<R>)pillar, (class_2487)root.get());
                        } else {
                            this.timer.onChunkUse(chunkPos);
                            this.loadedChunks.put(chunkPos.method_8324(), (Object)new Int2ObjectOpenHashMap());
                        }
                    }
                }
                catch (Exception e) {
                    GLLog.error("Error loading chunk pillar {}.", (Object)chunkPos, (Object)e);
                }
            }, (Executor)this.world.method_8503());
        }
        return CompletableFuture.completedFuture(null);
    }

    private void loadChunkPillar(@NotNull class_1923 chunkPos, @NotNull Int2ObjectMap<R> pillar, @NotNull class_2487 root) {
        class_2487 sectionsTag = root.method_10562("Sections");
        for (int sectionY = this.world.method_32891(); sectionY < this.world.method_31597(); ++sectionY) {
            if (!sectionsTag.method_10573(String.valueOf(sectionY), 10)) continue;
            class_2487 sectionTag = sectionsTag.method_10562(String.valueOf(sectionY));
            try {
                R section = this.loadFromNbt.decode(sectionTag, class_4076.method_18676((int)chunkPos.field_9181, (int)sectionY, (int)chunkPos.field_9180), () -> this.markDirty(chunkPos));
                pillar.put(sectionY, section);
                continue;
            }
            catch (Exception e) {
                GLLog.error("Error loading chunk {} section {}. Discarding chunk section.", chunkPos, sectionY, e);
            }
        }
        this.loadedChunks.put(chunkPos.method_8324(), pillar);
    }

    private void markDirty(class_1923 pos) {
        this.unsavedPillars.add(pos.method_8324());
    }

    @Override
    public void tick() {
        this.timer.tick();
        for (class_1923 pos : this.timer.chunksToUnload()) {
            if (this.unsavedPillars.contains(pos.method_8324())) {
                this.saveChunk(pos);
            }
            this.unsavedPillars.remove(pos.method_8324());
            this.loadedChunks.remove(pos.method_8324());
            this.timer.onChunkUnload(pos);
        }
        if (!(this.unsavedPillars.isEmpty() || this.saveMode != SaveMode.INCREMENTAL && this.saveMode != SaveMode.IMMEDIATE)) {
            LongIterator iter = this.unsavedPillars.longIterator();
            for (int saveCount = this.saveMode == SaveMode.IMMEDIATE ? this.unsavedPillars.size() : (this.unsavedPillars.size() + 10 - 1) / 10; iter.hasNext() && saveCount > 0; --saveCount) {
                class_1923 pos = new class_1923(iter.nextLong());
                this.saveChunk(pos);
                iter.remove();
            }
        }
    }

    @Override
    public void saveAll() {
        LongIterator longIterator = this.loadedChunks.keySet().iterator();
        while (longIterator.hasNext()) {
            long key = (Long)longIterator.next();
            this.saveChunk(new class_1923(key));
        }
    }

    @Override
    public void saveChunk(@NotNull class_1923 pos) {
        Int2ObjectMap sections = (Int2ObjectMap)this.loadedChunks.get(pos.method_8324());
        if (sections != null && !sections.isEmpty()) {
            class_2487 root = new class_2487();
            class_2487 sectionsTag = new class_2487();
            for (int sectionY = this.world.method_32891(); sectionY < this.world.method_31597(); ++sectionY) {
                StorageChunk section = (StorageChunk)sections.get(sectionY);
                if (section == null) continue;
                try {
                    class_2487 nbt = new class_2487();
                    section.toNbt(nbt);
                    sectionsTag.method_10566(String.valueOf(sectionY), (class_2520)nbt);
                    continue;
                }
                catch (Exception e) {
                    GLLog.error("Error saving chunk {}, section {}", pos, sectionY, e);
                }
            }
            root.method_10566("Sections", (class_2520)sectionsTag);
            this.worker.method_23703(pos, root);
        } else {
            this.worker.method_23703(pos, null);
        }
    }
}

